/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spin;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.FN;
import org.eclipse.rdf4j.query.algebra.evaluation.function.FunctionRegistry;

final class SpinWellKnownFunctions {
    private static final ValueFactory valueFactory = SimpleValueFactory.getInstance();
    private static final FunctionRegistry functionRegistry = FunctionRegistry.getInstance();
    static final SpinWellKnownFunctions INSTANCE = new SpinWellKnownFunctions();
    private final BiMap<String, IRI> stringToUri = HashBiMap.create((int)64);
    private final BiMap<IRI, String> uriToString = this.stringToUri.inverse();

    public SpinWellKnownFunctions() {
        this.stringToUri.put((Object)FN.SUBSTRING.stringValue(), (Object)valueFactory.createIRI("http://spinrdf.org/sp#", "substr"));
        this.stringToUri.put((Object)FN.SUBSTRING_BEFORE.stringValue(), (Object)valueFactory.createIRI("http://spinrdf.org/sp#", "strbefore"));
        this.stringToUri.put((Object)FN.SUBSTRING_AFTER.stringValue(), (Object)valueFactory.createIRI("http://spinrdf.org/sp#", "strafter"));
        this.stringToUri.put((Object)FN.STARTS_WITH.stringValue(), (Object)valueFactory.createIRI("http://spinrdf.org/sp#", "strstarts"));
        this.stringToUri.put((Object)FN.ENDS_WITH.stringValue(), (Object)valueFactory.createIRI("http://spinrdf.org/sp#", "strends"));
        this.stringToUri.put((Object)FN.STRING_LENGTH.stringValue(), (Object)valueFactory.createIRI("http://spinrdf.org/sp#", "strlen"));
        this.stringToUri.put((Object)FN.CONCAT.stringValue(), (Object)valueFactory.createIRI("http://spinrdf.org/sp#", "concat"));
        this.stringToUri.put((Object)FN.CONTAINS.stringValue(), (Object)valueFactory.createIRI("http://spinrdf.org/sp#", "contains"));
        this.stringToUri.put((Object)FN.LOWER_CASE.stringValue(), (Object)valueFactory.createIRI("http://spinrdf.org/sp#", "lcase"));
        this.stringToUri.put((Object)FN.UPPER_CASE.stringValue(), (Object)valueFactory.createIRI("http://spinrdf.org/sp#", "ucase"));
        this.stringToUri.put((Object)FN.REPLACE.stringValue(), (Object)valueFactory.createIRI("http://spinrdf.org/sp#", "replace"));
        this.stringToUri.put((Object)FN.NUMERIC_ABS.stringValue(), (Object)valueFactory.createIRI("http://spinrdf.org/sp#", "abs"));
        this.stringToUri.put((Object)FN.NUMERIC_CEIL.stringValue(), (Object)valueFactory.createIRI("http://spinrdf.org/sp#", "ceil"));
        this.stringToUri.put((Object)FN.NUMERIC_FLOOR.stringValue(), (Object)valueFactory.createIRI("http://spinrdf.org/sp#", "floor"));
        this.stringToUri.put((Object)FN.NUMERIC_ROUND.stringValue(), (Object)valueFactory.createIRI("http://spinrdf.org/sp#", "round"));
        this.stringToUri.put((Object)FN.YEAR_FROM_DATETIME.stringValue(), (Object)valueFactory.createIRI("http://spinrdf.org/sp#", "year"));
        this.stringToUri.put((Object)FN.MONTH_FROM_DATETIME.stringValue(), (Object)valueFactory.createIRI("http://spinrdf.org/sp#", "month"));
        this.stringToUri.put((Object)FN.DAY_FROM_DATETIME.stringValue(), (Object)valueFactory.createIRI("http://spinrdf.org/sp#", "day"));
        this.stringToUri.put((Object)FN.HOURS_FROM_DATETIME.stringValue(), (Object)valueFactory.createIRI("http://spinrdf.org/sp#", "hours"));
        this.stringToUri.put((Object)FN.MINUTES_FROM_DATETIME.stringValue(), (Object)valueFactory.createIRI("http://spinrdf.org/sp#", "minutes"));
        this.stringToUri.put((Object)FN.SECONDS_FROM_DATETIME.stringValue(), (Object)valueFactory.createIRI("http://spinrdf.org/sp#", "seconds"));
        this.stringToUri.put((Object)FN.TIMEZONE_FROM_DATETIME.stringValue(), (Object)valueFactory.createIRI("http://spinrdf.org/sp#", "timezone"));
        this.stringToUri.put((Object)FN.ENCODE_FOR_URI.stringValue(), (Object)valueFactory.createIRI("http://spinrdf.org/sp#", "encode_for_uri"));
        this.stringToUri.put((Object)"NOW", (Object)valueFactory.createIRI("http://spinrdf.org/sp#", "now"));
        this.stringToUri.put((Object)"RAND", (Object)valueFactory.createIRI("http://spinrdf.org/sp#", "rand"));
        this.stringToUri.put((Object)"STRDT", (Object)valueFactory.createIRI("http://spinrdf.org/sp#", "strdt"));
        this.stringToUri.put((Object)"STRLANG", (Object)valueFactory.createIRI("http://spinrdf.org/sp#", "strlang"));
        this.stringToUri.put((Object)"TZ", (Object)valueFactory.createIRI("http://spinrdf.org/sp#", "tz"));
        this.stringToUri.put((Object)"UUID", (Object)valueFactory.createIRI("http://spinrdf.org/sp#", "uuid"));
        this.stringToUri.put((Object)"STRUUID", (Object)valueFactory.createIRI("http://spinrdf.org/sp#", "struuid"));
        this.stringToUri.put((Object)"MD5", (Object)valueFactory.createIRI("http://spinrdf.org/sp#", "md5"));
        this.stringToUri.put((Object)"SHA1", (Object)valueFactory.createIRI("http://spinrdf.org/sp#", "sha1"));
        this.stringToUri.put((Object)"SHA256", (Object)valueFactory.createIRI("http://spinrdf.org/sp#", "sha256"));
        this.stringToUri.put((Object)"SHA384", (Object)valueFactory.createIRI("http://spinrdf.org/sp#", "sha384"));
        this.stringToUri.put((Object)"SHA512", (Object)valueFactory.createIRI("http://spinrdf.org/sp#", "sha512"));
    }

    public IRI getURI(String name) {
        IRI iri = (IRI)this.stringToUri.get((Object)name);
        if (iri == null && functionRegistry.has(name)) {
            iri = valueFactory.createIRI(name);
        }
        return iri;
    }

    public String getName(IRI IRI2) {
        String name = (String)this.uriToString.get((Object)IRI2);
        if (name == null && functionRegistry.has(IRI2.stringValue())) {
            name = IRI2.stringValue();
        }
        return name;
    }
}

