/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Objects;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.NodeKindConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeKindFilter
extends FilterPlanNode {
    private static final Logger logger = LoggerFactory.getLogger(NodeKindFilter.class);
    private final NodeKindConstraintComponent.NodeKind nodeKind;

    public NodeKindFilter(PlanNode parent, NodeKindConstraintComponent.NodeKind nodeKind, ConnectionsGroup connectionsGroup) {
        super(parent, connectionsGroup);
        this.nodeKind = nodeKind;
    }

    @Override
    boolean checkTuple(FilterPlanNode.Reference t) {
        Value value = t.get().getValue();
        switch (this.nodeKind) {
            case IRI: {
                if (!value.isIRI()) break;
                logger.trace("Tuple accepted because its value is an IRI. Tuple: {}", (Object)t);
                return true;
            }
            case Literal: {
                if (!value.isLiteral()) break;
                logger.trace("Tuple accepted because its value is a Literal. Tuple: {}", (Object)t);
                return true;
            }
            case BlankNode: {
                if (!value.isBNode()) break;
                logger.trace("Tuple accepted because its value is a BlankNode. Tuple: {}", (Object)t);
                return true;
            }
            case IRIOrLiteral: {
                if (!value.isIRI() && !value.isLiteral()) break;
                logger.trace("Tuple accepted because its value is an IRI or Literal. Tuple: {}", (Object)t);
                return true;
            }
            case BlankNodeOrIRI: {
                if (!value.isBNode() && !value.isIRI()) break;
                logger.trace("Tuple accepted because its value is a BlankNode or IRI. Tuple: {}", (Object)t);
                return true;
            }
            case BlankNodeOrLiteral: {
                if (!value.isBNode() && !value.isLiteral()) break;
                logger.trace("Tuple accepted because its value is a BlankNode or Literal. Tuple: {}", (Object)t);
                return true;
            }
        }
        logger.debug("Tuple rejected because its value does not match the expected node kind. Tuple: {}", (Object)t);
        return false;
    }

    @Override
    public String toString() {
        return "NodeKindFilter{nodeKind=" + this.nodeKind + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeKindFilter that = (NodeKindFilter)o;
        return this.nodeKind == that.nodeKind;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.nodeKind});
    }
}

