/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.optimizer;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractSimpleQueryModelVisitor;

public class ProjectionRemovalOptimizer
implements QueryOptimizer {
    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit(new ProjectionFinder());
    }

    private static class ProjectionFinder
    extends AbstractSimpleQueryModelVisitor<RuntimeException> {
        private ProjectionFinder() {
            super(true);
        }

        @Override
        public void meet(Projection node) throws RuntimeException {
            super.meet(node);
            VariableFinder findVariables = new VariableFinder();
            node.visit(findVariables);
            Set<String> foundChildVariableNames = findVariables.getVars();
            if (!foundChildVariableNames.isEmpty() && foundChildVariableNames.equals(node.getBindingNames())) {
                TupleExpr child = node.getArg();
                node.getParentNode().replaceChildNode(node, child);
            }
        }
    }

    private static class VariableFinder
    extends AbstractSimpleQueryModelVisitor<RuntimeException> {
        private Set<String> vars;

        private VariableFinder() {
            super(true);
        }

        @Override
        public void meet(Var node) throws RuntimeException {
            if (node.getName() != null) {
                if (this.vars == null) {
                    this.vars = new HashSet<String>();
                }
                this.vars.add(node.getName());
            }
        }

        public Set<String> getVars() {
            return this.vars != null ? this.vars : Collections.emptySet();
        }
    }
}

