/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.values;

import java.util.Set;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryValueEvaluationStep;

public class ScopedQueryValueEvaluationStep
implements QueryValueEvaluationStep {
    private final Set<String> scopeBindingNames;
    private final QueryValueEvaluationStep wrapped;

    public ScopedQueryValueEvaluationStep(Set<String> scopeBindingNames, QueryValueEvaluationStep condition) {
        this.scopeBindingNames = scopeBindingNames;
        this.wrapped = condition;
    }

    @Override
    public Value evaluate(BindingSet bindings) {
        BindingSet scopeBindings = this.createScopeBindings(this.scopeBindingNames, bindings);
        return this.wrapped.evaluate(scopeBindings);
    }

    private BindingSet createScopeBindings(Set<String> scopeBindingNames, BindingSet bindings) {
        QueryBindingSet scopeBindings = new QueryBindingSet(scopeBindingNames.size());
        for (String scopeBindingName : scopeBindingNames) {
            Binding binding = bindings.getBinding(scopeBindingName);
            if (binding == null) continue;
            scopeBindings.addBinding(binding);
        }
        return scopeBindings;
    }
}

