/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.io;

import java.io.IOException;
import java.util.Properties;
import org.eclipse.rdf4j.common.io.ResourceUtil;
import org.slf4j.LoggerFactory;

public class MavenUtil {
    public static Properties loadPomProperties(String groupId, String artifactId) throws IOException {
        String properties = "META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties";
        return ResourceUtil.getProperties(properties);
    }

    public static String loadVersion(String groupId, String artifactId, String defaultVersion) {
        String version = null;
        try {
            Properties pom = MavenUtil.loadPomProperties(groupId, artifactId);
            if (pom != null) {
                version = pom.getProperty("version");
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(MavenUtil.class).warn("Unable to read version info", (Throwable)e);
        }
        if (version == null) {
            version = defaultVersion;
        }
        return version;
    }
}

