/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.sherlock.core;

import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.sherlock.core.IPluginFilter;
import org.eclipse.rcptt.sherlock.core.IStatusFilter;
import org.eclipse.rcptt.sherlock.core.internal.SherlockLogListener;
import org.osgi.framework.BundleContext;

public class SherlockCore
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.rcptt.watson.core";
    private static SherlockCore plugin;
    private final SherlockLogListener logListener = new SherlockLogListener();

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        Platform.addLogListener((ILogListener)this.logListener);
    }

    public void stop(BundleContext context) throws Exception {
        Platform.removeLogListener((ILogListener)this.logListener);
        plugin = null;
        super.stop(context);
    }

    public static SherlockCore getDefault() {
        return plugin;
    }

    public static void addLogListener(ILogListener listener, IStatusFilter statusFilter, IPluginFilter pluginFilter) {
        SherlockCore.getDefault().logListener.addLogListener(listener, statusFilter, pluginFilter);
    }

    public static void removeLogListener(ILogListener listener) {
        SherlockCore.getDefault().logListener.removeLogListener(listener);
    }

    public static void log(String msg) {
        SherlockCore.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, msg, null));
    }

    public static void log(Throwable e) {
        SherlockCore.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, e.getMessage(), e));
    }

    public static void log(String msg, Throwable e) {
        SherlockCore.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, msg, e));
    }

    public static String rlimitSize(String id, int len) {
        if (id.length() > len) {
            return id.substring(0, len);
        }
        return id;
    }

    public static String getID(String value) {
        if (value == null) {
            return null;
        }
        String textResult = "";
        char[] cArray = value.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            textResult = !Character.isLetterOrDigit(c) ? String.valueOf(textResult) + '_' : String.valueOf(textResult) + c;
            ++n2;
        }
        return textResult;
    }
}

