/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.zephyr.ui.properties;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.rcptt.internal.zephyr.ZephyrPlugin;
import org.eclipse.rcptt.zephyr.ZephyrService;
import org.eclipse.rcptt.zephyr.internal.ui.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public final class ZephyrPropertiesPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private ZephyrService service;
    private Combo zephyrProject;
    private Combo zephyrVersion;
    private Combo zephyrCycle;
    private Map<String, Long> zephyrProjects;
    private Map<String, Long> zephyrVersions;
    private Map<String, Long> zephyrCycles;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.service = new ZephyrService();
        this.zephyrProject = this.createCombo(composite, Messages.ZephyrPreferencePage_Project, () -> this.updateVersionList());
        this.zephyrVersion = this.createCombo(composite, Messages.ZephyrPreferencePage_Version, () -> this.updateCycleList());
        this.zephyrCycle = this.createCombo(composite, Messages.ZephyrPreferencePage_Cycle, () -> this.checkCycle());
        this.updateProjectList();
        int projectIndex = this.zephyrProject.indexOf(ZephyrPlugin.getZephyrProject((IProject)this.getRcpttProject()));
        if (projectIndex > -1) {
            this.zephyrProject.select(projectIndex);
            this.updateVersionList();
            int versionIndex = this.zephyrVersion.indexOf(ZephyrPlugin.getZephyrVersion((IProject)this.getRcpttProject()));
            if (versionIndex > -1) {
                this.zephyrVersion.select(versionIndex);
                this.updateCycleList();
                int cycleIndex = this.zephyrCycle.indexOf(ZephyrPlugin.getZephyrCycle((IProject)this.getRcpttProject()));
                if (cycleIndex > -1) {
                    this.zephyrCycle.select(cycleIndex);
                }
            }
        }
        return composite;
    }

    public boolean performOk() {
        System.out.print("Perform");
        ZephyrPlugin.setZephyrProject((String)this.getItemName(this.zephyrProject), (IProject)this.getRcpttProject());
        ZephyrPlugin.setZephyrVersion((String)this.getItemName(this.zephyrVersion), (IProject)this.getRcpttProject());
        ZephyrPlugin.setZephyrCycle((String)this.getItemName(this.zephyrCycle), (IProject)this.getRcpttProject());
        return super.performOk();
    }

    protected void performDefaults() {
        System.out.print("Default");
        ZephyrPlugin.setZephyrProject((String)"", (IProject)this.getRcpttProject());
        ZephyrPlugin.setZephyrVersion((String)"", (IProject)this.getRcpttProject());
        ZephyrPlugin.setZephyrCycle((String)"", (IProject)this.getRcpttProject());
        this.zephyrProject.clearSelection();
        this.zephyrVersion.clearSelection();
        this.zephyrCycle.clearSelection();
        super.performDefaults();
    }

    private Combo createCombo(Composite parent, String labelText, final Runnable runnable) {
        Label label = new Label(parent, 16384);
        label.setText(labelText);
        Combo combo = new Combo(parent, 4);
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                runnable.run();
            }
        });
        combo.setLayoutData((Object)new GridData(768));
        return combo;
    }

    private void updateProjectList() {
        this.zephyrProjects = this.service.getAllProjects();
        this.zephyrProject.setItems(this.getKeyArray(this.zephyrProjects));
        this.zephyrVersion.clearSelection();
    }

    private void updateVersionList() {
        Long projectId = this.getProjectId();
        this.zephyrVersions = projectId == null ? null : this.service.getAllVersions(this.getProjectId());
        this.zephyrVersion.setItems(this.getKeyArray(this.zephyrVersions));
        this.zephyrCycle.clearSelection();
    }

    private void updateCycleList() {
        Long versionId = this.getVersionId();
        this.zephyrCycles = versionId == null ? null : this.service.getAllCycles(this.getProjectId(), versionId);
        this.zephyrCycle.setItems(this.getKeyArray(this.zephyrCycles));
    }

    private void checkCycle() {
        Long cycleId = this.getCycleId();
        if (cycleId == null) {
            this.setMessage(null);
            this.setErrorMessage(Messages.ZephyrPropertiesPage_CycleInvalid);
        } else {
            this.setMessage(Messages.ZephyrPropertiesPage_AllPropertiesValid);
            this.setErrorMessage(null);
        }
    }

    private String[] getKeyArray(Map<String, Long> items) {
        if (items == null) {
            return new String[0];
        }
        return items.keySet().toArray(new String[items.size()]);
    }

    private Long getProjectId() {
        return this.getItemId(this.zephyrProject, this.zephyrProjects);
    }

    private Long getVersionId() {
        return this.getItemId(this.zephyrVersion, this.zephyrVersions);
    }

    private Long getCycleId() {
        return this.getItemId(this.zephyrCycle, this.zephyrCycles);
    }

    private Long getItemId(Combo item, Map<String, Long> items) {
        int index = item.getSelectionIndex();
        return index > -1 && items != null ? items.get(item.getItem(index)) : null;
    }

    private String getItemName(Combo item) {
        int index = item.getSelectionIndex();
        return index > -1 ? item.getItem(index) : "";
    }

    private IProject getRcpttProject() {
        return (IProject)this.getElement().getAdapter(IResource.class);
    }
}

