/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.osgi.util.NLS;

public class CloneOperation {
    private final URIish uri;
    private final boolean allSelected;
    private boolean cloneSubmodules;
    private final Collection<Ref> selectedBranches;
    private final File workdir;
    private final File gitdir;
    private final String refName;
    private final String remoteName;
    private final int timeout;
    private CredentialsProvider credentialsProvider;
    private final List<PostCloneTask> postCloneTasks = new CopyOnWriteArrayList<PostCloneTask>();
    private TagOpt tagOption;

    public CloneOperation(URIish uri, boolean allSelected, Collection<Ref> selectedBranches, File workdir, String refName, String remoteName, int timeout) {
        this.uri = uri;
        this.allSelected = allSelected;
        this.selectedBranches = selectedBranches;
        this.workdir = workdir;
        this.gitdir = new File(workdir, ".git");
        this.refName = refName;
        this.remoteName = remoteName;
        this.timeout = timeout;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public void setCloneSubmodules(boolean cloneSubmodules) {
        this.cloneSubmodules = cloneSubmodules;
    }

    public void setTagOption(TagOpt tagOption) {
        this.tagOption = tagOption;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        String title = NLS.bind((String)CoreText.CloneOperation_title, (Object)this.uri);
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)title, (int)(this.postCloneTasks.isEmpty() ? 10 : 11));
        EclipseGitProgressTransformer gitMonitor = new EclipseGitProgressTransformer((IProgressMonitor)progress.newChild(10));
        CloneCommand.Callback callback = new CloneCommand.Callback(){

            public void initializedSubmodules(Collection<String> submodules) {
            }

            public void cloningSubmodule(String path) {
                progress.setTaskName(NLS.bind((String)CoreText.CloneOperation_submodule_title, (Object)CloneOperation.this.uri, (Object)path));
            }

            public void checkingOut(AnyObjectId commit, String path) {
            }
        };
        try (Repository repository = null;){
            try {
                CloneCommand cloneRepository = Git.cloneRepository();
                cloneRepository.setCredentialsProvider(this.credentialsProvider);
                if (this.refName != null) {
                    cloneRepository.setBranch(this.refName);
                } else {
                    cloneRepository.setNoCheckout(true);
                }
                cloneRepository.setDirectory(this.workdir);
                cloneRepository.setProgressMonitor((ProgressMonitor)gitMonitor);
                cloneRepository.setRemote(this.remoteName);
                cloneRepository.setURI(this.uri.toString());
                cloneRepository.setTimeout(this.timeout);
                cloneRepository.setCloneAllBranches(this.allSelected);
                cloneRepository.setCloneSubmodules(this.cloneSubmodules);
                if (this.tagOption != null) {
                    cloneRepository.setTagOption(this.tagOption);
                }
                if (this.cloneSubmodules) {
                    cloneRepository.setCallback(callback);
                }
                if (this.selectedBranches != null) {
                    ArrayList<String> branches = new ArrayList<String>();
                    for (Ref branch : this.selectedBranches) {
                        branches.add(branch.getName());
                    }
                    cloneRepository.setBranchesToClone(branches);
                }
                Git git = cloneRepository.call();
                repository = git.getRepository();
                if (!this.postCloneTasks.isEmpty()) {
                    progress.setTaskName(title);
                    progress.setWorkRemaining(this.postCloneTasks.size());
                    progress.subTask(CoreText.CloneOperation_configuring);
                    for (PostCloneTask task : this.postCloneTasks) {
                        task.execute(repository, (IProgressMonitor)progress.newChild(1));
                    }
                }
            }
            catch (Exception e) {
                try {
                    if (repository != null) {
                        repository.close();
                        repository = null;
                    }
                    FileUtils.delete((File)this.workdir, (int)1);
                }
                catch (IOException ioe) {
                    throw new InvocationTargetException(e, NLS.bind((String)CoreText.CloneOperation_failed_cleanup, (Object)ioe.getLocalizedMessage()));
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                throw new InvocationTargetException(e);
            }
        }
    }

    public File getGitDir() {
        return this.gitdir;
    }

    public void addPostCloneTask(PostCloneTask task) {
        this.postCloneTasks.add(task);
    }

    public static interface PostCloneTask {
        public void execute(Repository var1, IProgressMonitor var2) throws CoreException;
    }
}

