/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.core.cheatsheet.simple.text;

import org.eclipse.pde.internal.core.text.DocumentNodeFactory;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.text.IDocumentTextNode;
import org.eclipse.pde.internal.core.text.plugin.DocumentGenericNode;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCS;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSAction;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSCommand;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSConditionalSubItem;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSDescription;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSIntro;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSItem;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSModelFactory;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSObject;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSOnCompletion;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSPerformWhen;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSRepeatedSubItem;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSSubItem;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.text.SimpleCS;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.text.SimpleCSAction;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.text.SimpleCSCommand;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.text.SimpleCSConditionalSubItem;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.text.SimpleCSDescription;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.text.SimpleCSDocumentTextNode;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.text.SimpleCSIntro;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.text.SimpleCSItem;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.text.SimpleCSModel;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.text.SimpleCSOnCompletion;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.text.SimpleCSPerformWhen;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.text.SimpleCSRepeatedSubItem;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.text.SimpleCSSubItem;

public class SimpleCSDocumentFactory
extends DocumentNodeFactory
implements ISimpleCSModelFactory {
    private final SimpleCSModel fModel;

    public SimpleCSDocumentFactory(SimpleCSModel model) {
        this.fModel = model;
    }

    public IDocumentTextNode createDocumentTextNode(String content, IDocumentElementNode parent) {
        SimpleCSDocumentTextNode textNode = new SimpleCSDocumentTextNode(parent);
        parent.addTextNode((IDocumentTextNode)textNode);
        textNode.setText(content);
        return textNode;
    }

    public IDocumentElementNode createDocumentNode(String name, IDocumentElementNode parent) {
        if (parent == null) {
            if (this.isSimpleCS(name)) {
                return this.createSimpleCS();
            }
        } else if (parent instanceof SimpleCS) {
            if (this.isIntro(name)) {
                return this.createSimpleCSIntro((SimpleCS)parent);
            }
            if (this.isItem(name)) {
                return this.createSimpleCSItem((SimpleCS)parent);
            }
        } else if (parent instanceof SimpleCSIntro) {
            if (this.isDescription(name)) {
                return this.createSimpleCSDescription((SimpleCSIntro)parent);
            }
        } else if (parent instanceof SimpleCSItem) {
            if (this.isDescription(name)) {
                return this.createSimpleCSDescription((SimpleCSItem)parent);
            }
            if (this.isAction(name)) {
                return this.createSimpleCSAction((SimpleCSItem)parent);
            }
            if (this.isCommand(name)) {
                return this.createSimpleCSCommand((SimpleCSItem)parent);
            }
            if (this.isPerformWhen(name)) {
                return this.createSimpleCSPerformWhen((SimpleCSItem)parent);
            }
            if (this.isSubitem(name)) {
                return this.createSimpleCSSubItem((SimpleCSItem)parent);
            }
            if (this.isConditionalSubitem(name)) {
                return this.createSimpleCSConditionalSubItem((SimpleCSItem)parent);
            }
            if (this.isRepeatedSubitem(name)) {
                return this.createSimpleCSRepeatedSubItem((SimpleCSItem)parent);
            }
            if (this.isOnCompletion(name)) {
                return this.createSimpleCSOnCompletion((SimpleCSItem)parent);
            }
        } else if (parent instanceof SimpleCSSubItem) {
            if (this.isPerformWhen(name)) {
                return this.createSimpleCSPerformWhen((SimpleCSSubItem)parent);
            }
            if (this.isAction(name)) {
                return this.createSimpleCSAction((SimpleCSSubItem)parent);
            }
            if (this.isCommand(name)) {
                return this.createSimpleCSCommand((SimpleCSSubItem)parent);
            }
        } else if (parent instanceof SimpleCSConditionalSubItem) {
            if (this.isSubitem(name)) {
                return this.createSimpleCSSubItem((SimpleCSConditionalSubItem)parent);
            }
        } else if (parent instanceof SimpleCSRepeatedSubItem) {
            if (this.isSubitem(name)) {
                return this.createSimpleCSSubItem((SimpleCSRepeatedSubItem)parent);
            }
        } else if (parent instanceof SimpleCSPerformWhen) {
            if (this.isAction(name)) {
                return this.createSimpleCSAction((SimpleCSPerformWhen)parent);
            }
            if (this.isCommand(name)) {
                return this.createSimpleCSCommand((SimpleCSPerformWhen)parent);
            }
        } else if (parent instanceof SimpleCSDescription ? this.isBr(name) : parent instanceof SimpleCSOnCompletion && this.isBr(name)) {
            return this.createBr();
        }
        return super.createDocumentNode(name, parent);
    }

    private boolean isCSElement(String name, String elementName) {
        return name.equals(elementName);
    }

    private boolean isSimpleCS(String name) {
        return this.isCSElement(name, "cheatsheet");
    }

    private boolean isIntro(String name) {
        return this.isCSElement(name, "intro");
    }

    private boolean isDescription(String name) {
        return this.isCSElement(name, "description");
    }

    private boolean isItem(String name) {
        return this.isCSElement(name, "item");
    }

    private boolean isAction(String name) {
        return this.isCSElement(name, "action");
    }

    private boolean isCommand(String name) {
        return this.isCSElement(name, "command");
    }

    private boolean isPerformWhen(String name) {
        return this.isCSElement(name, "perform-when");
    }

    private boolean isSubitem(String name) {
        return this.isCSElement(name, "subitem");
    }

    private boolean isRepeatedSubitem(String name) {
        return this.isCSElement(name, "repeated-subitem");
    }

    private boolean isConditionalSubitem(String name) {
        return this.isCSElement(name, "conditional-subitem");
    }

    private boolean isOnCompletion(String name) {
        return this.isCSElement(name, "onCompletion");
    }

    private boolean isBr(String name) {
        return this.isCSElement(name, "br");
    }

    @Override
    public ISimpleCS createSimpleCS() {
        return new SimpleCS(this.fModel);
    }

    @Override
    public ISimpleCSAction createSimpleCSAction(ISimpleCSObject parent) {
        return new SimpleCSAction(this.fModel);
    }

    @Override
    public ISimpleCSCommand createSimpleCSCommand(ISimpleCSObject parent) {
        return new SimpleCSCommand(this.fModel);
    }

    @Override
    public ISimpleCSConditionalSubItem createSimpleCSConditionalSubItem(ISimpleCSObject parent) {
        return new SimpleCSConditionalSubItem(this.fModel);
    }

    @Override
    public ISimpleCSDescription createSimpleCSDescription(ISimpleCSObject parent) {
        return new SimpleCSDescription(this.fModel);
    }

    @Override
    public ISimpleCSIntro createSimpleCSIntro(ISimpleCSObject parent) {
        return new SimpleCSIntro(this.fModel);
    }

    @Override
    public ISimpleCSItem createSimpleCSItem(ISimpleCSObject parent) {
        return new SimpleCSItem(this.fModel);
    }

    @Override
    public ISimpleCSOnCompletion createSimpleCSOnCompletion(ISimpleCSObject parent) {
        return new SimpleCSOnCompletion(this.fModel);
    }

    @Override
    public ISimpleCSPerformWhen createSimpleCSPerformWhen(ISimpleCSObject parent) {
        return new SimpleCSPerformWhen(this.fModel);
    }

    @Override
    public ISimpleCSRepeatedSubItem createSimpleCSRepeatedSubItem(ISimpleCSObject parent) {
        return new SimpleCSRepeatedSubItem(this.fModel);
    }

    @Override
    public ISimpleCSSubItem createSimpleCSSubItem(ISimpleCSObject parent) {
        return new SimpleCSSubItem(this.fModel);
    }

    protected IDocumentElementNode createBr() {
        return new DocumentGenericNode("br"){
            private static final long serialVersionUID = 1L;

            public boolean isLeafNode() {
                return true;
            }
        };
    }
}

