/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7ElementVisitor;
import org.eclipse.rcptt.core.model.IQ7NamedElement;

public class NamedElementCollector
implements IQ7ElementVisitor {
    private final List<IQ7NamedElement> elements = new ArrayList<IQ7NamedElement>();
    private final Set<IQ7Element.HandleType> filter;

    public NamedElementCollector() {
        this.filter = new HashSet<IQ7Element.HandleType>(Arrays.asList(IQ7Element.HandleType.Context, IQ7Element.HandleType.TestCase, IQ7Element.HandleType.TestSuite, IQ7Element.HandleType.Verification, IQ7Element.HandleType.ProjectMetadata));
    }

    public NamedElementCollector(IQ7Element.HandleType ... types) {
        this.filter = new HashSet<IQ7Element.HandleType>(Arrays.asList(types));
    }

    @Override
    public boolean visit(IQ7Element element) {
        IQ7Element.HandleType elementType = element.getElementType();
        if (this.filter.contains((Object)elementType)) {
            this.elements.add((IQ7NamedElement)element);
            return false;
        }
        return true;
    }

    @Override
    public boolean endVisit(IQ7Element element) {
        return false;
    }

    public List<IQ7NamedElement> getElements() {
        return this.elements;
    }
}

