/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.fix.ElseIfFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;

public class ElseIfCleanUpCore
extends AbstractMultiFix
implements ICleanUpFix {
    public ElseIfCleanUpCore() {
        this(Collections.emptyMap());
    }

    public ElseIfCleanUpCore(Map<String, String> options) {
        super(options);
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.isEnabled("cleanup.else_if");
        return new CleanUpRequirements(requireAST, false, false, null);
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.else_if")) {
            return new String[]{MultiFixMessages.CodeStyleCleanUp_ElseIf_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        if (this.isEnabled("cleanup.else_if")) {
            return "if (isValid) {\n  System.out.println(isValid);\n} else if (isEnabled) {\n  System.out.println(isEnabled);\n}\n\n\n";
        }
        return "if (isValid) {\n  System.out.println(isValid);\n} else {\n  if (isEnabled) {\n    System.out.println(isEnabled);\n  }\n}\n";
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit) throws CoreException {
        if (!this.isEnabled("cleanup.else_if")) {
            return null;
        }
        return ElseIfFixCore.createCleanUp(unit);
    }

    @Override
    public CompilationUnitChange createChange(IProgressMonitor progressMonitor) throws CoreException {
        return null;
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        return false;
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit, IProblemLocation[] problems) throws CoreException {
        return null;
    }
}

