/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.resources;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.rcptt.core.ContextType;
import org.eclipse.rcptt.core.DefaultContextMaker;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.persistence.IPersistenceModel;
import org.eclipse.rcptt.core.scenario.Context;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.resources.ImportUtils;
import org.eclipse.rcptt.resources.WSUtils;
import org.eclipse.rcptt.resources.WorkspaceDataImporter;
import org.eclipse.rcptt.resources.WorkspaceDataMaker;
import org.eclipse.rcptt.workspace.WSFolder;
import org.eclipse.rcptt.workspace.WSProject;
import org.eclipse.rcptt.workspace.WSRoot;
import org.eclipse.rcptt.workspace.WorkspaceContext;
import org.eclipse.rcptt.workspace.WorkspaceData;
import org.eclipse.rcptt.workspace.WorkspaceFactory;

public class WorkspaceContextMaker
extends DefaultContextMaker {
    private WorkspaceDataMaker maker = new WorkspaceDataMaker();

    public Context create(Resource resource, ContextType type, String name) {
        WorkspaceContext context = (WorkspaceContext)super.create(resource, type, name);
        context.setContent(WorkspaceFactory.eINSTANCE.createWSRoot());
        return context;
    }

    public void makeExecutable(Context context, IQ7NamedElement source) throws ModelException {
        IQ7NamedElement copy = source.getIndexingWorkingCopy(null);
        try {
            this.maker.makeSelfSufficientData((WorkspaceData)context, copy.getModifiedPersistenceModel(), source);
        }
        finally {
            copy.discardWorkingCopy();
        }
    }

    public void captureContents(IContext context, Context data, IProgressMonitor monitor) throws CoreException {
        WorkspaceContext wsContext = (WorkspaceContext)data;
        WorkspaceDataImporter importer = new WorkspaceDataImporter((WorkspaceData)wsContext);
        IPersistenceModel model = context.getPersistenceModel();
        model.removeAll();
        try {
            WSRoot ownRoot = ((WorkspaceContext)context.getNamedElement()).getContent();
            ownRoot.getProjects().clear();
            EList projects = wsContext.getContent().getProjects();
            if (projects.size() > 0) {
                monitor.beginTask("Copy projects...", projects.size());
                for (WSProject project : projects) {
                    WSProject ownProject = WSUtils.getProject((WSRoot)ownRoot, (String)project.getName(), (boolean)true);
                    ImportUtils.importFiles((WSFolder)ownProject, (EList)project.getFiles(), (IPersistenceModel)model, (WorkspaceDataImporter)importer);
                    ImportUtils.importFolders((WSFolder)ownProject, (EList)project.getFolders(), (IPersistenceModel)model, (WorkspaceDataImporter)importer);
                }
            }
        }
        catch (Exception e) {
            throw new CoreException(RcpttPlugin.createStatus((Throwable)e));
        }
    }
}

