/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.IFileDialog;
import org.eclipse.swt.internal.ole.win32.IShellItem;
import org.eclipse.swt.internal.ole.win32.IShellItemArray;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FileDialog
extends Dialog {
    String[] filterNames = new String[0];
    String[] filterExtensions = new String[0];
    String[] fileNames = new String[0];
    String filterPath = "";
    String fileName = "";
    int filterIndex = 0;
    boolean overwrite = false;
    static final String DEFAULT_FILTER = "*.*";
    static final String LONG_PATH_PREFIX = "\\\\?\\";

    public FileDialog(Shell parent) {
        this(parent, 65536);
    }

    public FileDialog(Shell parent, int style) {
        super(parent, FileDialog.checkStyle(parent, style));
        this.checkSubclass();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public int getFilterIndex() {
        return this.filterIndex;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    static Path getItemPath(IShellItem psi) {
        long[] ppsz = new long[1];
        if (psi.GetDisplayName(-2147123200, ppsz) == 0) {
            int length = OS.wcslen(ppsz[0]);
            char[] buffer = new char[length];
            OS.MoveMemory(buffer, ppsz[0], length * 2);
            OS.CoTaskMemFree(ppsz[0]);
            String path = String.valueOf(buffer);
            if (path.startsWith(LONG_PATH_PREFIX)) {
                path = path.substring(LONG_PATH_PREFIX.length());
            }
            return Paths.get(path, new String[0]);
        }
        return null;
    }

    public String open() {
        try {
            return this.openDialog().orElse(null);
        }
        catch (SWTException e) {
            if (e.code == 51) {
                return null;
            }
            throw e;
        }
    }

    public Optional<String> openDialog() {
        char[] path;
        long[] ppv = new long[1];
        int hr = (this.style & 0x2000) != 0 ? COM.CoCreateInstance(COM.CLSID_FileSaveDialog, 0L, 1, COM.IID_IFileSaveDialog, ppv) : COM.CoCreateInstance(COM.CLSID_FileOpenDialog, 0L, 1, COM.IID_IFileOpenDialog, ppv);
        if (hr != 0) {
            SWT.error(2);
        }
        IFileDialog fileDialog = new IFileDialog(ppv[0]);
        int[] options = new int[1];
        fileDialog.GetOptions(options);
        options[0] = options[0] | 0x48;
        options[0] = options[0] & 0xFFFFEFFF;
        if ((this.style & 0x2000) != 0) {
            if (!this.overwrite) {
                options[0] = options[0] & 0xFFFFFFFD;
            }
        } else if ((this.style & 2) != 0) {
            options[0] = options[0] | 0x200;
        }
        fileDialog.SetOptions(options[0]);
        if (!this.title.isEmpty()) {
            fileDialog.SetTitle((this.title + "\u0000").toCharArray());
        }
        String[] filterExtensions = this.filterExtensions;
        String[] filterNames = this.filterNames;
        if (filterExtensions == null || filterExtensions.length == 0) {
            filterNames = new String[]{DEFAULT_FILTER};
            filterExtensions = filterNames;
        }
        long hHeap = OS.GetProcessHeap();
        long[] filterSpec = new long[filterExtensions.length * 2];
        int i = 0;
        while (i < filterExtensions.length) {
            int[] result;
            String name;
            String extension = filterExtensions[i];
            String string = name = filterNames != null && i < filterNames.length ? filterNames[i] : extension;
            if (!name.contains("*.") && (result = OS.readRegistryDwords(-2147483647, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Advanced", "HideFileExt")) != null && result[0] == 0) {
                name = name.replace(" (" + extension + ")", "");
            }
            long lpstrName = OS.HeapAlloc(hHeap, 8, (name.length() + 1) * 2);
            long lpstrExt = OS.HeapAlloc(hHeap, 8, (extension.length() + 1) * 2);
            OS.MoveMemory(lpstrName, name.toCharArray(), name.length() * 2);
            OS.MoveMemory(lpstrExt, extension.toCharArray(), extension.length() * 2);
            filterSpec[i * 2] = lpstrName;
            filterSpec[i * 2 + 1] = lpstrExt;
            ++i;
        }
        fileDialog.SetFileTypes(filterExtensions.length, filterSpec);
        i = 0;
        while (i < filterSpec.length) {
            OS.HeapFree(hHeap, 0, filterSpec[i]);
            ++i;
        }
        fileDialog.SetDefaultExtension(new char[1]);
        fileDialog.SetFileTypeIndex(this.filterIndex + 1);
        if (this.filterPath != null && COM.SHCreateItemFromParsingName(path = (this.filterPath.replace('/', '\\') + "\u0000").toCharArray(), 0L, COM.IID_IShellItem, ppv) == 0) {
            IShellItem psi = new IShellItem(ppv[0]);
            if (this.filterPath.length() > 0) {
                fileDialog.SetFolder(psi);
            } else {
                fileDialog.SetDefaultFolder(psi);
            }
            psi.Release();
        }
        if (this.fileName != null) {
            char[] name = (this.fileName.replace('/', '\\') + "\u0000").toCharArray();
            fileDialog.SetFileName(name);
        }
        Dialog oldModal = null;
        Display display = this.parent.getDisplay();
        if ((this.style & 0x30000) != 0) {
            oldModal = display.getModalDialog();
            display.setModalDialog(this);
        }
        display.externalEventLoop = true;
        display.sendPreExternalEventDispatchEvent();
        hr = fileDialog.Show(this.parent.handle);
        display.externalEventLoop = false;
        display.sendPostExternalEventDispatchEvent();
        if ((this.style & 0x30000) != 0) {
            display.setModalDialog(oldModal);
        }
        String fullPath = null;
        this.fileNames = new String[0];
        if (hr == 0) {
            int[] piIndex;
            if ((this.style & 0x2000) != 0) {
                if (fileDialog.GetResult(ppv) == 0) {
                    IShellItem psi = new IShellItem(ppv[0]);
                    Path itemPath = FileDialog.getItemPath(psi);
                    psi.Release();
                    this.fileName = itemPath.getFileName().toString();
                    this.filterPath = itemPath.getParent().toString();
                    this.fileNames = new String[]{this.fileName};
                    fullPath = itemPath.toString();
                }
            } else if (fileDialog.GetResults(ppv) == 0) {
                IShellItemArray psia = new IShellItemArray(ppv[0]);
                int[] piCount = new int[1];
                psia.GetCount(piCount);
                this.fileNames = new String[piCount[0]];
                Path parentPath = null;
                int i2 = 0;
                while (i2 < piCount[0]) {
                    psia.GetItemAt(i2, ppv);
                    IShellItem psi = new IShellItem(ppv[0]);
                    Path itemPath = FileDialog.getItemPath(psi);
                    psi.Release();
                    if (parentPath == null) {
                        parentPath = itemPath.getParent();
                        this.filterPath = parentPath.toString();
                        fullPath = itemPath.toString();
                    }
                    this.fileNames[i2] = itemPath.getParent().equals(parentPath) ? itemPath.getFileName().toString() : itemPath.toString();
                    ++i2;
                }
                this.fileName = this.fileNames[0];
                psia.Release();
            }
            if (fileDialog.GetFileTypeIndex(piIndex = new int[1]) == 0) {
                this.filterIndex = piIndex[0] - 1;
            }
        }
        fileDialog.Release();
        if (hr == 0) {
            return Optional.ofNullable(fullPath);
        }
        if (hr == OS.HRESULT_FROM_WIN32(1223)) {
            return Optional.empty();
        }
        throw new SWTException(51);
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFilterExtensions(String ... extensions) {
        this.filterExtensions = extensions;
    }

    public void setFilterIndex(int index) {
        this.filterIndex = index;
    }

    public void setFilterNames(String ... names) {
        this.filterNames = names;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }
}

