/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.jarprocessor;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipException;

public class Utils {
    public static final String MARK_FILE_NAME = "META-INF/eclipse.inf";
    public static final String SIGN_EXCLUDES = "sign.excludes";
    public static final String MARK_EXCLUDE = "jarprocessor.exclude";
    public static final String MARK_EXCLUDE_SIGN = "jarprocessor.exclude.sign";
    public static final String MARK_EXCLUDE_CHILDREN = "jarprocessor.exclude.children";
    public static final String MARK_EXCLUDE_CHILDREN_SIGN = "jarprocessor.exclude.children.sign";
    public static final String JRE = "@jre";
    public static final String PATH = "@path";
    public static final String NONE = "@none";
    public static final String JAR_SUFFIX = ".jar";
    public static final FileFilter JAR_FILTER = pathname -> pathname.isFile() && pathname.getName().endsWith(JAR_SUFFIX);

    public static void close(Object stream) {
        if (stream != null) {
            try {
                if (stream instanceof InputStream) {
                    ((InputStream)stream).close();
                } else if (stream instanceof OutputStream) {
                    ((OutputStream)stream).close();
                } else if (stream instanceof JarFile) {
                    ((JarFile)stream).close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void transferStreams(InputStream source, OutputStream destination, boolean close) throws IOException {
        source = new BufferedInputStream(source);
        destination = new BufferedOutputStream(destination);
        try {
            source.transferTo(destination);
        }
        finally {
            if (close) {
                Utils.close(source);
                Utils.close(destination);
            } else {
                destination.flush();
            }
        }
    }

    public static boolean clear(File root) {
        boolean result = Utils.clearChildren(root);
        try {
            if (root.exists()) {
                result &= root.delete();
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public static boolean clearChildren(File root) {
        String[] list;
        boolean result = true;
        if (root.isDirectory() && (list = root.list()) != null) {
            String[] stringArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                String list1 = stringArray[n2];
                result &= Utils.clear(new File(root, list1));
                ++n2;
            }
        }
        return result;
    }

    @Deprecated(forRemoval=true, since="1.2.0")
    public static Set<String> getPackExclusions(Properties properties) {
        return Collections.emptySet();
    }

    public static Set<String> getSignExclusions(Properties properties) {
        if (properties == null) {
            return Collections.emptySet();
        }
        String signExcludes = properties.getProperty(SIGN_EXCLUDES);
        if (signExcludes != null) {
            String[] excludes = Utils.toStringArray(signExcludes, ",");
            HashSet<String> signExclusions = new HashSet<String>();
            String[] stringArray = excludes;
            int n = excludes.length;
            int n2 = 0;
            while (n2 < n) {
                String exclude = stringArray[n2];
                signExclusions.add(exclude);
                ++n2;
            }
            return signExclusions;
        }
        return Collections.emptySet();
    }

    public static String concat(String[] array) {
        return String.join((CharSequence)String.valueOf(' '), array);
    }

    public static String[] toStringArray(String input, String separator) {
        StringTokenizer tokenizer = new StringTokenizer(input, separator);
        int count = tokenizer.countTokens();
        String[] result = new String[count];
        int i = 0;
        while (i < count) {
            result[i] = tokenizer.nextToken().trim();
            ++i;
        }
        return result;
    }

    /*
     * Loose catch block
     */
    public static Properties getEclipseInf(File jarFile, boolean verbose) {
        if (jarFile == null || !jarFile.exists()) {
            if (verbose) {
                System.out.println("Failed to obtain eclipse.inf due to missing jar file: " + String.valueOf(jarFile));
            }
            return null;
        }
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (JarFile jar = new JarFile(jarFile, false);){
                JarEntry mark = jar.getJarEntry(MARK_FILE_NAME);
                if (mark != null) {
                    Properties properties;
                    InputStream in;
                    Throwable throwable2;
                    block26: {
                        throwable2 = null;
                        Object var7_12 = null;
                        in = jar.getInputStream(mark);
                        Properties props = new Properties();
                        props.load(in);
                        properties = props;
                        if (in == null) break block26;
                        in.close();
                    }
                    return properties;
                    {
                        catch (Throwable throwable3) {
                            try {
                                if (in != null) {
                                    in.close();
                                }
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (throwable2 == null) {
                                    throwable2 = throwable4;
                                } else if (throwable2 != throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                throw throwable2;
                            }
                        }
                    }
                }
                return new Properties();
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (ZipException e) {
            return null;
        }
        catch (IOException e) {
            if (verbose) {
                System.out.println("Failed to obtain eclipse.inf due to IOException: " + String.valueOf(jarFile));
                e.printStackTrace();
            }
            return null;
        }
    }

    public static boolean shouldSkipJar(File input, boolean processAll, boolean verbose) {
        Properties inf = Utils.getEclipseInf(input, verbose);
        if (inf == null) {
            return false;
        }
        String exclude = inf.getProperty(MARK_EXCLUDE);
        if (exclude != null && Boolean.parseBoolean(exclude)) {
            return true;
        }
        return !processAll;
    }

    public static void storeProperties(Properties props, OutputStream stream) {
        PrintStream printStream = new PrintStream(stream);
        printStream.print("#Processed using Jarprocessor\n");
        TreeMap<Object, Object> sorted = new TreeMap<Object, Object>(props);
        for (Object object : sorted.keySet()) {
            String key = (String)object;
            printStream.print(key);
            printStream.print(" = ");
            printStream.print(sorted.get(key));
            printStream.print("\n");
        }
        printStream.flush();
    }
}

