/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.minmax;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MAddon;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.addons.minmax.MinMaxAddonUtil;
import org.eclipse.e4.ui.workbench.addons.minmax.TrimStack;
import org.eclipse.e4.ui.workbench.addons.minmax.TrimStackIdHelper;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;

public class MinMaxAddon {
    private static final String DISABLE_MINMAX_ADDON = "DisableMinMaxAddon";
    private static final String MIN_MAXIMIZEABLE_CHILDREN_AREA_TAG = "MinMaximizeableChildrenArea";
    private static final String ID_EDITOR_AREA = "org.eclipse.ui.editorss";
    private static final String GLOBAL_CACHE_ID = "Global";
    private static final String MINIMIZED = "Minimized";
    private static final String MAXIMIZED = "Maximized";
    private static final String MINIMIZED_BY_ZOOM = "MinimizedByZoom";
    @Inject
    IEventBroker eventBroker;
    @Inject
    EModelService modelService;
    @Inject
    private IEclipseContext context;
    private boolean ignoreTagChanges = false;
    @Inject
    MAddon minMaxAddon;
    @Inject
    MApplication app;
    private final CTabFolder2Adapter CTFButtonListener = new CTabFolder2Adapter(){

        private MUIElement getElementToChange(CTabFolderEvent event) {
            CTabFolder ctf = (CTabFolder)event.widget;
            MUIElement element = (MUIElement)ctf.getData("modelElement");
            if (element instanceof MArea) {
                return element.getCurSharedRef();
            }
            MElementContainer parentElement = element.getParent();
            while (parentElement != null && !(parentElement instanceof MArea)) {
                parentElement = parentElement.getParent();
            }
            if (parentElement != null && MinMaxAddonUtil.isMinMaxChildrenAreaWithMultipleVisibleChildren((MUIElement)parentElement)) {
                return element;
            }
            return parentElement != null ? parentElement.getCurSharedRef() : element;
        }

        public void maximize(CTabFolderEvent event) {
            MinMaxAddon.this.setState(this.getElementToChange(event), MinMaxAddon.MAXIMIZED);
        }

        public void minimize(CTabFolderEvent event) {
            MinMaxAddon.this.setState(this.getElementToChange(event), MinMaxAddon.MINIMIZED);
        }

        public void restore(CTabFolderEvent event) {
            MinMaxAddon.this.setState(this.getElementToChange(event), null);
        }
    };
    private final MouseListener CTFDblClickListener = new MouseAdapter(){

        public void mouseDown(MouseEvent e) {
            MWindow window;
            CTabFolder ctf = (CTabFolder)e.widget;
            MUIElement element = (MUIElement)ctf.getData("modelElement");
            if (element instanceof MPartStack && ctf.getItemCount() == 0 && (window = MinMaxAddon.this.modelService.getTopLevelWindowFor(element)) != null) {
                List tcList = MinMaxAddon.this.modelService.findElements((MUIElement)window, null, MToolControl.class, null);
                for (MToolControl tc : tcList) {
                    if (!(tc.getObject() instanceof TrimStack)) continue;
                    TrimStack ts = (TrimStack)tc.getObject();
                    ts.showStack(false);
                }
            }
        }

        private MUIElement getElementToChange(MouseEvent event) {
            CTabFolder ctf = (CTabFolder)event.widget;
            MUIElement element = (MUIElement)ctf.getData("modelElement");
            if (element instanceof MArea) {
                return element.getCurSharedRef();
            }
            MElementContainer parentElement = element.getParent();
            while (!(parentElement == null || parentElement instanceof MArea && parentElement.getCurSharedRef() != null)) {
                parentElement = parentElement.getParent();
            }
            if (parentElement != null && MinMaxAddonUtil.isMinMaxChildrenAreaWithMultipleVisibleChildren((MUIElement)parentElement)) {
                return element;
            }
            return parentElement != null ? parentElement.getCurSharedRef() : element;
        }

        public void mouseDoubleClick(MouseEvent e) {
            if (e.button == 1) {
                MUIElement elementToChange = this.getElementToChange(e);
                CTabFolder ctf = (CTabFolder)e.widget;
                if (e.y > ctf.getTabHeight()) {
                    return;
                }
                if (!elementToChange.getTags().contains(MinMaxAddon.MAXIMIZED)) {
                    MinMaxAddon.this.setState(elementToChange, MinMaxAddon.MAXIMIZED);
                } else {
                    MinMaxAddon.this.setState(elementToChange, null);
                }
            }
        }
    };

    private void setState(MUIElement element, String state) {
        if (element == null) {
            return;
        }
        if (MINIMIZED.equals(state)) {
            element.getTags().remove(MAXIMIZED);
            element.getTags().add(MINIMIZED);
        } else if (MAXIMIZED.equals(state)) {
            element.getTags().remove(MINIMIZED);
            element.getTags().add(MAXIMIZED);
        } else {
            element.getTags().remove(MINIMIZED);
            element.getTags().remove(MAXIMIZED);
        }
    }

    @Inject
    @Optional
    private void subscribeTopicWidget(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/UIElement/widget/*") Event event) {
        if (this.app.getTags().contains(DISABLE_MINMAX_ADDON)) {
            return;
        }
        MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
        if (!(changedElement instanceof MPartStack) && !(changedElement instanceof MArea)) {
            return;
        }
        CTabFolder ctf = this.getCTFFor(changedElement);
        if (ctf == null) {
            return;
        }
        MUIElement stateElement = changedElement;
        if (changedElement instanceof MPartStack) {
            MPartStack stack = (MPartStack)changedElement;
            MArea area = MinMaxAddonUtil.getAreaFor(stack);
            if (area != null && !(area.getWidget() instanceof CTabFolder)) {
                stateElement = area.getCurSharedRef();
            }
        } else if (changedElement instanceof MArea) {
            stateElement = changedElement.getCurSharedRef();
        }
        this.adjustCTFButtons(stateElement);
        ctf.removeCTabFolder2Listener((CTabFolder2Listener)this.CTFButtonListener);
        ctf.addCTabFolder2Listener((CTabFolder2Listener)this.CTFButtonListener);
        ctf.removeMouseListener(this.CTFDblClickListener);
        ctf.addMouseListener(this.CTFDblClickListener);
    }

    @Inject
    @Optional
    private void subscribeTopicChildren(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/ElementContainer/children/*") Event event) {
        if (this.app.getTags().contains(DISABLE_MINMAX_ADDON)) {
            return;
        }
        MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
        MWindow window = this.modelService.getTopLevelWindowFor(changedElement);
        if (!(changedElement instanceof MPerspectiveStack) || window == null || !(window instanceof MTrimmedWindow)) {
            return;
        }
        if (UIEvents.isREMOVE((Event)event)) {
            for (Object removedElement : UIEvents.asIterable((Event)event, (String)"OldValue")) {
                MUIElement removed = (MUIElement)removedElement;
                String perspectiveId = removed.getElementId();
                MTrimBar bar = this.modelService.getTrim((MTrimmedWindow)window, SideValue.TOP);
                ArrayList<MToolControl> toRemove = new ArrayList<MToolControl>();
                for (MTrimElement child : bar.getChildren()) {
                    String trimElementId = child.getElementId();
                    if (!(child instanceof MToolControl) || !trimElementId.contains(perspectiveId)) continue;
                    toRemove.add((MToolControl)child);
                }
                for (MToolControl minStack : toRemove) {
                    minStack.setToBeRendered(false);
                    bar.getChildren().remove(minStack);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Inject
    @Optional
    private void subscribeTopicSelectedElement(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*") Event event) {
        void winShell;
        void ps;
        if (this.app.getTags().contains(DISABLE_MINMAX_ADDON)) {
            return;
        }
        MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
        if (!(changedElement instanceof MPerspectiveStack)) {
            return;
        }
        MPerspectiveStack mPerspectiveStack = (MPerspectiveStack)changedElement;
        MWindow window = this.modelService.getTopLevelWindowFor((MUIElement)ps);
        Object widget = window.getWidget();
        if (!(widget instanceof Shell)) {
            return;
        }
        Shell shell = (Shell)widget;
        List tcList = this.modelService.findElements((MUIElement)window, null, MToolControl.class);
        MPerspective curPersp = (MPerspective)ps.getSelectedElement();
        if (curPersp != null) {
            List minimizedElements = this.modelService.findElements((MUIElement)curPersp, null, MUIElement.class, Collections.singletonList(MINIMIZED));
            for (MUIElement ele : minimizedElements) {
                String fullId = TrimStackIdHelper.createTrimStackId(ele, curPersp, window);
                for (MToolControl tc : tcList) {
                    if (!fullId.equals(tc.getElementId())) continue;
                    tc.setToBeRendered(true);
                }
            }
            MUIElement eaPlaceholder = this.modelService.find(ID_EDITOR_AREA, (MUIElement)curPersp);
            this.adjustCTFButtons(eaPlaceholder);
        }
        if (event.getProperty("OldValue") instanceof MPerspective) {
            MPerspective oldPersp = (MPerspective)event.getProperty("OldValue");
            String perspId = "(" + oldPersp.getElementId() + ")";
            for (MToolControl tc : tcList) {
                if (!(tc.getObject() instanceof TrimStack) || !tc.getElementId().contains(perspId)) continue;
                TrimStack ts = (TrimStack)tc.getObject();
                ts.showStack(false);
                tc.setToBeRendered(false);
            }
        }
        winShell.getDisplay().asyncExec(() -> MinMaxAddon.lambda$0((Shell)winShell));
    }

    @Inject
    @Optional
    private void subscribeTopicTagsChanged(@UIEventTopic(value="org/eclipse/e4/ui/model/application/ApplicationElement/tags/*") Event event) {
        if (this.ignoreTagChanges) {
            return;
        }
        if (this.app.getTags().contains(DISABLE_MINMAX_ADDON)) {
            return;
        }
        Object changedObj = event.getProperty("ChangedElement");
        if (!(changedObj instanceof MUIElement)) {
            return;
        }
        MUIElement mUIElement = (MUIElement)changedObj;
        if (UIEvents.isADD((Event)event)) {
            if (UIEvents.contains((Event)event, (String)"NewValue", (Object)MINIMIZED)) {
                this.minimize((MUIElement)changedElement);
            } else if (UIEvents.contains((Event)event, (String)"NewValue", (Object)MAXIMIZED)) {
                this.maximize((MUIElement)changedElement);
            }
        } else if (UIEvents.isREMOVE((Event)event)) {
            if (UIEvents.contains((Event)event, (String)"OldValue", (Object)MINIMIZED)) {
                this.restore((MUIElement)changedElement);
            } else if (UIEvents.contains((Event)event, (String)"OldValue", (Object)MAXIMIZED)) {
                this.unzoom((MUIElement)changedElement);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Inject
    @Optional
    private void subscribeTopicElementId(@UIEventTopic(value="org/eclipse/e4/ui/model/application/ApplicationElement/elementId/*") Event event) {
        void perspective;
        if (this.app.getTags().contains(DISABLE_MINMAX_ADDON)) {
            return;
        }
        Object changedObject = event.getProperty("ChangedElement");
        if (!(changedObject instanceof MPerspective)) {
            return;
        }
        MPerspective mPerspective = (MPerspective)changedObject;
        Object newID = (String)event.getProperty("NewValue");
        Object oldID = (String)event.getProperty("OldValue");
        newID = "(" + (String)newID + ")";
        oldID = "(" + (String)oldID + ")";
        MWindow perspWin = this.modelService.getTopLevelWindowFor((MUIElement)perspective);
        if (perspWin == null) {
            return;
        }
        List trimStacks = this.modelService.findElements((MUIElement)perspWin, null, MToolControl.class);
        for (MToolControl trimStack : trimStacks) {
            if (!TrimStack.CONTRIBUTION_URI.equals(trimStack.getContributionURI())) continue;
            trimStack.setElementId(trimStack.getElementId().replace((CharSequence)oldID, (CharSequence)newID));
        }
    }

    @Inject
    @Optional
    private void subscribeTopicPerspSaved(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/perpSaved") Event event) {
        if (this.app.getTags().contains(DISABLE_MINMAX_ADDON)) {
            return;
        }
        MPerspective savedPersp = (MPerspective)event.getProperty("ChangedElement");
        String cache = this.getTrimCache(savedPersp);
        this.minMaxAddon.getPersistedState().put(savedPersp.getElementId(), cache);
    }

    private String getTrimCache(MPerspective savedPersp) {
        MWindow topWin = this.modelService.getTopLevelWindowFor((MUIElement)savedPersp);
        StringBuilder cache = new StringBuilder(this.getWinCache(topWin, savedPersp));
        for (MWindow dw : savedPersp.getWindows()) {
            cache.append(this.getWinCache(dw, savedPersp));
        }
        return cache.toString();
    }

    private String getWinCache(MWindow win, MPerspective perspective) {
        StringBuilder winStrBuilder = new StringBuilder();
        List stackList = this.modelService.findElements((MUIElement)win, null, MPartStack.class);
        for (MPartStack stack : stackList) {
            winStrBuilder.append(this.getStackTrimLoc(stack, perspective));
        }
        return winStrBuilder.toString();
    }

    private String getStackTrimLoc(MPartStack stack, MPerspective perspective) {
        MWindow stackWin = this.modelService.getTopLevelWindowFor((MUIElement)stack);
        MUIElement tcElement = this.modelService.find(TrimStackIdHelper.createTrimStackId((MUIElement)stack, perspective, stackWin), (MUIElement)stackWin);
        if (tcElement == null) {
            return "";
        }
        MTrimBar bar = (MTrimBar)tcElement.getParent();
        int sideVal = bar.getSide().getValue();
        int index = bar.getChildren().indexOf(tcElement);
        return stack.getElementId() + " " + sideVal + " " + index + "#";
    }

    @Inject
    @Optional
    private void subscribeTopicPerspReset(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/perspReset") Event event) {
        if (this.app.getTags().contains(DISABLE_MINMAX_ADDON)) {
            return;
        }
        MPerspective resetPersp = (MPerspective)event.getProperty("ChangedElement");
        List minimizedElements = this.modelService.findElements((MUIElement)resetPersp, null, MUIElement.class, Collections.singletonList(MINIMIZED));
        for (MUIElement element : minimizedElements) {
            this.createTrim(element);
        }
    }

    @Inject
    @Optional
    private void subscribeTopicPerspOpened(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/perspOpened") Event event) {
        if (this.app.getTags().contains(DISABLE_MINMAX_ADDON)) {
            return;
        }
        MPerspective openedPersp = (MPerspective)event.getProperty("ChangedElement");
        List minimizedElements = this.modelService.findElements((MUIElement)openedPersp, null, MUIElement.class, Collections.singletonList(MINIMIZED));
        for (MUIElement element : minimizedElements) {
            this.createTrim(element);
        }
    }

    private void setCTFButtons(CTabFolder ctf, MUIElement stateElement, boolean hideButtons) {
        if (hideButtons) {
            ctf.setMinimizeVisible(false);
            ctf.setMaximizeVisible(false);
        } else if (stateElement.getTags().contains(MINIMIZED)) {
            ctf.setMinimizeVisible(false);
            ctf.setMaximizeVisible(true);
            ctf.setMaximized(true);
        } else if (stateElement.getTags().contains(MAXIMIZED)) {
            ctf.setMinimizeVisible(true);
            ctf.setMaximizeVisible(true);
            ctf.setMaximized(true);
        } else {
            ctf.setMinimizeVisible(true);
            ctf.setMaximizeVisible(true);
            ctf.setMinimized(false);
            ctf.setMaximized(false);
            ctf.requestLayout();
        }
    }

    void adjustCTFButtons(MUIElement element) {
        if (!(element instanceof MPartStack) && !(element instanceof MPlaceholder)) {
            return;
        }
        CTabFolder ctf = this.getCTFFor(element);
        if (ctf == null) {
            return;
        }
        if (element instanceof MPlaceholder) {
            this.setCTFButtons(ctf, element, false);
        } else {
            MArea area = MinMaxAddonUtil.getAreaFor((MPartStack)element);
            if (area == null) {
                this.setCTFButtons(ctf, element, false);
            } else if (area.getTags().contains(MIN_MAXIMIZEABLE_CHILDREN_AREA_TAG)) {
                this.setCTFButtons(ctf, element, false);
            }
        }
    }

    private CTabFolder getCTFFor(MUIElement element) {
        if (element instanceof MArea) {
            if (element.getWidget() instanceof CTabFolder) {
                return (CTabFolder)element.getWidget();
            }
            List stacks = this.modelService.findElements(element, null, MPartStack.class);
            for (MPartStack stack : stacks) {
                if (!(stack.getWidget() instanceof CTabFolder)) continue;
                return (CTabFolder)stack.getWidget();
            }
        } else {
            MPlaceholder ph;
            if (element.getWidget() instanceof CTabFolder) {
                return (CTabFolder)element.getWidget();
            }
            if (element instanceof MPlaceholder && (ph = (MPlaceholder)element).getRef() instanceof MArea) {
                return this.getCTFFor(ph.getRef());
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    boolean isEmptyPerspectiveStack(MUIElement element) {
        void ps;
        if (!(element instanceof MPerspectiveStack)) {
            return false;
        }
        MPerspectiveStack mPerspectiveStack = (MPerspectiveStack)element;
        return ps.getChildren().isEmpty();
    }

    void minimize(MUIElement element) {
        if (!element.isToBeRendered()) {
            return;
        }
        if (this.isEmptyPerspectiveStack(element)) {
            element.setVisible(false);
            return;
        }
        this.createTrim(element);
        element.setVisible(false);
        this.adjustCTFButtons(element);
        MWindow win = MinMaxAddonUtil.getWindowFor(element);
        EPartService partService = (EPartService)win.getContext().get(EPartService.class);
        partService.requestActivation();
    }

    void restore(MUIElement element) {
        MWindow window = this.modelService.getTopLevelWindowFor(element);
        String trimId = this.getTrimId(element, MinMaxAddonUtil.getWindowFor(element));
        MToolControl trimStack = (MToolControl)this.modelService.find(trimId, (MUIElement)window);
        if (!(trimStack != null && trimStack.getObject() != null || (trimStack = (MToolControl)this.modelService.find(trimId = TrimStackIdHelper.createTrimStackId(element, this.modelService.getPerspectiveFor(element), null), (MUIElement)window)) != null && trimStack.getObject() != null)) {
            if (element instanceof MPerspectiveStack) {
                element.setVisible(true);
            }
            return;
        }
        TrimStack ts = (TrimStack)trimStack.getObject();
        ts.restoreStack();
        this.adjustCTFButtons(element);
        List<String> maximizeTag = Collections.singletonList(MAXIMIZED);
        List curMax = this.modelService.findElements((MUIElement)window, null, MUIElement.class, maximizeTag, 11);
        MinMaxAddonUtil.ignoreChildrenOfMinMaxChildrenArea(this.modelService, element, curMax);
        if (curMax.size() > 0) {
            MUIElement maxElement = (MUIElement)curMax.get(0);
            List<MUIElement> elementsLeftToRestore = this.getElementsToRestore(maxElement);
            boolean unMax = true;
            for (MUIElement toRestore : elementsLeftToRestore) {
                if (toRestore.isVisible()) continue;
                unMax = false;
            }
            if (unMax) {
                maxElement.getTags().remove(MAXIMIZED);
            }
        }
        MinMaxAddonUtil.restoreStacksOfMinMaxChildrenArea(this, element, maximizeTag);
    }

    void executeWithIgnoredTagChanges(Runnable runnable) {
        this.ignoreTagChanges = true;
        try {
            runnable.run();
        }
        finally {
            this.ignoreTagChanges = false;
        }
    }

    void maximize(MUIElement element) {
        if (!element.isToBeRendered()) {
            return;
        }
        List<MUIElement> elementsToMinimize = this.getElementsToMinimize(element);
        MWindow win = MinMaxAddonUtil.getWindowFor(element);
        this.restoreMaximizedElement(element, win);
        for (MUIElement toMinimize : elementsToMinimize) {
            toMinimize.getTags().add(MINIMIZED);
            toMinimize.getTags().add(MINIMIZED_BY_ZOOM);
        }
        this.adjustCTFButtons(element);
        MinMaxAddonUtil.maximizeMinMaxChildrenArea(this, element);
    }

    private List<MUIElement> getElementsToMinimize(MUIElement element) {
        MWindow win = MinMaxAddonUtil.getWindowFor(element);
        MPerspective persp = win == null ? null : this.modelService.getActivePerspective(win);
        ArrayList<MUIElement> elementsToMinimize = new ArrayList<MUIElement>();
        int loc = this.modelService.getElementLocation(element);
        if ((loc & 1) != 0) {
            List pStacks;
            List<MPartStack> partStacksToMinimize = this.findValidElementsToMinimize(element, win, (MUIElement)win, null, MPartStack.class, 1, false);
            elementsToMinimize.addAll(partStacksToMinimize);
            Object perspStack = null;
            perspStack = persp == null ? ((pStacks = this.modelService.findElements((MUIElement)win, null, MPerspectiveStack.class)).size() > 0 ? (MUIElement)pStacks.get(0) : null) : persp.getParent();
            if (perspStack != null) {
                if (perspStack.getElementId() == null || perspStack.getElementId().length() == 0) {
                    perspStack.setElementId("PerspectiveStack");
                }
                elementsToMinimize.add((MUIElement)perspStack);
            }
            List<MPlaceholder> placeholderToMinimize = this.findValidElementsToMinimize(element, win, (MUIElement)win, ID_EDITOR_AREA, MPlaceholder.class, 1, true);
            elementsToMinimize.addAll(placeholderToMinimize);
        } else {
            List<MPartStack> partStacksToMinimize = this.findValidElementsToMinimize(element, win, (MUIElement)(persp == null ? win : persp), null, MPartStack.class, 11, false);
            elementsToMinimize.addAll(partStacksToMinimize);
            ArrayList<String> standaloneTag = new ArrayList<String>();
            standaloneTag.add("Standalone");
            List standaloneViews = this.modelService.findElements((MUIElement)(persp == null ? win : persp), null, MPlaceholder.class, standaloneTag, 11);
            for (MPlaceholder part : standaloneViews) {
                if (!part.isToBeRendered()) continue;
                elementsToMinimize.add((MUIElement)part);
            }
            List<MPlaceholder> placeholderToMinimize = this.findValidElementsToMinimize(element, win, (MUIElement)win, ID_EDITOR_AREA, MPlaceholder.class, 11, true);
            elementsToMinimize.addAll(placeholderToMinimize);
        }
        MinMaxAddonUtil.handleMinimizeOfMinMaxChildrenArea(this.modelService, element, win, persp, elementsToMinimize);
        return elementsToMinimize;
    }

    private <T extends MUIElement> List<T> findValidElementsToMinimize(MUIElement elementToMaximize, MWindow currentWindow, MUIElement searchRoot, String id, Class<T> clazz, int searchFlag, boolean allowSharedArea) {
        ArrayList<MUIElement> elementsToMinimize = new ArrayList<MUIElement>();
        List elements = this.modelService.findElements(searchRoot, id, clazz, null, searchFlag);
        for (MUIElement element : elements) {
            boolean validLocation;
            if (element == elementToMaximize || !element.isToBeRendered() || MinMaxAddonUtil.getWindowFor(element) != currentWindow) continue;
            int loc = this.modelService.getElementLocation(element);
            boolean inSharedArea = loc == 8;
            boolean bl = validLocation = allowSharedArea || !inSharedArea;
            if (!validLocation || element.getWidget() == null || !element.isVisible() || element.getTags().contains(MINIMIZED)) continue;
            elementsToMinimize.add(element);
        }
        return elementsToMinimize;
    }

    private void restoreMaximizedElement(MUIElement element, MWindow win) {
        MPerspective elePersp = this.modelService.getPerspectiveFor(element);
        if (elePersp == null) {
            return;
        }
        List curMax = this.modelService.findElements((MUIElement)win, null, MUIElement.class, Collections.singletonList(MAXIMIZED));
        if (curMax.size() > 0) {
            for (MUIElement maxElement : curMax) {
                MPerspective maxPersp;
                if (MinMaxAddonUtil.getWindowFor(maxElement) != win || (maxPersp = this.modelService.getPerspectiveFor(maxElement)) != elePersp || maxElement == element || MinMaxAddonUtil.isPartOfMinMaxChildrenArea(maxElement)) continue;
                this.ignoreTagChanges = true;
                try {
                    maxElement.getTags().remove(MAXIMIZED);
                }
                finally {
                    this.ignoreTagChanges = false;
                }
            }
        }
    }

    void unzoom(MUIElement element) {
        MWindow win = MinMaxAddonUtil.getWindowFor(element);
        List<MUIElement> elementsToRestore = this.getElementsToRestore(element);
        for (MUIElement toRestore : elementsToRestore) {
            toRestore.getTags().remove(MINIMIZED_BY_ZOOM);
            toRestore.getTags().remove(MINIMIZED);
        }
        this.adjustCTFButtons(element);
        MinMaxAddonUtil.unzoomStackOfMinMaxChildrenArea(this, element);
        EPartService partService = (EPartService)win.getContext().get(EPartService.class);
        partService.requestActivation();
    }

    private List<MUIElement> getElementsToRestore(MUIElement element) {
        MPerspectiveStack perspStack;
        List psList;
        int loc;
        MWindow win = MinMaxAddonUtil.getWindowFor(element);
        MPerspective persp = this.modelService.getActivePerspective(win);
        ArrayList<MUIElement> elementsToRestore = new ArrayList<MUIElement>();
        ArrayList<String> minTag = new ArrayList<String>();
        minTag.add(MINIMIZED_BY_ZOOM);
        boolean outsidePerspectives = (this.modelService.getElementLocation(element) & 1) != 0;
        List stacks = this.modelService.findElements((MUIElement)win, null, MPartStack.class, minTag, 11);
        for (MPartStack theStack : stacks) {
            int stackLoc;
            if (theStack.getWidget() == null || outsidePerspectives && ((stackLoc = this.modelService.getElementLocation((MUIElement)theStack)) & 1) == 0 || MinMaxAddonUtil.getWindowFor((MUIElement)theStack) != win) continue;
            elementsToRestore.add((MUIElement)theStack);
        }
        List views = this.modelService.findElements((MUIElement)win, null, MPlaceholder.class, minTag, 11);
        for (MPlaceholder ph : views) {
            if (ph.getWidget() == null || MinMaxAddonUtil.getWindowFor((MUIElement)ph) != win) continue;
            elementsToRestore.add((MUIElement)ph);
        }
        MPlaceholder eaPlaceholder = (MPlaceholder)this.modelService.find(ID_EDITOR_AREA, (MUIElement)(persp == null ? win : persp));
        if (element != eaPlaceholder && eaPlaceholder != null && eaPlaceholder.getTags().contains(MINIMIZED_BY_ZOOM)) {
            elementsToRestore.add((MUIElement)eaPlaceholder);
        }
        if (((loc = this.modelService.getElementLocation(element)) & 1) != 0 && (psList = this.modelService.findElements((MUIElement)win, null, MPerspectiveStack.class)).size() == 1 && element != (perspStack = (MPerspectiveStack)psList.get(0)) && perspStack != null && perspStack.getTags().contains(MINIMIZED_BY_ZOOM)) {
            elementsToRestore.add((MUIElement)perspStack);
        }
        MinMaxAddonUtil.addChildrenOfMinMaxChildrenAreaToRestoreList(this.modelService, element, win, persp, elementsToRestore);
        return elementsToRestore;
    }

    /*
     * WARNING - void declaration
     */
    private void createTrim(MUIElement element) {
        void window;
        MWindow win = MinMaxAddonUtil.getWindowFor(element);
        if (!(win instanceof MTrimmedWindow)) {
            return;
        }
        MTrimmedWindow mTrimmedWindow = (MTrimmedWindow)win;
        Shell winShell = (Shell)window.getWidget();
        String trimId = this.getTrimId(element, (MWindow)window);
        MToolControl trimStack = (MToolControl)this.modelService.find(trimId, (MUIElement)window);
        if (trimStack == null) {
            trimStack = MenuFactoryImpl.eINSTANCE.createToolControl();
            trimStack.setElementId(trimId);
            trimStack.setContributionURI(TrimStack.CONTRIBUTION_URI);
            trimStack.getTags().add("TrimStack");
            MTrimBar bar = this.getBarForElement(element, (MTrimmedWindow)window);
            int index = this.getCachedIndex(element);
            if (index == -1 || index >= bar.getChildren().size()) {
                bar.getChildren().add(trimStack);
            } else {
                bar.getChildren().add(index, trimStack);
            }
            bar.setVisible(true);
            if (bar.getWidget() == null) {
                bar.setToBeRendered(true);
                ((IPresentationEngine)this.context.get(IPresentationEngine.class)).createGui((MUIElement)bar, (Object)winShell, window.getContext());
            }
        } else {
            MElementContainer parent = trimStack.getParent();
            parent.setVisible(true);
            if (parent.getWidget() == null) {
                parent.setToBeRendered(true);
                ((IPresentationEngine)this.context.get(IPresentationEngine.class)).createGui((MUIElement)parent, (Object)winShell, window.getContext());
            }
            trimStack.setToBeRendered(true);
        }
    }

    private String getTrimId(MUIElement element, MWindow window) {
        String trimId = MinMaxAddonUtil.isPartOfMinMaxChildrenArea(element) ? TrimStackIdHelper.createTrimStackId(element, null, window) : TrimStackIdHelper.createTrimStackId(element, this.modelService.getPerspectiveFor(element), window);
        return trimId;
    }

    private String getCachedInfo(MUIElement element) {
        String cacheId = GLOBAL_CACHE_ID;
        MPerspective persp = this.modelService.getPerspectiveFor(element);
        if (persp != null) {
            cacheId = persp.getElementId();
        }
        return (String)this.minMaxAddon.getPersistedState().get(cacheId);
    }

    private int getCachedIndex(MUIElement element) {
        String[] stacks;
        String cache = this.getCachedInfo(element);
        if (cache == null) {
            return -1;
        }
        String[] stringArray = stacks = cache.split("#");
        int n = stacks.length;
        int n2 = 0;
        while (n2 < n) {
            String stackInfo = stringArray[n2];
            String[] vals = stackInfo.split(" ");
            if (vals[0].equals(element.getElementId())) {
                return Integer.parseInt(vals[2]);
            }
            ++n2;
        }
        return -1;
    }

    private SideValue getCachedBar(MUIElement element) {
        String[] stacks;
        String cache = this.getCachedInfo(element);
        if (cache == null) {
            return null;
        }
        String[] stringArray = stacks = cache.split("#");
        int n = stacks.length;
        int n2 = 0;
        while (n2 < n) {
            String stackInfo = stringArray[n2];
            String[] vals = stackInfo.split(" ");
            if (vals[0].equals(element.getElementId())) {
                int sideVal = Integer.parseInt(vals[1]);
                return SideValue.get((int)sideVal);
            }
            ++n2;
        }
        return null;
    }

    private MTrimBar getBarForElement(MUIElement element, MTrimmedWindow window) {
        SideValue side = this.getCachedBar(element);
        if (side == null) {
            Shell winShell = (Shell)window.getWidget();
            Rectangle winBounds = winShell.getBounds();
            int winCenterX = winBounds.width / 2;
            Control stackCtrl = (Control)element.getWidget();
            Rectangle stackBounds = stackCtrl.getBounds();
            stackBounds = winShell.getDisplay().map(stackCtrl, (Control)winShell, stackBounds);
            int stackCenterX = stackBounds.x + stackBounds.width / 2;
            side = stackCenterX < winCenterX ? SideValue.LEFT : SideValue.RIGHT;
        }
        return this.modelService.getTrim(window, side);
    }

    private static /* synthetic */ void lambda$0(Shell shell) {
        if (!shell.isDisposed()) {
            shell.layout(true, true);
        }
    }
}

