/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.function.Supplier;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.Win32DPIUtils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoordinateSystemMapper;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;

class MultiZoomCoordinateSystemMapper
implements CoordinateSystemMapper {
    private final Display display;
    Supplier<Monitor[]> monitorSupplier;

    private MultiZoomCoordinateSystemMapper(Display display) {
        this.display = display;
    }

    MultiZoomCoordinateSystemMapper(Display display, Supplier<Monitor[]> monitorSupplier) {
        this(display);
        this.monitorSupplier = monitorSupplier;
    }

    @Override
    public Point map(Control from, Control to, Point point) {
        return this.map(from, to, point.x, point.y);
    }

    @Override
    public Rectangle map(Control from, Control to, Rectangle rectangle) {
        return this.map(from, to, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public Point map(Control from, Control to, int x, int y) {
        Point mappedPointInPoints;
        if (from == null) {
            Point mappedPointInpixels = this.display.mapInPixels(from, to, this.getPixelsFromPoint(to.getShell().getMonitor(), x, y));
            mappedPointInPoints = Win32DPIUtils.pixelToPointAsLocation(mappedPointInpixels, to.getZoom());
        } else if (to == null) {
            Point mappedPointInpixels = this.display.mapInPixels(from, to, Win32DPIUtils.pointToPixelAsLocation(new Point(x, y), from.getZoom()));
            mappedPointInPoints = this.getPointFromPixels(from.getShell().getMonitor(), mappedPointInpixels.x, mappedPointInpixels.y);
        } else {
            Point mappedPointInpixels = this.display.mapInPixels(from, to, Win32DPIUtils.pointToPixelAsLocation(new Point(x, y), from.getZoom()));
            mappedPointInPoints = Win32DPIUtils.pixelToPointAsLocation(mappedPointInpixels, to.getZoom());
        }
        return mappedPointInPoints;
    }

    @Override
    public Rectangle map(Control from, Control to, int x, int y, int width, int height) {
        Rectangle mappedRectangleInPoints;
        if (from == null) {
            Rectangle mappedRectangleInPixels = this.display.mapInPixels(from, to, this.translateRectangleInPointsToPixels(x, y, width, height, to.getShell().getMonitor()));
            mappedRectangleInPoints = Win32DPIUtils.pixelToPoint(mappedRectangleInPixels, to.getZoom());
        } else if (to == null) {
            Rectangle mappedRectangleInPixels = this.display.mapInPixels(from, to, Win32DPIUtils.pointToPixel(new Rectangle(x, y, width, height), from.getZoom()));
            mappedRectangleInPoints = this.translateRectangleInPixelsToPoints(mappedRectangleInPixels.x, mappedRectangleInPixels.y, mappedRectangleInPixels.width, mappedRectangleInPixels.height, from.getShell().getMonitor());
        } else {
            Rectangle mappedRectangleInPixels = this.display.mapInPixels(from, to, Win32DPIUtils.pointToPixel(new Rectangle(x, y, width, height), from.getZoom()));
            mappedRectangleInPoints = Win32DPIUtils.pixelToPoint(mappedRectangleInPixels, to.getZoom());
        }
        return mappedRectangleInPoints;
    }

    @Override
    public Rectangle mapMonitorBounds(Rectangle.WithMonitor rect) {
        Monitor monitor = rect.getMonitor();
        int zoom = this.getApplicableMonitorZoom(monitor);
        Rectangle bounds = Win32DPIUtils.pixelToPoint(rect, zoom);
        bounds.x = rect.x;
        bounds.y = rect.y;
        return bounds;
    }

    @Override
    public Point translateFromDisplayCoordinates(Point point) {
        Monitor monitor;
        if (point instanceof Point.WithMonitor) {
            Point.WithMonitor pointWithMonitor = (Point.WithMonitor)point;
            monitor = pointWithMonitor.getMonitor();
        } else {
            monitor = null;
        }
        Monitor monitor2 = monitor;
        return this.translateLocationInPixelsToPoints(point.x, point.y, monitor2);
    }

    @Override
    public Point translateToDisplayCoordinates(Point point) {
        Monitor monitor;
        if (point instanceof Point.WithMonitor) {
            Point.WithMonitor pointWithMonitor = (Point.WithMonitor)point;
            monitor = pointWithMonitor.getMonitor();
        } else {
            monitor = null;
        }
        Monitor monitor2 = monitor;
        return this.translateLocationInPointsToPixels(point.x, point.y, monitor2);
    }

    @Override
    public Rectangle translateFromDisplayCoordinates(Rectangle rect) {
        Monitor monitor;
        if (rect instanceof Rectangle.WithMonitor) {
            Rectangle.WithMonitor rectWithMonitor = (Rectangle.WithMonitor)rect;
            monitor = rectWithMonitor.getMonitor();
        } else {
            monitor = null;
        }
        Monitor monitor2 = monitor;
        return this.translateRectangleInPixelsToPoints(rect.x, rect.y, rect.width, rect.height, monitor2);
    }

    @Override
    public Rectangle translateToDisplayCoordinates(Rectangle rect) {
        Monitor monitor;
        if (rect instanceof Rectangle.WithMonitor) {
            Rectangle.WithMonitor rectWithMonitor = (Rectangle.WithMonitor)rect;
            monitor = rectWithMonitor.getMonitor();
        } else {
            monitor = null;
        }
        Monitor monitor2 = monitor;
        return this.translateRectangleInPointsToPixels(rect.x, rect.y, rect.width, rect.height, monitor2);
    }

    @Override
    public Point getCursorLocation() {
        Point cursorLocationInPixels = this.display.getCursorLocationInPixels();
        return this.translateLocationInPixelsToPoints(cursorLocationInPixels.x, cursorLocationInPixels.y, null);
    }

    @Override
    public void setCursorLocation(int x, int y) {
        Point cursorLocationInPixels = this.translateLocationInPointsToPixels(x, y, null);
        this.display.setCursorLocationInPixels(cursorLocationInPixels.x, cursorLocationInPixels.y);
    }

    private Point translateLocationInPointsToPixels(int x, int y, Monitor monitor) {
        monitor = this.getValidMonitorIfApplicable(x, y, monitor);
        return this.getPixelsFromPoint(monitor, x, y);
    }

    private Point translateLocationInPixelsToPoints(int x, int y, Monitor monitor) {
        if (monitor == null) {
            monitor = this.getContainingMonitorForPixels(x, y);
        }
        return this.getPointFromPixels(monitor, x, y);
    }

    private Rectangle translateRectangleInPointsToPixels(int x, int y, int width, int height, Monitor monitor) {
        monitor = this.getValidMonitorIfApplicable(x, y, width, height, monitor);
        Point topLeft = this.getPixelsFromPoint(monitor, x, y);
        int zoom = this.getApplicableMonitorZoom(monitor);
        int widthInPixels = DPIUtil.pointToPixel(width, zoom);
        int heightInPixels = DPIUtil.pointToPixel(height, zoom);
        return new Rectangle(topLeft.x, topLeft.y, widthInPixels, heightInPixels);
    }

    private Rectangle translateRectangleInPixelsToPoints(int x, int y, int widthInPixels, int heightInPixels, Monitor monitor) {
        if (monitor == null) {
            monitor = this.getContainingMonitorForPixels(x, y, widthInPixels, heightInPixels);
        }
        int zoom = this.getApplicableMonitorZoom(monitor);
        Point topLeft = this.getPointFromPixels(monitor, x, y);
        int width = DPIUtil.pixelToPoint(widthInPixels, zoom);
        int height = DPIUtil.pixelToPoint(heightInPixels, zoom);
        Rectangle.WithMonitor rect = new Rectangle.WithMonitor(topLeft.x, topLeft.y, width, height, monitor);
        return rect;
    }

    private Monitor getValidMonitorIfApplicable(int x, int y, int width, int height, Monitor monitor) {
        if (monitor != null) {
            if (monitor.getClientArea().intersects(x, y, width, height)) {
                return monitor;
            }
            Monitor containingMonitor = this.getContainingMonitorForPoints(x, y, width, height);
            return containingMonitor != null ? containingMonitor : monitor;
        }
        Monitor containingMonitor = this.getContainingMonitorForPoints(x, y, width, height);
        return containingMonitor != null ? containingMonitor : this.monitorSupplier.get()[0];
    }

    private Monitor getValidMonitorIfApplicable(int x, int y, Monitor monitor) {
        if (monitor != null) {
            if (monitor.getClientArea().contains(x, y)) {
                return monitor;
            }
            Monitor containingMonitor = this.getContainingMonitorForPoints(x, y);
            return containingMonitor != null ? containingMonitor : monitor;
        }
        Monitor containingMonitor = this.getContainingMonitorForPoints(x, y);
        return containingMonitor != null ? containingMonitor : this.monitorSupplier.get()[0];
    }

    private Monitor getContainingMonitorForPoints(int x, int y) {
        Monitor[] monitors;
        Monitor[] monitorArray = monitors = this.monitorSupplier.get();
        int n = monitors.length;
        int n2 = 0;
        while (n2 < n) {
            Monitor currentMonitor = monitorArray[n2];
            Rectangle clientArea = currentMonitor.getClientArea();
            if (clientArea.contains(x, y)) {
                return currentMonitor;
            }
            ++n2;
        }
        return null;
    }

    private Monitor getContainingMonitorForPoints(int x, int y, int width, int height) {
        if (width <= 0 || height <= 0) {
            return this.getContainingMonitorForPoints(x, y);
        }
        Monitor[] monitors = this.monitorSupplier.get();
        Monitor selectedMonitor = null;
        int highestIntersectionRatio = 0;
        Monitor[] monitorArray = monitors;
        int n = monitors.length;
        int n2 = 0;
        while (n2 < n) {
            Monitor currentMonitor = monitorArray[n2];
            Point topLeftOfRectangle = this.getPixelsFromPoint(currentMonitor, x, y);
            int widthInPixels = DPIUtil.pointToPixel(width, this.getApplicableMonitorZoom(currentMonitor));
            int heightInPixels = DPIUtil.pointToPixel(height, this.getApplicableMonitorZoom(currentMonitor));
            Rectangle boundsInPixel = new Rectangle(topLeftOfRectangle.x, topLeftOfRectangle.y, widthInPixels, heightInPixels);
            Rectangle clientArea = this.getMonitorClientAreaInPixels(currentMonitor);
            Rectangle intersection = clientArea.intersection(boundsInPixel);
            int intersectionArea = intersection.width * intersection.height;
            int boundsArea = boundsInPixel.width * boundsInPixel.height;
            int intersectionRatio = intersectionArea * 100 / boundsArea;
            if (intersectionRatio > highestIntersectionRatio) {
                selectedMonitor = currentMonitor;
                highestIntersectionRatio = intersectionRatio;
            }
            ++n2;
        }
        return selectedMonitor;
    }

    private Monitor getContainingMonitorForPixels(int xInPixels, int yInPixels) {
        Monitor[] monitors;
        Monitor[] monitorArray = monitors = this.monitorSupplier.get();
        int n = monitors.length;
        int n2 = 0;
        while (n2 < n) {
            Monitor current = monitorArray[n2];
            Rectangle clientArea = this.getMonitorClientAreaInPixels(current);
            if (clientArea.contains(xInPixels, yInPixels)) {
                return current;
            }
            ++n2;
        }
        return monitors[0];
    }

    private Monitor getContainingMonitorForPixels(int xInPixels, int yInPixels, int widthInPixels, int heightInPixels) {
        Rectangle rectangle = new Rectangle(xInPixels, yInPixels, widthInPixels, heightInPixels);
        Monitor[] monitors = this.monitorSupplier.get();
        Monitor selectedMonitor = monitors[0];
        int highestArea = 0;
        Monitor[] monitorArray = monitors;
        int n = monitors.length;
        int n2 = 0;
        while (n2 < n) {
            Monitor currentMonitor = monitorArray[n2];
            Rectangle clientArea = this.getMonitorClientAreaInPixels(currentMonitor);
            Rectangle intersection = clientArea.intersection(rectangle);
            int area = intersection.width * intersection.height;
            if (area > highestArea) {
                selectedMonitor = currentMonitor;
                highestArea = area;
            }
            ++n2;
        }
        return selectedMonitor;
    }

    private Rectangle getMonitorClientAreaInPixels(Monitor monitor) {
        int zoom = this.getApplicableMonitorZoom(monitor);
        int widthInPixels = DPIUtil.pointToPixel(monitor.clientWidth, zoom);
        int heightInPixels = DPIUtil.pointToPixel(monitor.clientHeight, zoom);
        return new Rectangle(monitor.clientX, monitor.clientY, widthInPixels, heightInPixels);
    }

    private Point getPixelsFromPoint(Monitor monitor, int x, int y) {
        int zoom = this.getApplicableMonitorZoom(monitor);
        int mappedX = DPIUtil.pointToPixel(x - monitor.clientX, zoom) + monitor.clientX;
        int mappedY = DPIUtil.pointToPixel(y - monitor.clientY, zoom) + monitor.clientY;
        return new Point(mappedX, mappedY);
    }

    private Point getPointFromPixels(Monitor monitor, int x, int y) {
        int zoom = this.getApplicableMonitorZoom(monitor);
        int mappedX = DPIUtil.pixelToPoint(x - monitor.clientX, zoom) + monitor.clientX;
        int mappedY = DPIUtil.pixelToPoint(y - monitor.clientY, zoom) + monitor.clientY;
        return new Point.WithMonitor(mappedX, mappedY, monitor);
    }

    private int getApplicableMonitorZoom(Monitor monitor) {
        return DPIUtil.getZoomForAutoscaleProperty(monitor.zoom);
    }

    @Override
    public Rectangle getContainingMonitorBoundsInPixels(Point point) {
        Monitor monitor;
        if (point instanceof Point.WithMonitor) {
            Point.WithMonitor monitorAwarePoint = (Point.WithMonitor)point;
            monitor = monitorAwarePoint.getMonitor();
        } else {
            monitor = this.getContainingMonitorForPoints(point.x, point.y);
        }
        Monitor monitor2 = monitor;
        return this.getMonitorClientAreaInPixels(monitor2);
    }
}

