/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class HideTrimBarsHandler
extends AbstractHandler {
    private static final String INITIAL_TRIM_VISIBILITY = "initialTrimVisibilityValue";
    private static final String WINDOWS_WITH_MINIMIZED_TRIMBARS = "windowsWithMinimizedTrimbars";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked(event);
        MTrimmedWindow winModel = (MTrimmedWindow)window.getService(MTrimmedWindow.class);
        EModelService modelService = (EModelService)window.getService(EModelService.class);
        if (winModel == null || modelService == null) {
            return null;
        }
        if (winModel.getTags().contains(WINDOWS_WITH_MINIMIZED_TRIMBARS)) {
            winModel.getTags().remove(WINDOWS_WITH_MINIMIZED_TRIMBARS);
            this.disableCodeFocus(winModel, modelService);
        } else {
            this.enableCodeFocus(winModel, modelService);
            winModel.getTags().add(WINDOWS_WITH_MINIMIZED_TRIMBARS);
        }
        return null;
    }

    private void disableCodeFocus(MTrimmedWindow window, EModelService modelService) {
        List tcList = modelService.findElements((MUIElement)window, null, MTrimBar.class);
        for (MTrimBar tc : tcList) {
            boolean visible = true;
            String initialTrimVisibility = (String)tc.getPersistedState().get(INITIAL_TRIM_VISIBILITY);
            if (initialTrimVisibility != null && !initialTrimVisibility.isEmpty()) {
                visible = Boolean.parseBoolean(initialTrimVisibility);
                tc.getPersistedState().remove(INITIAL_TRIM_VISIBILITY);
            }
            tc.setVisible(visible);
        }
    }

    private void enableCodeFocus(MTrimmedWindow window, EModelService modelService) {
        List tcList = modelService.findElements((MUIElement)window, null, MTrimBar.class);
        for (MTrimBar tc : tcList) {
            tc.getPersistedState().put(INITIAL_TRIM_VISIBILITY, String.valueOf(tc.isVisible()));
            tc.setVisible(false);
        }
    }
}

