/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.build.AbstractStreamBuilder;

public class ProxyOutputStream
extends FilterOutputStream {
    ProxyOutputStream(Builder builder) throws IOException {
        super(builder.getOutputStream());
    }

    public ProxyOutputStream(OutputStream delegate) {
        super(delegate);
    }

    protected void afterWrite(int n) throws IOException {
    }

    protected void beforeWrite(int n) throws IOException {
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable)this.out, this::handleIOException);
    }

    @Override
    public void flush() throws IOException {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    protected void handleIOException(IOException e) throws IOException {
        throw e;
    }

    public ProxyOutputStream setReference(OutputStream out) {
        this.out = out;
        return this;
    }

    OutputStream unwrap() {
        return this.out;
    }

    @Override
    public void write(byte[] b) throws IOException {
        try {
            int len = IOUtils.length(b);
            this.beforeWrite(len);
            this.out.write(b);
            this.afterWrite(len);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.beforeWrite(len);
            this.out.write(b, off, len);
            this.afterWrite(len);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.beforeWrite(1);
            this.out.write(b);
            this.afterWrite(1);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    public void writeRepeat(byte[] b, int off, int len, long repeat) throws IOException {
        long remains = repeat;
        while (remains-- > 0L) {
            this.write(b, off, len);
        }
    }

    public void writeRepeat(byte[] b, long repeat) throws IOException {
        long remains = repeat;
        while (remains-- > 0L) {
            this.write(b);
        }
    }

    public void writeRepeat(int b, long repeat) throws IOException {
        long remains = repeat;
        while (remains-- > 0L) {
            this.write(b);
        }
    }

    public static class Builder
    extends AbstractStreamBuilder<ProxyOutputStream, Builder> {
        @Override
        public ProxyOutputStream get() throws IOException {
            return new ProxyOutputStream(this);
        }
    }
}

