/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hierarchical;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.config.DefaultComparator;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.hierarchical.HierarchicalWrapper;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;

public class HierarchicalWrapperComparator
implements Comparator<HierarchicalWrapper> {
    private IColumnAccessor<HierarchicalWrapper> columnAccessor;
    private Map<Integer, List<Integer>> levelIndexMapping;
    private ISortModel sortModel;

    public HierarchicalWrapperComparator(IColumnAccessor<HierarchicalWrapper> columnAccessor, Map<Integer, List<Integer>> levelIndexMapping) {
        this(columnAccessor, levelIndexMapping, null);
    }

    public HierarchicalWrapperComparator(IColumnAccessor<HierarchicalWrapper> columnAccessor, Map<Integer, List<Integer>> levelIndexMapping, ISortModel sortModel) {
        this.columnAccessor = columnAccessor;
        this.levelIndexMapping = levelIndexMapping;
        this.sortModel = sortModel;
    }

    @Override
    public int compare(HierarchicalWrapper o1, HierarchicalWrapper o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null && o2 != null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1 == o2) {
            return 0;
        }
        if (o1.getLevels() != o2.getLevels()) {
            return o1.getLevels() - o2.getLevels();
        }
        int level = 0;
        Object o1LvlObject = o1.getObject(level);
        Object o2LvlObject = o2.getObject(level);
        while (o1LvlObject == o2LvlObject && level < this.levelIndexMapping.size()) {
            o1LvlObject = o1.getObject(++level);
            o2LvlObject = o2.getObject(level);
        }
        int result = 0;
        if (o1LvlObject == null && o2LvlObject != null) {
            result = -1;
        } else if (o2LvlObject == null) {
            result = 1;
        } else if (o1LvlObject != null && o2LvlObject != null) {
            result = this.compareLevel(o1, o2, level);
        }
        if (result < 0) {
            result = -1;
        } else if (result > 0) {
            result = 1;
        }
        return result;
    }

    protected int compareLevel(HierarchicalWrapper o1, HierarchicalWrapper o2, int level) {
        List<Integer> levelIndexes = this.levelIndexMapping.get(level);
        int result = 0;
        if (this.sortModel != null) {
            List<Integer> sortedColumnIndexes = this.sortModel.getSortedColumnIndexes();
            for (Integer sorted : sortedColumnIndexes) {
                if (levelIndexes.contains(sorted) && (result = this.compareColumn(o1, o2, sorted, false)) != 0) break;
            }
        }
        return result;
    }

    protected int compareColumn(HierarchicalWrapper o1, HierarchicalWrapper o2, int columnIndex, boolean useDefault) {
        Object value1 = this.columnAccessor.getDataValue(o1, columnIndex);
        Object value2 = this.columnAccessor.getDataValue(o2, columnIndex);
        int result = this.getComparator(columnIndex, useDefault).compare(value1, value2);
        if (result != 0 && this.sortModel != null && this.sortModel.getSortDirection(columnIndex).equals((Object)SortDirectionEnum.DESC)) {
            result *= -1;
        }
        return result;
    }

    protected Comparator getComparator(int columnIndex, boolean useDefault) {
        DefaultComparator result = null;
        if (this.sortModel != null) {
            result = this.sortModel.getColumnComparator(columnIndex);
        }
        if (result == null && useDefault) {
            result = DefaultComparator.getInstance();
        }
        return result;
    }

    public ISortModel getSortModel() {
        return this.sortModel;
    }

    public void setSortModel(ISortModel sortModel) {
        this.sortModel = sortModel;
    }
}

