/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.rename;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.xtext.ide.serializer.IEmfResourceChange;
import org.eclipse.xtext.ide.serializer.ITextDocumentChange;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.server.ILanguageServerAccess;
import org.eclipse.xtext.ide.server.TextEditAcceptor;
import org.eclipse.xtext.ide.server.UriExtensions;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class ChangeConverter2
implements IAcceptor<IEmfResourceChange> {
    private IResourceServiceProvider.Registry registry;
    private UriExtensions uriExtensions;
    private ILanguageServerAccess access;
    private TextEditAcceptor textEditAcceptor;

    protected ChangeConverter2(IResourceServiceProvider.Registry registry, WorkspaceEdit edit, ILanguageServerAccess access, UriExtensions uriExtensions) {
        this.registry = registry;
        this.uriExtensions = uriExtensions;
        this.access = access;
        this.textEditAcceptor = new TextEditAcceptor(edit, access);
    }

    public void accept(IEmfResourceChange change) {
        this.handleReplacements(change);
    }

    protected void _handleReplacements(IEmfResourceChange change) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            String uri = this.uriExtensions.toUriString(change.getResource().getURI());
            change.getResource().save((OutputStream)outputStream, null);
            String newContent = new String(outputStream.toByteArray(), this.getCharset(change.getResource()));
            this.access.doRead(uri, context -> {
                Document document = context.getDocument();
                Range range = new Range(document.getPosition(0), document.getPosition(document.getContents().length()));
                TextEdit textEdit = new TextEdit(range, newContent);
                this.addTextEdit(uri, document, textEdit);
                return null;
            }).get();
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw Exceptions.sneakyThrow((Throwable)e);
        }
    }

    protected String getCharset(Resource resource) {
        IEncodingProvider xtextEncodingProvider = (IEncodingProvider)this.registry.getResourceServiceProvider(resource.getURI()).get(IEncodingProvider.class);
        if (xtextEncodingProvider != null) {
            return xtextEncodingProvider.getEncoding(resource.getURI());
        }
        if (resource instanceof XMLResource) {
            return ((XMLResource)resource).getEncoding();
        }
        return Charset.defaultCharset().toString();
    }

    protected void _handleReplacements(ITextDocumentChange change) {
        try {
            if (change.getReplacements().size() > 0) {
                String uri = this.uriExtensions.toUriString(change.getNewURI());
                this.access.doRead(uri, context -> {
                    Document document = context.getDocument();
                    List textEdits = Lists.transform(change.getReplacements(), replacement -> {
                        Position start = document.getPosition(replacement.getOffset());
                        Position end = document.getPosition(replacement.getEndOffset());
                        Range range = new Range(start, end);
                        return new TextEdit(range, replacement.getReplacementText());
                    });
                    this.addTextEdit(uri, document, textEdits.toArray(new TextEdit[textEdits.size()]));
                    return null;
                }).get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw Exceptions.sneakyThrow((Throwable)e);
        }
    }

    protected void addTextEdit(String theUri, Document document, TextEdit ... textEdits) {
        this.textEditAcceptor.accept(theUri, document, Arrays.asList(textEdits));
    }

    protected void handleReplacements(IEmfResourceChange change) {
        if (change instanceof ITextDocumentChange) {
            this._handleReplacements((ITextDocumentChange)change);
            return;
        }
        if (change != null) {
            this._handleReplacements(change);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(change).toString());
    }

    public static class Factory {
        @Inject
        protected IResourceServiceProvider.Registry registry;
        @Inject
        protected UriExtensions uriExtensions;

        public ChangeConverter2 create(WorkspaceEdit edit, ILanguageServerAccess access) {
            return new ChangeConverter2(this.registry, edit, access, this.uriExtensions);
        }
    }
}

