/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.common.AtlNbCharFile;
import org.eclipse.m2m.atl.core.IModel;
import org.eclipse.m2m.atl.engine.Messages;
import org.eclipse.m2m.atl.engine.parser.AtlParser;

public class MarkerMaker {
    public static final String PROBLEM_MARKER = "org.eclipse.m2m.atl.engine.problem";
    private static Map severities = new HashMap();

    static {
        severities.put("error", new Integer(2));
        severities.put("warning", new Integer(1));
        severities.put("critic", new Integer(0));
    }

    private void eObjectToPbmMarker(IResource res, AtlNbCharFile help, EObject problem, int tabWidth) {
        EPackage pkProblem = null;
        EClass clProblem = null;
        EStructuralFeature sfSeverity = null;
        EStructuralFeature sfLocation = null;
        EStructuralFeature sfDescription = null;
        pkProblem = problem.eClass().getEPackage();
        clProblem = (EClass)pkProblem.getEClassifier("Problem");
        sfSeverity = clProblem.getEStructuralFeature("severity");
        sfLocation = clProblem.getEStructuralFeature("location");
        sfDescription = clProblem.getEStructuralFeature("description");
        String description = (String)problem.eGet(sfDescription);
        String location = (String)problem.eGet(sfLocation);
        String[] parts = location.split("-")[0].split(":");
        int lineNumber = Integer.parseInt(parts[0]);
        int columnNumber = Integer.parseInt(parts[1]);
        int charStart = 0;
        int charEnd = 0;
        try {
            if (location.indexOf(45) == -1) {
                location = String.valueOf(location) + '-' + location;
            }
            int[] pos = help.getIndexChar(location, tabWidth);
            charStart = pos[0];
            charEnd = pos[1];
        }
        catch (Exception e) {
            description = String.valueOf(description) + " [location \"" + location + "\" incorrectly reported because of error]";
        }
        String severity = ((EEnumLiteral)problem.eGet(sfSeverity)).getName();
        int eclipseSeverity = (Integer)severities.get(severity);
        try {
            IMarker pbmMarker = res.createMarker(PROBLEM_MARKER);
            pbmMarker.setAttribute("severity", eclipseSeverity);
            pbmMarker.setAttribute("message", (Object)description);
            pbmMarker.setAttribute("lineNumber", lineNumber);
            pbmMarker.setAttribute("location", (Object)Messages.getString("MarkerMaker.LINECOLUMN", new Object[]{new Integer(lineNumber), new Integer(columnNumber)}));
            pbmMarker.setAttribute("charStart", charStart);
            pbmMarker.setAttribute("charEnd", charEnd > charStart ? charEnd : charStart + 1);
        }
        catch (CoreException e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void createPbmMarkers(IResource res, EObject[] eos, int tabWidth) {
        try {
            AtlNbCharFile help = new AtlNbCharFile(((IFile)res).getContents());
            int i = 0;
            while (i < eos.length) {
                this.eObjectToPbmMarker(res, help, eos[i], tabWidth);
                ++i;
            }
        }
        catch (CoreException e1) {
            ATLLogger.log((Level)Level.SEVERE, (String)e1.getLocalizedMessage(), (Throwable)e1);
        }
    }

    public void resetPbmMarkers(IResource res, EObject[] eos) throws CoreException {
        this.resetPbmMarkers(res, eos, -1);
    }

    private void resetPbmMarkers(final IResource res, final EObject[] eos, final int tabWidth) throws CoreException {
        IWorkspaceRunnable r = new IWorkspaceRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(IProgressMonitor monitor) throws CoreException {
                IResource iResource = res;
                synchronized (iResource) {
                    try {
                        res.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                    }
                    catch (CoreException e) {
                        ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
                    }
                    MarkerMaker.this.createPbmMarkers(res, eos, tabWidth);
                }
            }
        };
        res.getWorkspace().run(r, null, 1, null);
    }

    public int applyMarkers(IFile file, IModel pbs) throws CoreException {
        return this.applyMarkers(file, pbs, -1);
    }

    private int applyMarkers(IFile file, IModel pbs, int tabWidth) throws CoreException {
        int nbErrors = 0;
        Object problemType = AtlParser.getDefault().getProblemMetamodel().getMetaElementByName("Problem");
        Set pbsc = pbs.getElementsByType(problemType);
        EObject[] pbsa = new EObject[pbsc.size()];
        int k = 0;
        Iterator i = pbsc.iterator();
        while (i.hasNext()) {
            EObject ame;
            pbsa[k] = ame = (EObject)i.next();
            EStructuralFeature severityFeature = ame.eClass().getEStructuralFeature("severity");
            if ("error".equals(((EEnumLiteral)ame.eGet(severityFeature)).getName())) {
                ++nbErrors;
            }
            ++k;
        }
        this.resetPbmMarkers((IResource)file, pbsa, tabWidth);
        return nbErrors;
    }
}

