/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.drivers.uml24atl;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.m2m.atl.drivers.uml24atl.ASMUMLModelElement;
import org.eclipse.m2m.atl.drivers.uml24atl.Invocation;
import org.eclipse.m2m.atl.engine.vm.ModelLoader;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModelElement;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;

public class ASMUMLModel
extends ASMModel {
    protected boolean unload = false;
    protected Set unregister = new HashSet();
    protected String resolveURI = null;
    private boolean checkSameModel = true;
    private Map modelElements = new HashMap();
    private Map classifiers = null;
    private static ResourceSet resourceSet;
    private static ASMUMLModel mofmm;
    private Resource extent;
    private Set referencedExtents = new HashSet();
    private List delayedInvocations = new ArrayList();

    static {
        ASMUMLModel.init();
        mofmm = null;
    }

    public static ASMModel getMOF() {
        return mofmm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ASMModelElement getASMModelElement(EObject object) {
        ASMModelElement ret = null;
        Map map = this.modelElements;
        synchronized (map) {
            ret = (ASMModelElement)this.modelElements.get(object);
            if (ret == null) {
                ret = new ASMUMLModelElement(this.modelElements, this, object);
            }
        }
        return ret;
    }

    private ASMModelElement getClassifier(String name) {
        if (this.classifiers == null) {
            this.classifiers = new HashMap();
            this.initClassifiersInAllExtents(this.classifiers);
        }
        ASMModelElement ret = null;
        EObject eo = (EObject)this.classifiers.get(name);
        if (eo != null) {
            ret = this.getASMModelElement(eo);
        }
        return ret;
    }

    private void initClassifiersInAllExtents(Map classifiers) {
        this.initClassifiers(this.getExtent().getContents().iterator(), classifiers, null);
        Iterator refExtents = this.referencedExtents.iterator();
        while (refExtents.hasNext()) {
            this.initClassifiers(((Resource)refExtents.next()).getContents().iterator(), classifiers, null);
        }
    }

    private void initClassifiers(Iterator i, Map classifiers, String base) {
        while (i.hasNext()) {
            String name;
            EObject eo = (EObject)i.next();
            if (eo instanceof EPackage) {
                name = ((EPackage)eo).getName();
                if (base != null) {
                    name = String.valueOf(base) + "::" + name;
                }
                this.initClassifiers(((EPackage)eo).eContents().iterator(), classifiers, name);
                continue;
            }
            if (eo instanceof EClassifier) {
                name = ((EClassifier)eo).getName();
                this.register(classifiers, name, eo);
                if (base == null) continue;
                name = String.valueOf(base) + "::" + name;
                this.register(classifiers, name, eo);
                continue;
            }
            this.initClassifiers(eo.eContents().iterator(), classifiers, base);
        }
    }

    private void register(Map classifiers, String name, EObject classifier) {
        if (classifiers.containsKey(name)) {
            System.out.println("Warning: metamodel contains several classifiers with same name: " + name);
        }
        classifiers.put(name, classifier);
    }

    public ASMModelElement findModelElement(String name) {
        ASMModelElement ret = null;
        ret = this.getClassifier(name);
        return ret;
    }

    public Set getElementsByType(ASMModelElement type) {
        HashSet ret = new HashSet();
        EClass t = (EClass)((ASMUMLModelElement)type).getObject();
        this.addElementsOfType(ret, (EClassifier)t, this.getExtent());
        for (Resource res : this.referencedExtents) {
            this.addElementsOfType(ret, (EClassifier)t, res);
        }
        return ret;
    }

    private void addElementsOfType(Set elements, EClassifier type, Resource res) {
        TreeIterator i = res.getAllContents();
        while (i.hasNext()) {
            EObject eo = (EObject)i.next();
            if (!type.isInstance((Object)eo)) continue;
            elements.add(this.getASMModelElement(eo));
        }
    }

    public ASMModelElement newModelElement(ASMModelElement type) {
        ASMUMLModelElement ret = null;
        EClass t = (EClass)((ASMUMLModelElement)type).getObject();
        EObject eo = t.getEPackage().getEFactoryInstance().create(t);
        ret = (ASMUMLModelElement)this.getASMModelElement(eo);
        this.getExtent().getContents().add((Object)eo);
        return ret;
    }

    private ASMUMLModel(String name, Resource extent, ASMUMLModel metamodel, boolean isTarget, ModelLoader ml) {
        super(name, (ASMModel)metamodel, isTarget, ml);
        this.extent = extent;
    }

    public static ASMUMLModel loadASMUMLModel(String name, ASMUMLModel metamodel, Resource extent, ModelLoader ml) throws Exception {
        ASMUMLModel ret = null;
        ret = new ASMUMLModel(name, extent, metamodel, false, ml);
        return ret;
    }

    public void dispose() {
        if (this.extent != null) {
            this.referencedExtents.clear();
            this.referencedExtents = null;
            for (String nsURI : this.unregister) {
                resourceSet.getPackageRegistry().remove((Object)nsURI);
            }
            resourceSet.getResources().remove((Object)this.extent);
            if (this.unload) {
                this.extent.unload();
            }
            this.extent = null;
            this.modelElements.clear();
            this.unregister.clear();
        }
    }

    public void finalize() {
        this.dispose();
    }

    public static ASMUMLModel newASMUMLModel(String name, ASMUMLModel metamodel, ModelLoader ml) throws Exception {
        return ASMUMLModel.newASMUMLModel(name, name, metamodel, ml);
    }

    public static ASMUMLModel newASMUMLModel(String name, String uri, ASMUMLModel metamodel, ModelLoader ml) throws Exception {
        ASMUMLModel ret = null;
        Resource extent = resourceSet.createResource(URI.createURI((String)uri));
        ret = new ASMUMLModel(name, extent, metamodel, true, ml);
        ret.unload = true;
        return ret;
    }

    public static ASMUMLModel loadASMUMLModel(String name, ASMUMLModel metamodel, String url, ModelLoader ml) throws Exception {
        ASMUMLModel ret = null;
        if (url.startsWith("uri:")) {
            String uri = url.substring(4);
            EPackage pack = resourceSet.getPackageRegistry().getEPackage(uri);
            if (pack == null) {
                ret = new ASMUMLModel(name, null, metamodel, false, ml);
                ret.resolveURI = uri;
            } else {
                Resource extent = pack.eResource();
                ret = new ASMUMLModel(name, extent, metamodel, false, ml);
                ret.addAllReferencedExtents();
            }
        } else {
            ret = ASMUMLModel.loadASMUMLModel(name, metamodel, URI.createURI((String)url), ml);
        }
        return ret;
    }

    public static ASMUMLModel loadASMUMLModel(String name, ASMUMLModel metamodel, URL url, ModelLoader ml) throws Exception {
        ASMUMLModel ret = null;
        ret = ASMUMLModel.loadASMUMLModel(name, metamodel, url.openStream(), ml);
        return ret;
    }

    public static ASMUMLModel loadASMUMLModel(String name, ASMUMLModel metamodel, URI uri, ModelLoader ml) throws Exception {
        ASMUMLModel ret = null;
        try {
            Resource extent = resourceSet.createResource(uri);
            extent.load(Collections.EMPTY_MAP);
            ret = new ASMUMLModel(name, extent, metamodel, true, ml);
            ret.addAllReferencedExtents();
            ret.setIsTarget(false);
            ret.unload = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ASMUMLModel.adaptMetamodel(ret, metamodel);
        return ret;
    }

    public static ASMUMLModel loadASMUMLModel(String name, ASMUMLModel metamodel, InputStream in, ModelLoader ml) throws Exception {
        ASMUMLModel ret = ASMUMLModel.newASMUMLModel(name, metamodel, ml);
        try {
            ret.getExtent().load(in, Collections.EMPTY_MAP);
            ret.addAllReferencedExtents();
            ret.unload = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ASMUMLModel.adaptMetamodel(ret, metamodel);
        ret.setIsTarget(false);
        return ret;
    }

    private static void adaptMetamodel(ASMUMLModel model, ASMUMLModel metamodel) {
        if (metamodel == mofmm) {
            for (ASMUMLModelElement ame : model.getElementsByType("EPackage")) {
                EPackage p = (EPackage)ame.getObject();
                String nsURI = p.getNsURI();
                if (nsURI == null) {
                    nsURI = p.getName();
                    p.setNsURI(nsURI);
                }
                if (resourceSet.getPackageRegistry().containsKey((Object)nsURI)) {
                    p.equals(resourceSet.getPackageRegistry().getEPackage(nsURI));
                } else {
                    model.unregister.add(nsURI);
                }
                resourceSet.getPackageRegistry().put((Object)nsURI, (Object)p);
            }
            for (ASMUMLModelElement ame : model.getElementsByType("EDataType")) {
                String tname = ((ASMString)ame.get(null, "name")).getSymbol();
                String icn = null;
                if (tname.equals("Boolean")) {
                    icn = "boolean";
                } else if (tname.equals("Double")) {
                    icn = "java.lang.Double";
                } else if (tname.equals("Float")) {
                    icn = "java.lang.Float";
                } else if (tname.equals("Integer")) {
                    icn = "java.lang.Integer";
                } else if (tname.equals("String")) {
                    icn = "java.lang.String";
                }
                if (icn == null) continue;
                ame.set(null, "instanceClassName", (ASMOclAny)new ASMString(icn));
            }
        }
    }

    public static ASMUMLModel createMOF(ModelLoader ml) {
        if (mofmm == null) {
            mofmm = new ASMUMLModel("MOF", EcorePackage.eINSTANCE.eResource(), null, false, ml);
        }
        return mofmm;
    }

    public Resource getExtent() {
        if (this.extent == null && this.resolveURI != null) {
            EPackage pack = resourceSet.getPackageRegistry().getEPackage(this.resolveURI);
            this.extent = pack.eResource();
            this.addAllReferencedExtents();
        }
        return this.extent;
    }

    private static void init() {
        Map etfm = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap();
        if (!etfm.containsKey("*")) {
            etfm.put("*", new XMIResourceFactoryImpl());
        }
        resourceSet = new ResourceSetImpl();
    }

    public boolean equals(Object o) {
        return o instanceof ASMUMLModel && ((ASMUMLModel)((Object)o)).extent == this.extent;
    }

    public boolean isCheckSameModel() {
        return this.checkSameModel;
    }

    public void setCheckSameModel(boolean checkSameModel) {
        this.checkSameModel = checkSameModel;
    }

    private void addAllReferencedExtents() {
        TreeIterator contents = this.getExtent().getAllContents();
        while (contents.hasNext()) {
            Object o = contents.next();
            if (!(o instanceof EClass)) continue;
            this.addReferencedExtentsFor((EClass)o, new HashSet());
        }
        this.referencedExtents.remove(this.getExtent());
    }

    private void addReferencedExtentsFor(EClass eClass, Set ignore) {
        if (ignore.contains(eClass)) {
            return;
        }
        ignore.add(eClass);
        for (EReference eRef : eClass.getEReferences()) {
            if (!eRef.isContainment()) continue;
            EClassifier eType = eRef.getEType();
            if (eType.eResource() != null) {
                this.referencedExtents.add(eType.eResource());
            } else {
                System.err.println("WARNING: Resource for " + eType.toString() + " is null; cannot be referenced");
            }
            if (!(eType instanceof EClass)) continue;
            this.addReferencedExtentsFor((EClass)eType, ignore);
        }
        for (EAttribute eAtt : eClass.getEAttributes()) {
            EClassifier eType = eAtt.getEType();
            if (eType.eResource() != null) {
                this.referencedExtents.add(eType.eResource());
                continue;
            }
            System.err.println("WARNING: Resource for " + eType.toString() + " is null; cannot be referenced");
        }
        for (EClass eSuper : eClass.getESuperTypes()) {
            if (eSuper.eResource() != null) {
                this.referencedExtents.add(eSuper.eResource());
                this.addReferencedExtentsFor(eSuper, ignore);
                continue;
            }
            System.err.println("WARNING: Resource for " + eSuper.toString() + " is null; cannot be referenced");
        }
    }

    public Set getReferencedExtents() {
        return this.referencedExtents;
    }

    public int getLastStereotypeMethod(String opName, List delayedInvocations) {
        int rang = 0;
        int i = 0;
        while (i < delayedInvocations.size()) {
            Invocation invoc = (Invocation)delayedInvocations.get(rang);
            if (invoc.opName.equals(opName)) {
                rang = i;
            }
            ++i;
        }
        return rang;
    }

    public void addDelayedInvocation(Invocation invocation) {
        if (invocation.opName.equals("applyProfile")) {
            this.delayedInvocations.add(0, invocation);
        } else if (invocation.opName.equals("applyStereotype") || invocation.opName.equals("applyAllStereotypes") || invocation.opName.equals("applyAllRequiredStereotypes")) {
            int lastApplyProfile = this.getLastStereotypeMethod("applyProfile", this.delayedInvocations);
            if (lastApplyProfile < this.delayedInvocations.size() - 1) {
                this.delayedInvocations.add(lastApplyProfile + 1, invocation);
            } else {
                this.delayedInvocations.add(invocation);
            }
        } else {
            this.delayedInvocations.add(invocation);
        }
    }

    public void applyDelayedInvocations() {
        for (Invocation invocation : this.delayedInvocations) {
            invocation.self.realInvoke(invocation.frame, invocation.opName, invocation.arguments);
        }
    }
}

