/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.Shape;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.FillStyle;
import org.eclipse.gmf.runtime.notation.LineStyle;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CombinedFragmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionOperandEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.figures.DestructionEventFigure;
import org.eclipse.swt.graphics.Color;

public class HighlightUtil {
    private static Map<Object, FigureState> figureState = new HashMap<Object, FigureState>();

    private HighlightUtil() {
    }

    private static Color getHighlightBackground(Color bgColor) {
        return bgColor;
    }

    private static int getHighlightLineWidth(int lineWidth) {
        return lineWidth * 2;
    }

    private static List<IFigure> getHighlightFigures(EditPart host) {
        ArrayList<IFigure> figures = new ArrayList<IFigure>();
        if (host instanceof LifelineEditPart) {
            LifelineEditPart part = (LifelineEditPart)host;
            figures.add((IFigure)part.getPrimaryShape().getFigureLifelineDotLineFigure());
        } else if (host instanceof InteractionOperandEditPart) {
            InteractionOperandEditPart op = (InteractionOperandEditPart)host;
            EditPart parent = op.getParent();
            while (parent != null) {
                if (parent instanceof CombinedFragmentEditPart) {
                    figures.add((IFigure)((CombinedFragmentEditPart)parent).getPrimaryShape());
                    break;
                }
                parent = parent.getParent();
            }
        } else if (host != null) {
            try {
                Method getMethod = HighlightUtil.getGetPrimaryShapeMethod(host.getClass());
                getMethod.setAccessible(true);
                figures.add((IFigure)getMethod.invoke((Object)host, new Object[0]));
            }
            catch (Exception e) {
                return HighlightUtil.getHighlightFigures(host.getParent());
            }
        }
        return figures;
    }

    protected static Method getGetPrimaryShapeMethod(Class<?> type) throws Exception {
        if (type == null) {
            throw new NoSuchMethodException("getPrimaryShape");
        }
        try {
            return type.getDeclaredMethod("getPrimaryShape", new Class[0]);
        }
        catch (Exception e) {
            Method method = HighlightUtil.getGetPrimaryShapeMethod(type.getSuperclass());
            if (method == null) {
                throw e;
            }
            return method;
        }
    }

    private static Color getHighlightForeground(Color fgColor) {
        return fgColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void highlight(EditPart host) {
        List<IFigure> highlightFigures = HighlightUtil.getHighlightFigures(host);
        if (highlightFigures.isEmpty()) {
            return;
        }
        Map<Object, FigureState> map = figureState;
        synchronized (map) {
            for (IFigure figure : highlightFigures) {
                FigureState fs = figureState.get(figure);
                if (fs == null) {
                    fs = HighlightUtil.createFigureState(host, figure);
                    figureState.put(figure, fs);
                }
                HighlightUtil.updateFigure(figure, HighlightUtil.getHighlightBackground(fs.bgColor), HighlightUtil.getHighlightForeground(fs.fgColor), HighlightUtil.getHighlightLineWidth(fs.lineWidth));
            }
        }
    }

    protected static FigureState createFigureState(EditPart host, IFigure fig) {
        int lineWidth = 1;
        Color bgColor = null;
        Color fgColor = null;
        Object model = host.getModel();
        if (model instanceof LineStyle) {
            int modelLineWidth = ((LineStyle)model).getLineWidth();
            if (modelLineWidth != -1) {
                lineWidth = modelLineWidth;
            }
            int lineColor = ((LineStyle)model).getLineColor();
            fgColor = DiagramColorRegistry.getInstance().getColor(Integer.valueOf(lineColor));
        } else {
            Border border = fig.getBorder();
            if (border instanceof LineBorder) {
                lineWidth = ((LineBorder)border).getWidth();
            } else if (fig instanceof Shape) {
                lineWidth = ((Shape)fig).getLineWidth();
            }
            fgColor = fig.getForegroundColor();
        }
        if (model instanceof FillStyle) {
            int fillColor = ((FillStyle)model).getFillColor();
            bgColor = DiagramColorRegistry.getInstance().getColor(Integer.valueOf(fillColor));
        } else {
            bgColor = fig.getBackgroundColor();
        }
        return new FigureState(bgColor, fgColor, lineWidth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unhighlight() {
        if (figureState == null || figureState.isEmpty()) {
            return;
        }
        Map<Object, FigureState> map = figureState;
        synchronized (map) {
            Set<Map.Entry<Object, FigureState>> entrySet = figureState.entrySet();
            for (Map.Entry<Object, FigureState> entry : entrySet) {
                Object key = entry.getKey();
                FigureState value = entry.getValue();
                if (key instanceof IFigure) {
                    IFigure fig = (IFigure)key;
                    HighlightUtil.updateFigure(fig, value.bgColor, value.fgColor, value.lineWidth);
                    continue;
                }
                if (!(key instanceof EditPart)) continue;
                List<IFigure> figures = HighlightUtil.getHighlightFigures((EditPart)key);
                for (IFigure fig : figures) {
                    HighlightUtil.updateFigure(fig, value.bgColor, value.fgColor, value.lineWidth);
                }
            }
            figureState.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unhighlight(EditPart host) {
        List<IFigure> highlightFigures = HighlightUtil.getHighlightFigures(host);
        if (highlightFigures.isEmpty()) {
            return;
        }
        Map<Object, FigureState> map = figureState;
        synchronized (map) {
            for (IFigure figure : highlightFigures) {
                FigureState s = figureState.remove(figure);
                if (s == null) continue;
                HighlightUtil.updateFigure(figure, s.bgColor, s.fgColor, s.lineWidth);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateFigure(IFigure fig, Color bgColor, Color fgColor, int lineWidth) {
        if (fig == null) {
            return;
        }
        IFigure iFigure = fig;
        synchronized (iFigure) {
            if (lineWidth > 0) {
                Border border = fig.getBorder();
                if (border != null && border instanceof LineBorder) {
                    ((LineBorder)border).setWidth(lineWidth);
                }
                if (fig instanceof Shape) {
                    ((Shape)fig).setLineWidth(lineWidth);
                }
                if (fig instanceof NodeFigure) {
                    ((NodeFigure)fig).setLineWidth(lineWidth);
                }
                if (fig instanceof DestructionEventFigure) {
                    ((DestructionEventFigure)fig).setLineWidth(lineWidth);
                }
            }
            fig.repaint();
        }
    }

    private static class FigureState {
        private Color bgColor;
        private Color fgColor;
        private int lineWidth;

        public FigureState(Color bgColor, Color fgColor, int lineWidth) {
            this.bgColor = bgColor;
            this.fgColor = fgColor;
            this.lineWidth = lineWidth;
        }
    }
}

