/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.tools.util;

import com.google.common.collect.AbstractIterator;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLTreeIterator
extends AbstractTreeIterator<Element> {
    private static final long serialVersionUID = 1L;

    public XMLTreeIterator(Document document) {
        super((Object)document, false);
    }

    public XMLTreeIterator(Element root) {
        super((Object)root, true);
    }

    protected Iterator<? extends Element> getChildren(Object object) {
        if (object instanceof Document) {
            return new Noderator(((Document)object).getChildNodes());
        }
        if (object instanceof Element) {
            return new Noderator(((Element)object).getChildNodes());
        }
        return Collections.emptyIterator();
    }

    private static final class Noderator
    extends AbstractIterator<Element> {
        private final NodeList nodes;
        private int index;

        Noderator(NodeList nodes) {
            this.nodes = nodes;
        }

        protected Element computeNext() {
            while (this.index < this.nodes.getLength()) {
                Node node = this.nodes.item(this.index);
                ++this.index;
                if (!(node instanceof Element)) continue;
                return (Element)node;
            }
            return (Element)this.endOfData();
        }
    }
}

