/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.glazedlists.copy;

import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.gui.TableFormat;
import java.util.Comparator;

public class TableColumnComparator<E>
implements Comparator<E> {
    private TableFormat<? super E> tableFormat;
    private int column;
    private Comparator comparator = null;

    public TableColumnComparator(TableFormat<? super E> tableFormat, int column) {
        this(tableFormat, column, GlazedLists.comparableComparator());
    }

    public TableColumnComparator(TableFormat<? super E> tableFormat, int column, Comparator comparator) {
        this.column = column;
        this.tableFormat = tableFormat;
        this.comparator = comparator;
    }

    @Override
    public int compare(E alpha, E beta) {
        Object alphaField = this.tableFormat.getColumnValue(alpha, this.column);
        Object betaField = this.tableFormat.getColumnValue(beta, this.column);
        try {
            return this.comparator.compare(alphaField, betaField);
        }
        catch (ClassCastException e) {
            IllegalStateException illegalStateException = this.comparator == GlazedLists.comparableComparator() ? new IllegalStateException("TableComparatorChooser can not sort objects \"" + String.valueOf(alphaField) + "\", \"" + String.valueOf(betaField) + "\" that do not implement Comparable.") : new IllegalStateException("TableComparatorChooser can not sort objects \"" + String.valueOf(alphaField) + "\", \"" + String.valueOf(betaField) + "\" using the provided Comparator.");
            illegalStateException.initCause(e);
            throw illegalStateException;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableColumnComparator that = (TableColumnComparator)o;
        if (this.column != that.column) {
            return false;
        }
        if (!this.comparator.equals(that.comparator)) {
            return false;
        }
        return this.tableFormat.equals(that.tableFormat);
    }

    public int hashCode() {
        int result = this.tableFormat.hashCode();
        result = 29 * result + this.column;
        result = 29 * result + this.comparator.hashCode();
        return result;
    }
}

