/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml16.portsandflows;

import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.sysml16.internal.util.IconUtil;
import org.eclipse.papyrus.sysml16.portsandflows.FlowDirectionKind;
import org.eclipse.papyrus.sysml16.portsandflows.FlowProperty;
import org.eclipse.papyrus.sysml16.portsandflows.internal.impl.FlowPropertyImpl;
import org.eclipse.uml2.uml.Image;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

public class FlowPropertyCustomImpl
extends FlowPropertyImpl
implements FlowProperty {
    private static Map<String, Image> icons;

    public static Map<String, Image> getIcons(FlowProperty flowProperty) {
        if (icons == null) {
            Stereotype stereotype = UMLUtil.getStereotype((EObject)flowProperty);
            icons = IconUtil.getImages(stereotype);
        }
        return icons;
    }

    @Override
    public Image getIcon() {
        Image image = null;
        if (this.getBase_Property() != null) {
            Map<String, Image> iconList = FlowPropertyCustomImpl.getIcons(this);
            switch (this.getDirection()) {
                case IN: {
                    image = iconList.get(this.getImageKey(FlowDirectionKind.IN));
                    break;
                }
                case OUT: {
                    image = iconList.get(this.getImageKey(FlowDirectionKind.OUT));
                    break;
                }
                case INOUT: {
                    image = iconList.get(this.getImageKey(FlowDirectionKind.INOUT));
                    break;
                }
                default: {
                    image = iconList.get(this.getImageKey(FlowDirectionKind.INOUT));
                }
            }
        }
        return image;
    }

    private String getImageKey(FlowDirectionKind flowDirection) {
        return FlowProperty.class.getSimpleName() + "_" + flowDirection.getName().toUpperCase();
    }
}

