/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.efacet.ui.internal.wizards;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.papyrus.emf.facet.efacet.ui.internal.Messages;
import org.eclipse.papyrus.emf.facet.efacet.ui.internal.composites.SelectETypeComposite;
import org.eclipse.papyrus.emf.facet.efacet.ui.internal.exported.wizard.ISelectETypeWizard;
import org.eclipse.papyrus.emf.facet.efacet.ui.internal.wizards.pages.SelectEClassifierWizardPage;
import org.eclipse.papyrus.emf.facet.efacet.ui.internal.wizards.pages.SelectEPackageWizardPage;
import org.eclipse.ui.PlatformUI;

public class SelectETypeWizardImpl
extends Wizard
implements ISelectETypeWizard {
    private final WizardDialog dialog;
    private final SelectEPackageWizardPage selectEPackagePage;
    private final SelectEClassifierWizardPage selectETypePage;
    private final EditingDomain editingDomain;
    private EClassifier selectedEType;
    private boolean canChangeEPackage = true;

    public SelectETypeWizardImpl(EditingDomain editingDomain, SelectETypeComposite.ETypeSelectionOptions eTypeSelectionOption, boolean canChangeEPackage, EPackage ePackage) {
        this.editingDomain = editingDomain;
        this.canChangeEPackage = canChangeEPackage;
        this.dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)this);
        this.selectEPackagePage = new SelectEPackageWizardPage(this.editingDomain);
        this.selectETypePage = new SelectEClassifierWizardPage(eTypeSelectionOption, ePackage);
        if (eTypeSelectionOption == SelectETypeComposite.ETypeSelectionOptions.ECLASS) {
            this.setWindowTitle(Messages.Select_EClass);
        } else if (eTypeSelectionOption == SelectETypeComposite.ETypeSelectionOptions.EDATATYPE) {
            this.setWindowTitle(Messages.Select_EDataType);
        } else {
            this.setWindowTitle(Messages.Select_EClassifier);
        }
    }

    public void addPages() {
        if (this.canChangeEPackage) {
            this.addPage((IWizardPage)this.selectEPackagePage);
        }
        this.addPage((IWizardPage)this.selectETypePage);
    }

    @Override
    public int open() {
        if (this.dialog != null) {
            return this.dialog.open();
        }
        return 1;
    }

    public boolean performFinish() {
        this.selectedEType = this.selectETypePage.getSelectedEclassifier();
        return true;
    }

    @Override
    public EClassifier getSelectedEType() {
        return this.selectedEType;
    }
}

