/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.figures;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.FlowContext;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.ParagraphTextLayout;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.internal.mapmode.IMapModeHolder;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.draw2d.ui.text.TextFlowEx;
import org.eclipse.gmf.runtime.draw2d.ui.text.TextUtilitiesEx;
import org.eclipse.gmf.runtime.draw2d.ui.text.TruncatedSingleLineTextLayout;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class WrappingLabel
extends Figure
implements PositionConstants {
    static final String ELLIPSIS = "...";
    private static final Dimension EMPTY_DIMENSION = new Dimension(0, 0);
    private static final Map<IMapMode, MapModeConstants> mapModeConstantsMap = new WeakHashMap<IMapMode, MapModeConstants>();
    private static int FLAG_SELECTED = Figure.MAX_FLAG << 1;
    private static int FLAG_HASFOCUS = Figure.MAX_FLAG << 2;
    private static int FLAG_TEXT_ALIGN = Figure.MAX_FLAG << 3;
    private static int FLAG_ICON_ALIGN = Figure.MAX_FLAG << 7;
    private static int FLAG_LABEL_ALIGN = Figure.MAX_FLAG << 11;
    private static int FLAG_TEXT_PLACEMENT;
    protected static final int MAX_FLAG;
    private MapModeConstants mapModeConstants;
    private FlowPage flowPage;
    protected Dimension preferredTextSize;
    private Dimension truncationStringSize;
    private IconInfo iconInfo;
    private int cachedPrefSizeHint_width;
    private int cachedPrefSizeHint_height;
    private Point iconLocation;

    static {
        MAX_FLAG = FLAG_TEXT_PLACEMENT = Figure.MAX_FLAG << 15;
    }

    public WrappingLabel() {
        this.createTextFigures();
        this.setText("");
        this.setAlignmentFlags(2, FLAG_TEXT_ALIGN);
        this.setAlignmentFlags(2, FLAG_ICON_ALIGN);
        this.setAlignmentFlags(9, FLAG_LABEL_ALIGN);
        this.setPlacementFlags(16, FLAG_TEXT_PLACEMENT);
        this.setTextJustification(1);
        this.revalidate();
    }

    public WrappingLabel(String text) {
        this();
        if (text != null) {
            this.setText(text);
        } else {
            this.setText("");
        }
    }

    public WrappingLabel(Image image) {
        this();
        this.iconInfo = new SingleIconInfo(image);
    }

    public WrappingLabel(String text, Image image) {
        this(text);
        this.iconInfo = new SingleIconInfo(image);
    }

    private void createTextFigures() {
        TextFlowEx textFlow = new TextFlowEx();
        this.flowPage = new FlowPage();
        this.flowPage.add((IFigure)textFlow);
        this.setLayoutManager(textFlow, false);
        this.add((IFigure)this.flowPage);
    }

    public IFigure getTextFigure() {
        return this.flowPage;
    }

    private FlowPage getFlowPage() {
        return (FlowPage)this.getTextFigure();
    }

    TextFlow getTextFlow() {
        return (TextFlow)this.flowPage.getChildren().get(0);
    }

    IMapMode getFigureMapMode() {
        return (IMapMode)this.getMapModeConstants().mapModeRef.get();
    }

    MapModeConstants getMapModeConstants() {
        if (this.mapModeConstants == null) {
            IMapMode mapMode = MapModeUtil.getMapMode((IFigure)this);
            while (mapMode instanceof IMapModeHolder) {
                mapMode = ((IMapModeHolder)mapMode).getMapMode();
            }
            this.mapModeConstants = mapModeConstantsMap.get(mapMode);
            if (this.mapModeConstants == null) {
                this.mapModeConstants = new MapModeConstants(mapMode);
                mapModeConstantsMap.put(mapMode, this.mapModeConstants);
            }
        }
        return this.mapModeConstants;
    }

    private void alignOnHeight(Rectangle area, Rectangle childBounds, int alignment) {
        switch (alignment) {
            case 8: {
                childBounds.y = area.y;
                childBounds.y = area.y;
                break;
            }
            case 32: {
                childBounds.y = area.getBottom().y - childBounds.height;
                break;
            }
            default: {
                childBounds.y = area.y + (area.height - childBounds.height) / 2;
            }
        }
    }

    private void alignOnWidth(Rectangle area, Rectangle childBounds, int alignment) {
        switch (alignment) {
            case 1: {
                childBounds.x = area.x;
                break;
            }
            case 4: {
                childBounds.x = area.getRight().x - childBounds.width;
                break;
            }
            default: {
                childBounds.x = area.x + (area.width - childBounds.width) / 2;
            }
        }
    }

    private void calculateAlignment(Rectangle textBounds, Rectangle iconBounds) {
        Rectangle areaUsed = textBounds.getUnion(iconBounds);
        areaUsed.x = this.getInsets().left;
        areaUsed.y = this.getInsets().top;
        switch (this.getTextPlacement()) {
            case 8: 
            case 16: {
                this.alignOnHeight(areaUsed, textBounds, this.getTextAlignment());
                this.alignOnHeight(areaUsed, iconBounds, this.getIconAlignment());
                break;
            }
            case 1: 
            case 4: {
                this.alignOnWidth(areaUsed, textBounds, this.getTextAlignment());
                this.alignOnWidth(areaUsed, iconBounds, this.getIconAlignment());
            }
        }
    }

    protected Dimension calculateLabelSize(Dimension txtSize) {
        Dimension iconSize = this.getTotalIconSize();
        boolean isEmpty = iconSize.width == 0 && iconSize.height == 0;
        int len = this.getText().length();
        if (len == 0 && isEmpty) {
            return new Dimension(txtSize.width, txtSize.height);
        }
        int gap = len == 0 || isEmpty ? 0 : this.getIconTextGap();
        int placement = this.getTextPlacement();
        if (placement == 8 || placement == 16) {
            return new Dimension(iconSize.width + gap + txtSize.width, Math.max(iconSize.height, txtSize.height));
        }
        return new Dimension(Math.max(iconSize.width, txtSize.width), iconSize.height + gap + txtSize.height);
    }

    public void layout() {
        Rectangle textBounds = new Rectangle();
        Rectangle iconBounds = new Rectangle();
        this.calculateSizes(textBounds, iconBounds);
        this.calculatePlacement(textBounds, iconBounds);
        this.calculateAlignment(textBounds, iconBounds);
        this.calculateLabelAlignment(textBounds, iconBounds);
        if (this.hasIcons()) {
            this.setIconLocation(iconBounds.getLocation());
        }
        this.getTextFigure().setBounds(textBounds.getTranslated(this.getBounds().getLocation()));
    }

    private void calculateSizes(Rectangle textBounds, Rectangle iconBounds) {
        Rectangle area = this.getClientArea();
        Dimension preferredSize = this.getPreferredSize(area.width, area.height);
        Dimension minimumSize = this.getMinimumSize(area.width, area.height);
        Dimension shrinkAmount = preferredSize.getShrinked(this.getBounds().getSize().getUnioned(minimumSize));
        Dimension textSize = this.preferredTextSize.getCopy();
        if (shrinkAmount.width > 0) {
            textSize.shrink(shrinkAmount.width, 0);
        }
        if (shrinkAmount.height > 0) {
            textSize.shrink(0, shrinkAmount.height);
        }
        if (this.getTextFlow().isTextTruncated()) {
            textBounds.setSize(textSize);
        } else {
            textBounds.setSize(this.getTextFlow().getSize().intersect(textSize));
        }
        iconBounds.setSize(this.getTotalIconSize());
    }

    private void calculateLabelAlignment(Rectangle textBounds, Rectangle iconBounds) {
        Dimension offset = this.getClientArea().getSize().getShrinked(textBounds.getUnion(iconBounds).getSize());
        switch (this.getAlignment()) {
            case 9: {
                offset.height = 0;
                offset.width = 0;
                break;
            }
            case 8: {
                offset.height = 0;
                offset.scale(0.5);
                break;
            }
            case 12: {
                offset.height = 0;
            }
            case 4: {
                offset.width *= 2;
                offset.scale(0.5);
                break;
            }
            case 36: {
                break;
            }
            case 32: {
                offset.height *= 2;
                offset.scale(0.5);
                break;
            }
            case 33: {
                offset.width = 0;
                break;
            }
            case 1: {
                offset.width = 0;
                offset.scale(0.5);
                break;
            }
            case 2: {
                offset.scale(0.5);
                break;
            }
            default: {
                offset.scale(0.5);
            }
        }
        textBounds.translate(offset.width, offset.height);
        iconBounds.translate(offset.width, offset.height);
    }

    private void calculatePlacement(Rectangle textBounds, Rectangle iconBounds) {
        int gap = textBounds.isEmpty() || iconBounds.isEmpty() ? 0 : this.getIconTextGap();
        Insets insets = this.getInsets();
        switch (this.getTextPlacement()) {
            case 16: {
                iconBounds.x = insets.left;
                textBounds.x = iconBounds.width + gap + insets.left;
                break;
            }
            case 8: {
                textBounds.x = insets.left;
                iconBounds.x = textBounds.width + gap + insets.left;
                break;
            }
            case 1: {
                textBounds.y = insets.top;
                iconBounds.y = textBounds.height + gap + insets.top;
                break;
            }
            case 4: {
                textBounds.y = iconBounds.height + gap + insets.top;
                iconBounds.y = insets.top;
            }
        }
    }

    public Image getIcon() {
        return this.getIcon(0);
    }

    public Image getIcon(int index) {
        if (this.iconInfo == null) {
            return null;
        }
        return this.iconInfo.getIcon(index);
    }

    protected boolean hasIcons() {
        return this.getNumberofIcons() > 0;
    }

    public int getIconAlignment() {
        return this.getAlignment(FLAG_ICON_ALIGN);
    }

    protected Point getIconLocation() {
        return this.iconLocation;
    }

    protected void setIconLocation(Point location) {
        this.iconLocation = location;
    }

    public int getIconTextGap() {
        return this.getMapModeConstants().nDPtoLP_3;
    }

    public Dimension getMinimumSize(int w, int h) {
        if (this.minSize != null) {
            return this.minSize;
        }
        this.minSize = new Dimension();
        Font currentFont = this.getFont();
        Dimension ellipsisSize = this.getTruncationStringSize();
        Dimension textSize = new TextUtilitiesEx(this.getFigureMapMode()).getTextExtents(this.getText(), currentFont);
        if (textSize.width == 0) {
            textSize.height = 0;
        }
        textSize.intersect(ellipsisSize);
        Dimension labelSize = this.calculateLabelSize(textSize);
        Insets insets = this.getInsets();
        labelSize.expand(insets.getWidth(), insets.getHeight());
        this.minSize.union(labelSize);
        return this.minSize;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        if (this.prefSize == null || wHint != this.cachedPrefSizeHint_width || hHint != this.cachedPrefSizeHint_height) {
            this.cachedPrefSizeHint_width = wHint;
            this.cachedPrefSizeHint_height = hHint;
            int minWHint = 0;
            int minHHint = 0;
            if (wHint < 0) {
                minWHint = -1;
            }
            if (hHint < 0) {
                minHHint = -1;
            }
            if (this.hasIcons()) {
                this.prefSize = this.getTotalIconSize().getCopy();
                switch (this.getTextPlacement()) {
                    case 8: 
                    case 16: {
                        wHint = Math.max(minWHint, wHint - (this.prefSize.width + this.getIconTextGap()));
                        this.preferredTextSize = this.getTextFigure().getPreferredSize(wHint, hHint).getCopy();
                        this.prefSize.width += this.preferredTextSize.width + this.getIconTextGap();
                        this.prefSize.height = Math.max(this.prefSize.height, this.preferredTextSize.height);
                        break;
                    }
                    case 1: 
                    case 4: {
                        hHint = Math.max(minHHint, hHint - (this.prefSize.height + this.getIconTextGap()));
                        this.preferredTextSize = this.getTextFigure().getPreferredSize(wHint, hHint).getCopy();
                        this.prefSize.width = Math.max(this.prefSize.width, this.preferredTextSize.width);
                        this.prefSize.height += this.preferredTextSize.height + this.getIconTextGap();
                    }
                }
            } else {
                this.preferredTextSize = this.getTextFigure().getPreferredSize(wHint, hHint).getCopy();
                if (this.preferredTextSize.width == 0) {
                    this.preferredTextSize.height = 0;
                }
                this.prefSize = this.preferredTextSize.getCopy();
            }
            Insets insets = this.getInsets();
            this.prefSize.expand(insets.getWidth(), insets.getHeight());
        }
        return this.prefSize;
    }

    Dimension getTruncationStringSize() {
        if (this.truncationStringSize == null) {
            if (this.getTruncationString().equals(ELLIPSIS)) {
                this.truncationStringSize = this.getMapModeConstants().getEllipseTextSize(this.getFont());
            } else {
                Font f = this.getFont();
                IMapMode mapMode = this.getFigureMapMode();
                this.truncationStringSize = FigureUtilities.getTextExtents((String)this.getTruncationString(), (Font)f);
                this.truncationStringSize.height = FigureUtilities.getFontMetrics((Font)f).getHeight();
                this.truncationStringSize = new Dimension(mapMode.DPtoLP(this.truncationStringSize.width), mapMode.DPtoLP(this.truncationStringSize.height));
            }
        }
        return this.truncationStringSize;
    }

    public String getText() {
        return this.getTextFlow().getText();
    }

    public int getTextAlignment() {
        return this.getAlignment(FLAG_TEXT_ALIGN);
    }

    public int getAlignment() {
        return this.getAlignment(FLAG_LABEL_ALIGN);
    }

    public Rectangle getTextBounds() {
        return new Rectangle(this.getFlowPage().getBounds().getLocation(), this.getTextFlow().getBounds().getSize());
    }

    public int getTextPlacement() {
        return this.getPlacement(FLAG_TEXT_PLACEMENT);
    }

    public void invalidate() {
        this.prefSize = null;
        this.minSize = null;
        this.iconLocation = null;
        this.truncationStringSize = null;
        if (this.iconInfo != null) {
            this.iconInfo.invalidate();
        }
        super.invalidate();
    }

    public void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        if (this.hasIcons()) {
            this.paintIcons(graphics);
        }
    }

    protected void paintClientArea(Graphics graphics) {
        this.paintSelectionRectangle(graphics);
        this.paintFocusRectangle(graphics);
        super.paintClientArea(graphics);
    }

    private void paintSelectionRectangle(Graphics g) {
        if (this.isSelected()) {
            g.pushState();
            g.setBackgroundColor(ColorConstants.menuBackgroundSelected);
            g.fillRectangle(this.getVisibleTextBounds());
            g.popState();
            g.setForegroundColor(ColorConstants.menuForegroundSelected);
        }
    }

    private void paintFocusRectangle(Graphics g) {
        if (this.hasFocus()) {
            g.pushState();
            g.setXORMode(true);
            g.setForegroundColor(ColorConstants.menuBackgroundSelected);
            g.setBackgroundColor(ColorConstants.menuForegroundSelected);
            g.drawFocus(this.getVisibleTextBounds());
            g.popState();
        }
    }

    private Rectangle getVisibleTextBounds() {
        return this.getTextBounds().getIntersection(this.getClientArea());
    }

    private void paintIcons(Graphics graphics) {
        Point p = Point.SINGLETON;
        if (this.getIconLocation() != null) {
            p.setLocation(this.getIconLocation());
            Rectangle figBounds = this.getBounds();
            graphics.translate(figBounds.x, figBounds.y);
            int num = this.getNumberofIcons();
            int i = 0;
            while (i < num) {
                Image icon = this.getIcon(i);
                if (icon != null) {
                    graphics.drawImage(icon, p);
                    p.x += this.getIconSize((int)i).width;
                }
                ++i;
            }
            graphics.translate(-figBounds.x, -figBounds.y);
        }
    }

    public void setIcon(Image image) {
        this.setIcon(image, 0);
    }

    public void setIcon(Image image, int index) {
        if (this.iconInfo == null) {
            if (index == 0) {
                this.iconInfo = this.getMapModeConstants().getSingleIconInfo(image);
            } else {
                this.iconInfo = new MultiIconInfo();
                this.iconInfo.setIcon(image, index);
            }
            this.revalidate();
            this.repaint();
        } else if (this.iconInfo.getIcon(index) != image) {
            if (this.iconInfo.getMaxIcons() == 1) {
                if (index == 0) {
                    this.iconInfo = this.getMapModeConstants().getSingleIconInfo(image);
                    this.revalidate();
                    this.repaint();
                    return;
                }
                IconInfo oldIconInfo = this.iconInfo;
                this.iconInfo = new MultiIconInfo();
                this.iconInfo.setIcon(oldIconInfo.getIcon(0), 0);
            }
            this.iconInfo.setIcon(image, index);
            this.revalidate();
            this.repaint();
        }
    }

    public void setIconAlignment(int alignment) {
        if (this.getIconAlignment() == alignment) {
            return;
        }
        this.setAlignmentFlags(alignment, FLAG_ICON_ALIGN);
        this.revalidate();
        this.repaint();
    }

    protected Dimension getIconSize(int index) {
        if (this.iconInfo == null) {
            return EMPTY_DIMENSION;
        }
        return this.iconInfo.getIconSize(this.getFigureMapMode(), index);
    }

    protected int getNumberofIcons() {
        if (this.iconInfo == null) {
            return 0;
        }
        return this.iconInfo.getNumberofIcons();
    }

    protected Dimension getTotalIconSize() {
        if (this.iconInfo == null) {
            return EMPTY_DIMENSION;
        }
        return this.iconInfo.getTotalIconSize(this.getFigureMapMode());
    }

    public void setAlignment(int alignment) {
        if (this.getAlignment() == alignment) {
            return;
        }
        this.setAlignmentFlags(alignment, FLAG_LABEL_ALIGN);
        this.revalidate();
        this.repaint();
    }

    protected String getTruncationString() {
        return ELLIPSIS;
    }

    public void setText(String text) {
        this.getTextFlow().setText(text);
    }

    public void setTextAlignment(int alignment) {
        if (this.getTextAlignment() == alignment) {
            return;
        }
        this.setAlignmentFlags(alignment, FLAG_TEXT_ALIGN);
        this.revalidate();
        this.repaint();
    }

    public void setTextPlacement(int where) {
        if (this.getTextPlacement() == where) {
            return;
        }
        this.setPlacementFlags(where, FLAG_TEXT_PLACEMENT);
        this.revalidate();
        this.repaint();
    }

    public void setTextUnderline(boolean underline) {
        ((TextFlowEx)this.getTextFlow()).setTextUnderline(underline);
    }

    public boolean isTextUnderlined() {
        return ((TextFlowEx)this.getTextFlow()).isTextUnderlined();
    }

    public void setTextStrikeThrough(boolean strikeThrough) {
        ((TextFlowEx)this.getTextFlow()).setTextStrikeThrough(strikeThrough);
    }

    public boolean isTextStrikedThrough() {
        return ((TextFlowEx)this.getTextFlow()).isTextStrikedThrough();
    }

    public void setTextWrap(boolean textWrapOn) {
        if (textWrapOn != this.isTextWrapOn()) {
            this.setLayoutManager(this.getTextFlow(), textWrapOn);
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isTextWrapOn() {
        return this.getTextFlow().getLayoutManager() instanceof ParagraphTextLayout;
    }

    public void setTextJustification(int justification) {
        this.getFlowPage().setHorizontalAligment(justification);
    }

    public int getTextJustification() {
        return this.getFlowPage().getHorizontalAligment();
    }

    private void setPlacementFlags(int align, int flagOffset) {
        this.flags &= ~(7 * flagOffset);
        switch (align) {
            case 16: {
                this.flags |= 1 * flagOffset;
                break;
            }
            case 8: {
                this.flags |= 2 * flagOffset;
                break;
            }
            case 1: {
                this.flags |= 3 * flagOffset;
                break;
            }
            case 4: {
                this.flags |= 4 * flagOffset;
            }
        }
    }

    private int getPlacement(int flagOffset) {
        int wrapValue = this.flags & 7 * flagOffset;
        if (wrapValue == 1 * flagOffset) {
            return 16;
        }
        if (wrapValue == 2 * flagOffset) {
            return 8;
        }
        if (wrapValue == 3 * flagOffset) {
            return 1;
        }
        if (wrapValue == 4 * flagOffset) {
            return 4;
        }
        return 16;
    }

    private void setAlignmentFlags(int alignment, int flagOffset) {
        this.flags &= ~(15 * flagOffset);
        switch (alignment) {
            case 2: {
                this.flags |= 1 * flagOffset;
                break;
            }
            case 8: {
                this.flags |= 2 * flagOffset;
                break;
            }
            case 1: {
                this.flags |= 3 * flagOffset;
                break;
            }
            case 4: {
                this.flags |= 4 * flagOffset;
                break;
            }
            case 32: {
                this.flags |= 5 * flagOffset;
                break;
            }
            case 9: {
                this.flags |= 6 * flagOffset;
                break;
            }
            case 12: {
                this.flags |= 7 * flagOffset;
                break;
            }
            case 33: {
                this.flags |= 8 * flagOffset;
                break;
            }
            case 36: {
                this.flags |= 9 * flagOffset;
            }
        }
    }

    private int getAlignment(int flagOffset) {
        int wrapValue = this.flags & 15 * flagOffset;
        if (wrapValue == 1 * flagOffset) {
            return 2;
        }
        if (wrapValue == 2 * flagOffset) {
            return 8;
        }
        if (wrapValue == 3 * flagOffset) {
            return 1;
        }
        if (wrapValue == 4 * flagOffset) {
            return 4;
        }
        if (wrapValue == 5 * flagOffset) {
            return 32;
        }
        if (wrapValue == 6 * flagOffset) {
            return 9;
        }
        if (wrapValue == 7 * flagOffset) {
            return 12;
        }
        if (wrapValue == 8 * flagOffset) {
            return 33;
        }
        if (wrapValue == 9 * flagOffset) {
            return 36;
        }
        return 2;
    }

    public boolean hasFocus() {
        return (this.flags & FLAG_HASFOCUS) != 0;
    }

    public void setFocus(boolean focus) {
        if (this.hasFocus() == focus) {
            return;
        }
        this.setFlag(FLAG_HASFOCUS, focus);
        this.repaint();
    }

    public boolean isSelected() {
        return (this.flags & FLAG_SELECTED) != 0;
    }

    public void setSelected(boolean selected) {
        if (this.isSelected() == selected) {
            return;
        }
        this.setFlag(FLAG_SELECTED, selected);
        this.repaint();
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.getTextFlow().setFont(f);
    }

    protected void setLayoutManager(TextFlow textFlow, boolean wrappingOn) {
        Object layout = wrappingOn ? new ParagraphTextLayout(textFlow, 1) : new TruncatedSingleLineTextLayout((TextFlowEx)textFlow, this.getTruncationString());
        layout.setFlowContext((FlowContext)((FlowPage)textFlow.getParent()).getLayoutManager());
        textFlow.setLayoutManager((LayoutManager)layout);
    }

    public String toString() {
        return this.getText();
    }

    public boolean isTextTruncated() {
        return this.getTextFlow().isTextTruncated();
    }

    private static abstract class IconInfo {
        private IconInfo() {
        }

        public abstract Image getIcon(int var1);

        public abstract Dimension getIconSize(IMapMode var1, int var2);

        public abstract int getNumberofIcons();

        public abstract Dimension getTotalIconSize(IMapMode var1);

        public abstract void invalidate();

        public abstract void setIcon(Image var1, int var2);

        public abstract int getMaxIcons();
    }

    static class MapModeConstants {
        private static final int MAX_IMAGE_INFO = 12;
        public final WeakReference<IMapMode> mapModeRef;
        public final int nDPtoLP_3;
        public final int nDPtoLP_2;
        public final int nDPtoLP_0;
        public final Dimension dimension_nDPtoLP_0;
        public final WeakHashMap<Font, Dimension> fontToEllipseTextSize = new WeakHashMap();
        public final SingleIconInfo[] singleIconInfos = new SingleIconInfo[12];

        public MapModeConstants(IMapMode mapMode) {
            this.mapModeRef = new WeakReference<IMapMode>(mapMode);
            this.nDPtoLP_2 = mapMode.DPtoLP(2);
            this.nDPtoLP_3 = mapMode.DPtoLP(3);
            this.nDPtoLP_0 = mapMode.DPtoLP(0);
            this.dimension_nDPtoLP_0 = new Dimension(this.nDPtoLP_0, this.nDPtoLP_0);
        }

        public Dimension getEllipseTextSize(Font f) {
            Dimension d = this.fontToEllipseTextSize.get(f);
            if (d == null) {
                IMapMode mapMode = (IMapMode)this.mapModeRef.get();
                d = FigureUtilities.getTextExtents((String)WrappingLabel.ELLIPSIS, (Font)f);
                d.height = FigureUtilities.getFontMetrics((Font)f).getHeight();
                d = new Dimension(mapMode.DPtoLP(d.width), mapMode.DPtoLP(d.height));
                this.fontToEllipseTextSize.put(f, d);
            }
            return d;
        }

        public SingleIconInfo getSingleIconInfo(Image image) {
            SingleIconInfo info;
            if (image == null) {
                return SingleIconInfo.NULL_INFO;
            }
            int i = 0;
            while (i < 12) {
                info = this.singleIconInfos[i];
                if (info == null) {
                    this.singleIconInfos[i] = info = new SingleIconInfo(image);
                    return info;
                }
                if (info.icon == image) {
                    return info;
                }
                ++i;
            }
            int index = SingleIconInfo.count % 12;
            this.singleIconInfos[index] = info = new SingleIconInfo(image);
            return info;
        }
    }

    private static class MultiIconInfo
    extends IconInfo {
        private ArrayList<Image> icons = new ArrayList(2);
        private Dimension totalIconSize;

        @Override
        public int getMaxIcons() {
            return -1;
        }

        @Override
        public Image getIcon(int i) {
            if (i >= this.icons.size()) {
                return null;
            }
            return this.icons.get(i);
        }

        @Override
        public void setIcon(Image icon, int i) {
            int size = this.icons.size();
            if (i >= size) {
                int j = size;
                while (j < i) {
                    this.icons.add(null);
                    ++j;
                }
                this.icons.add(icon);
                this.icons.trimToSize();
            } else {
                this.icons.set(i, icon);
            }
        }

        @Override
        public Dimension getIconSize(IMapMode mapMode, int i) {
            Image img = this.getIcon(i);
            if (img != null && !img.isDisposed()) {
                org.eclipse.swt.graphics.Rectangle imgBounds = img.getBounds();
                return new Dimension(mapMode.DPtoLP(imgBounds.width), mapMode.DPtoLP(imgBounds.height));
            }
            return EMPTY_DIMENSION;
        }

        @Override
        public int getNumberofIcons() {
            return this.icons.size();
        }

        @Override
        public Dimension getTotalIconSize(IMapMode mapMode) {
            if (this.totalIconSize != null) {
                return this.totalIconSize;
            }
            int iconNum = this.getNumberofIcons();
            if (iconNum == 0) {
                this.totalIconSize = EMPTY_DIMENSION;
                return this.totalIconSize;
            }
            this.totalIconSize = new Dimension();
            int i = 0;
            while (i < iconNum) {
                Dimension iconSize = this.getIconSize(mapMode, i);
                this.totalIconSize.width += iconSize.width;
                if (iconSize.height > this.totalIconSize.height) {
                    this.totalIconSize.height = iconSize.height;
                }
                ++i;
            }
            return this.totalIconSize;
        }

        @Override
        public void invalidate() {
            this.totalIconSize = null;
        }
    }

    private static class SingleIconInfo
    extends IconInfo {
        static int count;
        public static final SingleIconInfo NULL_INFO;
        final Image icon;
        private Dimension totalIconSize;

        static {
            NULL_INFO = new SingleIconInfo(){

                @Override
                public int getNumberofIcons() {
                    return 0;
                }
            };
        }

        private SingleIconInfo() {
            this.icon = null;
        }

        public SingleIconInfo(Image icon) {
            this.icon = icon;
            ++count;
        }

        @Override
        public final int getMaxIcons() {
            return 1;
        }

        @Override
        public Image getIcon(int i) {
            if (i == 0) {
                return this.icon;
            }
            if (i > 0) {
                return null;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public void setIcon(Image img, int i) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Dimension getIconSize(IMapMode mapMode, int i) {
            if (i == 0) {
                return this.getTotalIconSize(mapMode);
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int getNumberofIcons() {
            return 1;
        }

        @Override
        public Dimension getTotalIconSize(IMapMode mapMode) {
            if (this.totalIconSize != null) {
                return this.totalIconSize;
            }
            if (this.icon != null && !this.icon.isDisposed()) {
                org.eclipse.swt.graphics.Rectangle imgBounds = this.icon.getBounds();
                this.totalIconSize = new Dimension(mapMode.DPtoLP(imgBounds.width), mapMode.DPtoLP(imgBounds.height));
            } else {
                this.totalIconSize = EMPTY_DIMENSION;
            }
            return this.totalIconSize;
        }

        @Override
        public void invalidate() {
            this.totalIconSize = null;
        }
    }
}

