/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.model.tests;

import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.validation.internal.service.ClientContext;
import org.eclipse.emf.validation.internal.service.impl.tests.ConstraintDescriptorTest;
import org.eclipse.emf.validation.model.IClientSelector;

public class ClientContextTest
extends TestCase {
    public void test_initWithoutid() {
        try {
            new ClientContext((IConfigurationElement)new ConstraintDescriptorTest.FixtureElement("clientContext"));
            ClientContextTest.fail((String)"Should have thrown exception.");
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void test_initWithoutSelector() {
        try {
            new ClientContext((IConfigurationElement)ConstraintDescriptorTest.FixtureElement.build("clientContext", new String[][]{{"id", "junit.testContext"}}));
            ClientContextTest.fail((String)"Should have thrown exception.");
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void test_initWithInvalidEnablement() {
        try {
            ConstraintDescriptorTest.FixtureElement element = ConstraintDescriptorTest.FixtureElement.build("clientContext", new String[][]{{"id", "junit.testContext"}});
            element.addChild(new ConstraintDescriptorTest.FixtureElement("enablement").addChild(new ConstraintDescriptorTest.FixtureElement("foo")));
            new ClientContext((IConfigurationElement)element);
            ClientContextTest.fail((String)"Should have thrown exception.");
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void test_initWithMissingSelector() {
        try {
            ConstraintDescriptorTest.FixtureElement element = ConstraintDescriptorTest.FixtureElement.build("clientContext", new String[][]{{"id", "junit.testContext"}});
            element.addChild(new ConstraintDescriptorTest.FixtureElement("selector"));
            new ClientContext((IConfigurationElement)element);
            ClientContextTest.fail((String)"Should have thrown exception.");
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void test_initWithInvalidSelector() {
        try {
            ConstraintDescriptorTest.FixtureElement element = ConstraintDescriptorTest.FixtureElement.build("clientContext", new String[][]{{"id", "junit.testContext"}});
            element.addChild(ConstraintDescriptorTest.FixtureElement.build("selector", new String[][]{{"class", InvalidSelector.class.getName()}}));
            new ClientContext((IConfigurationElement)element);
            ClientContextTest.fail((String)"Should have thrown exception.");
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void test_initWithValidExpression() {
        try {
            ConstraintDescriptorTest.FixtureElement element = ConstraintDescriptorTest.FixtureElement.build("clientContext", new String[][]{{"id", "junit.testContext"}});
            element.addChild(new ConstraintDescriptorTest.FixtureElement("enablement")).addChild(ConstraintDescriptorTest.FixtureElement.build("test", new String[][]{{"property", "com.example.foo"}, {"value", "bar"}}));
            new ClientContext((IConfigurationElement)element);
        }
        catch (CoreException e) {
            ClientContextTest.fail((String)("Should not have thrown exception: " + e.getLocalizedMessage()));
        }
    }

    public void test_initWithValidSelector() {
        try {
            ConstraintDescriptorTest.FixtureElement element = ConstraintDescriptorTest.FixtureElement.build("clientContext", new String[][]{{"id", "junit.testContext"}});
            element.addChild(ConstraintDescriptorTest.FixtureElement.build("selector", new String[][]{{"class", ValidSelector.class.getName()}}));
            new ClientContext((IConfigurationElement)element);
        }
        catch (CoreException e) {
            ClientContextTest.fail((String)("Should not have thrown exception: " + e.getLocalizedMessage()));
        }
    }

    public void test_initDefault() {
        try {
            ConstraintDescriptorTest.FixtureElement element = ConstraintDescriptorTest.FixtureElement.build("clientContext", new String[][]{{"id", "junit.testContext"}});
            element.addChild(new ConstraintDescriptorTest.FixtureElement("enablement"));
            ClientContextTest.assertFalse((String)"Should not be default", (boolean)new ClientContext((IConfigurationElement)element).isDefault());
            element = ConstraintDescriptorTest.FixtureElement.build("clientContext", new String[][]{{"id", "junit.testContext"}, {"default", "true"}});
            element.addChild(new ConstraintDescriptorTest.FixtureElement("enablement"));
            ClientContextTest.assertTrue((String)"Should be default", (boolean)new ClientContext((IConfigurationElement)element).isDefault());
        }
        catch (CoreException e) {
            ClientContextTest.fail((String)("Should not have thrown exception: " + e.getLocalizedMessage()));
        }
    }

    public void test_equals() {
        try {
            ConstraintDescriptorTest.FixtureElement element = ConstraintDescriptorTest.FixtureElement.build("clientContext", new String[][]{{"id", "junit.testContext"}});
            element.addChild(new ConstraintDescriptorTest.FixtureElement("enablement"));
            ConstraintDescriptorTest.FixtureElement element2 = ConstraintDescriptorTest.FixtureElement.build("clientContext", new String[][]{{"id", "junit.testContext2"}});
            element2.addChild(new ConstraintDescriptorTest.FixtureElement("enablement"));
            ClientContext ctx1 = new ClientContext((IConfigurationElement)element);
            ClientContext ctx2 = new ClientContext((IConfigurationElement)element);
            ClientContext ctx3 = new ClientContext((IConfigurationElement)element2);
            ClientContextTest.assertEquals((Object)ctx1, (Object)ctx2);
            ClientContextTest.assertFalse((boolean)ctx1.equals((Object)ctx3));
        }
        catch (CoreException e) {
            ClientContextTest.fail((String)("Should not have thrown exception: " + e.getLocalizedMessage()));
        }
    }

    public void test_hashCode() {
        try {
            ConstraintDescriptorTest.FixtureElement element = ConstraintDescriptorTest.FixtureElement.build("clientContext", new String[][]{{"id", "junit.testContext"}});
            element.addChild(new ConstraintDescriptorTest.FixtureElement("enablement"));
            ConstraintDescriptorTest.FixtureElement element2 = ConstraintDescriptorTest.FixtureElement.build("clientContext", new String[][]{{"id", "junit.testContext2"}});
            element2.addChild(new ConstraintDescriptorTest.FixtureElement("enablement"));
            ClientContext ctx1 = new ClientContext((IConfigurationElement)element);
            ClientContext ctx2 = new ClientContext((IConfigurationElement)element);
            ClientContext ctx3 = new ClientContext((IConfigurationElement)element2);
            ClientContextTest.assertEquals((int)ctx1.hashCode(), (int)ctx2.hashCode());
            ClientContextTest.assertTrue((ctx1.hashCode() == ctx3.hashCode() || !ctx1.equals((Object)ctx3) ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            ClientContextTest.fail((String)("Should not have thrown exception: " + e.getLocalizedMessage()));
        }
    }

    public static final class InvalidSelector {
    }

    public static final class ValidSelector
    implements IClientSelector {
        public boolean selects(Object eObject) {
            return false;
        }
    }
}

