/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction.tests;

import java.lang.ref.WeakReference;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.tests.AbstractTest;
import org.eclipse.emf.transaction.tests.fixtures.TestEditingDomain;
import org.eclipse.emf.transaction.tests.fixtures.TestListener;

public class EditingDomainRegistryTest
extends AbstractTest {
    private static final String TEST_DOMAIN1 = "org.eclipse.emf.transaction.tests.TestDomain1";
    private static final String TEST_DOMAIN2 = "org.eclipse.emf.transaction.tests.TestDomain2";
    private static final String TEST_DOMAIN3 = "org.eclipse.emf.transaction.tests.TestDomain3";
    private static final String TEST_DOMAIN4 = "org.eclipse.emf.transaction.tests.TestDomain4";

    public EditingDomainRegistryTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(EditingDomainRegistryTest.class, "Editing Domain Registry Tests");
    }

    public void test_dynamicAddRemove() {
        EditingDomainRegistryTest.assertNull((Object)this.domain.getID());
        TransactionalEditingDomain.Registry.INSTANCE.add(TEST_DOMAIN2, this.domain);
        EditingDomainRegistryTest.assertEquals((String)TEST_DOMAIN2, (String)this.domain.getID());
        EditingDomainRegistryTest.assertSame((Object)this.domain, (Object)TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(TEST_DOMAIN2));
        EditingDomainRegistryTest.assertSame((Object)this.domain, (Object)TransactionalEditingDomain.Registry.INSTANCE.remove(TEST_DOMAIN2));
        EditingDomainRegistryTest.assertNull((Object)TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(TEST_DOMAIN2));
        EditingDomainRegistryTest.assertEquals((String)TEST_DOMAIN2, (String)this.domain.getID());
    }

    public void ignore_test_staticRegistration() {
        EditingDomainRegistryTest.assertEquals((int)0, (int)TestEditingDomain.instanceCount);
        TransactionalEditingDomain registered = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(TEST_DOMAIN1);
        EditingDomainRegistryTest.assertTrue((boolean)(registered instanceof TestEditingDomain));
        EditingDomainRegistryTest.assertEquals((String)TEST_DOMAIN1, (String)registered.getID());
        EditingDomainRegistryTest.assertEquals((int)1, (int)TestEditingDomain.instanceCount);
        try {
            TransactionalEditingDomain.Registry.INSTANCE.remove(TEST_DOMAIN1);
            EditingDomainRegistryTest.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            EditingDomainRegistryTest.trace("Got expected exception: " + e.getLocalizedMessage());
        }
        EditingDomainRegistryTest.assertSame((Object)registered, (Object)TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(TEST_DOMAIN1));
        EditingDomainRegistryTest.assertEquals((int)1, (int)TestEditingDomain.instanceCount);
    }

    public void test_replaceDomain() {
        TransactionalEditingDomain domain1 = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain("org.eclipse.emf.transaction.tests.foo");
        EditingDomainRegistryTest.assertNull((Object)domain1);
        domain1 = new TestEditingDomain.FactoryImpl().createEditingDomain();
        EditingDomainRegistryTest.assertNotNull((Object)domain1);
        TransactionalEditingDomain.Registry.INSTANCE.add("org.eclipse.emf.transaction.tests.foo", domain1);
        EditingDomainRegistryTest.assertSame((Object)domain1, (Object)TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain("org.eclipse.emf.transaction.tests.foo"));
        TransactionalEditingDomain domain2 = new TestEditingDomain.FactoryImpl().createEditingDomain();
        TransactionalEditingDomain.Registry.INSTANCE.add("org.eclipse.emf.transaction.tests.foo", domain2);
        EditingDomainRegistryTest.assertSame((Object)domain2, (Object)TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain("org.eclipse.emf.transaction.tests.foo"));
        TransactionalEditingDomain.Registry.INSTANCE.remove("org.eclipse.emf.transaction.tests.foo");
    }

    public void test_changeDomainId() {
        TransactionalEditingDomain domain1 = new TestEditingDomain.FactoryImpl().createEditingDomain();
        EditingDomainRegistryTest.assertNotNull((Object)domain1);
        domain1.setID("org.eclipse.emf.transaction.tests.foo");
        EditingDomainRegistryTest.assertNull((Object)TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain("org.eclipse.emf.transaction.tests.foo"));
        EditingDomainRegistryTest.assertNull((Object)TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain("org.eclipse.emf.transaction.tests.bar"));
        TransactionalEditingDomain.Registry.INSTANCE.add("org.eclipse.emf.transaction.tests.foo", domain1);
        EditingDomainRegistryTest.assertNotNull((Object)TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain("org.eclipse.emf.transaction.tests.foo"));
        EditingDomainRegistryTest.assertNull((Object)TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain("org.eclipse.emf.transaction.tests.bar"));
        domain1.setID("org.eclipse.emf.transaction.tests.bar");
        EditingDomainRegistryTest.assertNull((Object)TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain("org.eclipse.emf.transaction.tests.foo"));
        EditingDomainRegistryTest.assertNotNull((Object)TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain("org.eclipse.emf.transaction.tests.bar"));
        TransactionalEditingDomain.Registry.INSTANCE.remove(domain1.getID());
        EditingDomainRegistryTest.assertNull((Object)TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain("org.eclipse.emf.transaction.tests.foo"));
        EditingDomainRegistryTest.assertNull((Object)TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain("org.eclipse.emf.transaction.tests.bar"));
        domain1.setID("org.eclipse.emf.transaction.tests.foo");
        EditingDomainRegistryTest.assertNull((Object)TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain("org.eclipse.emf.transaction.tests.bar"));
        EditingDomainRegistryTest.assertNull((Object)TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain("org.eclipse.emf.transaction.tests.foo"));
    }

    public void test_listenerRegistration_singleDomain_multipleListeners() {
        TransactionalEditingDomain domain3 = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(TEST_DOMAIN3);
        EditingDomainRegistryTest.assertNull((Object)domain3);
        domain3 = new TestEditingDomain.FactoryImpl().createEditingDomain();
        EditingDomainRegistryTest.assertNotNull((Object)domain3);
        TransactionalEditingDomain.Registry.INSTANCE.add(TEST_DOMAIN3, domain3);
        EditingDomainRegistryTest.assertNotNull((Object)((Object)TestListener1.getInstance()));
        EditingDomainRegistryTest.assertNotNull((Object)((Object)TestListener2.getInstance()));
        final TransactionalEditingDomain finalDomain3 = domain3;
        try {
            domain3.runExclusive(new Runnable(){

                @Override
                public void run() {
                    finalDomain3.getResourceSet().createResource(URI.createFileURI((String)"/tmp/dummy.extlibrary"));
                }
            });
        }
        catch (Exception e) {
            this.fail(e);
        }
        EditingDomainRegistryTest.assertNotNull((Object)TestListener1.getInstance().postcommit);
        List notifications = TestListener1.getInstance().postcommit.getNotifications();
        EditingDomainRegistryTest.assertFalse((notifications == null ? 1 : 0) != 0);
        EditingDomainRegistryTest.assertEquals((int)1, (int)notifications.size());
        Notification notification = (Notification)notifications.get(0);
        EditingDomainRegistryTest.assertSame((Object)domain3.getResourceSet(), (Object)notification.getNotifier());
        EditingDomainRegistryTest.assertEquals((int)0, (int)notification.getFeatureID(null));
        EditingDomainRegistryTest.assertEquals((int)3, (int)notification.getEventType());
        EditingDomainRegistryTest.assertNotNull((Object)TestListener2.getInstance().postcommit);
        notifications = TestListener2.getInstance().postcommit.getNotifications();
        EditingDomainRegistryTest.assertFalse((notifications == null ? 1 : 0) != 0);
        EditingDomainRegistryTest.assertEquals((int)1, (int)notifications.size());
        EditingDomainRegistryTest.assertSame((Object)notification, notifications.get(0));
        TransactionalEditingDomain.Registry.INSTANCE.remove(TEST_DOMAIN3);
        Runtime.getRuntime().gc();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Runtime.getRuntime().gc();
        EditingDomainRegistryTest.assertNull((Object)((Object)TestListener1.getInstance()));
        EditingDomainRegistryTest.assertNull((Object)((Object)TestListener2.getInstance()));
    }

    public void test_listenerRegistration_multiDomains_singleListener() {
        TransactionalEditingDomain domain3 = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(TEST_DOMAIN3);
        EditingDomainRegistryTest.assertNull((Object)domain3);
        domain3 = new TestEditingDomain.FactoryImpl().createEditingDomain();
        EditingDomainRegistryTest.assertNotNull((Object)domain3);
        TransactionalEditingDomain.Registry.INSTANCE.add(TEST_DOMAIN3, domain3);
        TransactionalEditingDomain domain4 = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(TEST_DOMAIN4);
        EditingDomainRegistryTest.assertNull((Object)domain4);
        domain4 = new TestEditingDomain.FactoryImpl().createEditingDomain();
        EditingDomainRegistryTest.assertNotNull((Object)domain4);
        TransactionalEditingDomain.Registry.INSTANCE.add(TEST_DOMAIN4, domain4);
        EditingDomainRegistryTest.assertNotNull((Object)((Object)TestListener2.getInstance()));
        final TransactionalEditingDomain finalDomain3 = domain3;
        try {
            domain3.runExclusive(new Runnable(){

                @Override
                public void run() {
                    finalDomain3.getResourceSet().createResource(URI.createFileURI((String)"/tmp/dummy.extlibrary"));
                }
            });
        }
        catch (Exception e) {
            this.fail(e);
        }
        EditingDomainRegistryTest.assertNotNull((Object)TestListener2.getInstance().postcommit);
        List notifications = TestListener2.getInstance().postcommitNotifications;
        EditingDomainRegistryTest.assertFalse((notifications == null ? 1 : 0) != 0);
        EditingDomainRegistryTest.assertEquals((int)1, (int)notifications.size());
        Notification notification = (Notification)notifications.get(0);
        EditingDomainRegistryTest.assertSame((Object)domain3.getResourceSet(), (Object)notification.getNotifier());
        EditingDomainRegistryTest.assertEquals((int)0, (int)notification.getFeatureID(null));
        EditingDomainRegistryTest.assertEquals((int)3, (int)notification.getEventType());
        TestListener2.getInstance().reset();
        final TransactionalEditingDomain finalDomain4 = domain4;
        try {
            domain4.runExclusive(new Runnable(){

                @Override
                public void run() {
                    finalDomain4.getResourceSet().createResource(URI.createFileURI((String)"/tmp/dummy.extlibrary"));
                }
            });
        }
        catch (Exception e) {
            this.fail(e);
        }
        EditingDomainRegistryTest.assertNotNull((Object)TestListener2.getInstance().postcommit);
        notifications = TestListener2.getInstance().postcommitNotifications;
        EditingDomainRegistryTest.assertFalse((notifications == null ? 1 : 0) != 0);
        EditingDomainRegistryTest.assertEquals((int)1, (int)notifications.size());
        notification = (Notification)notifications.get(0);
        EditingDomainRegistryTest.assertSame((Object)domain4.getResourceSet(), (Object)notification.getNotifier());
        EditingDomainRegistryTest.assertEquals((int)0, (int)notification.getFeatureID(null));
        EditingDomainRegistryTest.assertEquals((int)3, (int)notification.getEventType());
        TransactionalEditingDomain.Registry.INSTANCE.remove(TEST_DOMAIN3);
        TransactionalEditingDomain.Registry.INSTANCE.remove(TEST_DOMAIN4);
        Runtime.getRuntime().gc();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Runtime.getRuntime().gc();
        EditingDomainRegistryTest.assertNull((Object)((Object)TestListener2.getInstance()));
    }

    public void test_listenerRegistration_universalListener() {
        TransactionalEditingDomain domain3 = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(TEST_DOMAIN3);
        EditingDomainRegistryTest.assertNull((Object)domain3);
        domain3 = new TestEditingDomain.FactoryImpl().createEditingDomain();
        EditingDomainRegistryTest.assertNotNull((Object)domain3);
        TransactionalEditingDomain.Registry.INSTANCE.add(TEST_DOMAIN3, domain3);
        TransactionalEditingDomain domain4 = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(TEST_DOMAIN4);
        EditingDomainRegistryTest.assertNull((Object)domain4);
        domain4 = new TestEditingDomain.FactoryImpl().createEditingDomain();
        EditingDomainRegistryTest.assertNotNull((Object)domain4);
        TransactionalEditingDomain.Registry.INSTANCE.add(TEST_DOMAIN4, domain4);
        EditingDomainRegistryTest.assertNotNull((Object)((Object)TestListener3.getInstance()));
        final TransactionalEditingDomain finalDomain3 = domain3;
        try {
            domain3.runExclusive(new Runnable(){

                @Override
                public void run() {
                    finalDomain3.getResourceSet().createResource(URI.createFileURI((String)"/tmp/dummy.extlibrary"));
                }
            });
        }
        catch (Exception e) {
            this.fail(e);
        }
        EditingDomainRegistryTest.assertNotNull((Object)TestListener3.getInstance().postcommit);
        List notifications = TestListener3.getInstance().postcommitNotifications;
        EditingDomainRegistryTest.assertFalse((notifications == null ? 1 : 0) != 0);
        EditingDomainRegistryTest.assertEquals((int)1, (int)notifications.size());
        Notification notification = (Notification)notifications.get(0);
        EditingDomainRegistryTest.assertSame((Object)domain3.getResourceSet(), (Object)notification.getNotifier());
        EditingDomainRegistryTest.assertEquals((int)0, (int)notification.getFeatureID(null));
        EditingDomainRegistryTest.assertEquals((int)3, (int)notification.getEventType());
        TestListener3.getInstance().reset();
        final TransactionalEditingDomain finalDomain4 = domain4;
        try {
            domain4.runExclusive(new Runnable(){

                @Override
                public void run() {
                    finalDomain4.getResourceSet().createResource(URI.createFileURI((String)"/tmp/dummy.extlibrary"));
                }
            });
        }
        catch (Exception e) {
            this.fail(e);
        }
        EditingDomainRegistryTest.assertNotNull((Object)TestListener3.getInstance().postcommit);
        notifications = TestListener3.getInstance().postcommitNotifications;
        EditingDomainRegistryTest.assertFalse((notifications == null ? 1 : 0) != 0);
        EditingDomainRegistryTest.assertEquals((int)1, (int)notifications.size());
        notification = (Notification)notifications.get(0);
        EditingDomainRegistryTest.assertSame((Object)domain4.getResourceSet(), (Object)notification.getNotifier());
        EditingDomainRegistryTest.assertEquals((int)0, (int)notification.getFeatureID(null));
        EditingDomainRegistryTest.assertEquals((int)3, (int)notification.getEventType());
        TransactionalEditingDomain.Registry.INSTANCE.remove(TEST_DOMAIN3);
        TransactionalEditingDomain.Registry.INSTANCE.remove(TEST_DOMAIN4);
    }

    public void test_registerDefaultFactory_136674() {
        TransactionalEditingDomain defaultDomain = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain("org.eclipse.emf.transaction.tests.TestDefaultFactoryDomain1");
        EditingDomainRegistryTest.assertNotNull((Object)defaultDomain);
    }

    public static class TestListener1
    extends TestListener {
        private static WeakReference<TestListener1> instance;

        public TestListener1() {
            instance = new WeakReference<TestListener1>(this);
        }

        public static TestListener1 getInstance() {
            return instance == null ? null : (TestListener1)((Object)instance.get());
        }
    }

    public static class TestListener2
    extends TestListener {
        private static WeakReference<TestListener2> instance;

        public TestListener2() {
            instance = new WeakReference<TestListener2>(this);
        }

        public static TestListener2 getInstance() {
            return instance == null ? null : (TestListener2)((Object)instance.get());
        }
    }

    public static class TestListener3
    extends TestListener {
        private static WeakReference<TestListener3> instance;

        public TestListener3() {
            instance = new WeakReference<TestListener3>(this);
        }

        public static TestListener3 getInstance() {
            return instance == null ? null : (TestListener3)((Object)instance.get());
        }
    }
}

