/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.env;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QVTOEnvironment;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QVTOTypeResolver;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtTypeResolverImpl;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.DictionaryType;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ImperativeOCLPackage;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.types.TupleType;
import org.eclipse.ocl.types.TypeType;
import org.eclipse.ocl.types.util.TypesSwitch;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.TypedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GenericsResolver {
    private final QVTOEnvironment fEnv;
    private final OCLStandardLibrary<EClassifier> fOCLStdLib;
    private final BindSwitch fBindSwitch;
    private final Map<EClassifier, EClassifier> formal2ActualBinding = new HashMap<EClassifier, EClassifier>(3);

    GenericsResolver(QVTOEnvironment env) {
        if (env == null) {
            throw new IllegalArgumentException();
        }
        this.fEnv = env;
        this.fOCLStdLib = env.getOCLStandardLibrary();
        this.fBindSwitch = new BindSwitch();
    }

    public boolean resolveGenericType(EClassifier owner, EClassifier formalType, EClassifier actualType) {
        this.resolve(formalType, actualType);
        EClassifier resolvedType = (EClassifier)this.fBindSwitch.doSwitch((EObject)formalType);
        return TypeUtil.compatibleTypeMatch((Environment)this.fEnv, (Object)actualType, (Object)resolvedType);
    }

    public EClassifier resolveOperationReturnType(EClassifier source, EOperation operation, List<? extends TypedElement<EClassifier>> args) {
        EClassifier owner = (EClassifier)this.fEnv.getUMLReflection().getOwningClassifier((Object)operation);
        this.resolve(owner, source);
        int paramIndex = 0;
        for (EParameter eParameter : operation.getEParameters()) {
            EClassifier paramFormalType = eParameter.getEType();
            if (paramFormalType == null) continue;
            EClassifier actualArgType = (EClassifier)args.get(paramIndex++).getType();
            this.resolve(paramFormalType, actualArgType);
        }
        EClassifier returnType = operation.getEType();
        if (this.formal2ActualBinding.isEmpty()) {
            return returnType;
        }
        if (returnType != null) {
            returnType = (EClassifier)this.fBindSwitch.doSwitch((EObject)returnType);
            this.formal2ActualBinding.clear();
        }
        return returnType;
    }

    private void resolve(EClassifier formalType, EClassifier actualType) {
        if (formalType == null || actualType == null) {
            return;
        }
        if (formalType instanceof CollectionType && actualType instanceof CollectionType) {
            this.resolveCollection((CollectionType)formalType, (CollectionType)actualType);
        } else if (formalType instanceof TypeType && actualType instanceof TypeType) {
            TypeType actualTypeType = (TypeType)actualType;
            if (formalType == this.fEnv.getOCLStandardLibrary().getOclType()) {
                this.resolve((EClassifier)this.fOCLStdLib.getT(), (EClassifier)actualTypeType.getReferredType());
            }
        } else if (this.isGeneric(formalType)) {
            this.bind(formalType, actualType);
        }
    }

    void resolveCollection(CollectionType formal, CollectionType actual) {
        EClassifier formalElementType = (EClassifier)formal.getElementType();
        EClassifier actualElementType = (EClassifier)actual.getElementType();
        this.resolve(formalElementType, actualElementType);
        if (formal instanceof DictionaryType && actual instanceof DictionaryType) {
            DictionaryType formalDict = (DictionaryType)formal;
            DictionaryType actualDict = (DictionaryType)actual;
            this.resolve(formalDict.getKeyType(), actualDict.getKeyType());
        }
    }

    private boolean isGeneric(EClassifier type) {
        return type == this.fOCLStdLib.getT() || type == this.fOCLStdLib.getT2() || type == this.fEnv.getQVTStandardLibrary().getKeyT();
    }

    void bind(EClassifier generic, EClassifier actualBound) {
        this.formal2ActualBinding.put(generic, actualBound);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BindSwitch
    extends TypesSwitch<EClassifier> {
        private QVTOTypeResolver typeResolver;

        private BindSwitch() {
            this.typeResolver = GenericsResolver.this.fEnv.getTypeResolver();
        }

        private EClassifier getBoundType(EClassifier type) {
            EClassifier bound = (EClassifier)GenericsResolver.this.formal2ActualBinding.get(type);
            return bound != null ? bound : type;
        }

        public <C, O> EClassifier caseCollectionType(org.eclipse.ocl.types.CollectionType<C, O> object) {
            EClassifier boundElementType = (EClassifier)this.typeResolver.resolve(this.getBoundType((EClassifier)object.getElementType()));
            if (object.eClass() == ImperativeOCLPackage.eINSTANCE.getListType()) {
                return this.typeResolver.resolveListType(boundElementType);
            }
            if (object.eClass() == ImperativeOCLPackage.eINSTANCE.getDictionaryType()) {
                DictionaryType dictionaryType = (DictionaryType)object;
                EClassifier boundKeyType = this.getBoundType(dictionaryType.getKeyType());
                QvtTypeResolverImpl qvtTypeResolve = (QvtTypeResolverImpl)this.typeResolver;
                qvtTypeResolve.resolveDictionaryType(boundKeyType, boundElementType);
            }
            return (EClassifier)this.typeResolver.resolveCollectionType(object.getKind(), boundElementType);
        }

        public <O, P> EClassifier caseTupleType(TupleType<O, P> object) {
            return (EClassifier)object;
        }

        public <C, O> EClassifier caseTypeType(TypeType<C, O> object) {
            EClassifier referredType = this.getBoundType((EClassifier)object.getReferredType());
            if (referredType == null && GenericsResolver.this.fOCLStdLib.getOclType() == object) {
                referredType = this.getBoundType((EClassifier)GenericsResolver.this.fOCLStdLib.getT());
            }
            return (EClassifier)this.typeResolver.resolveTypeType((EClassifier)this.typeResolver.resolve(referredType));
        }

        public EClassifier defaultCase(EObject object) {
            return this.getBoundType((EClassifier)object);
        }
    }
}

