/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ocl.ui.imp;

import org.eclipse.ocl.cst.CSTPackage;
import org.eclipse.qvt.declarative.editor.ocl.ui.OCLCreationFactory;
import org.eclipse.qvt.declarative.editor.ui.ICreationFactory;
import org.eclipse.qvt.declarative.editor.ui.imp.CommonKeyword;
import org.eclipse.qvt.declarative.editor.ui.imp.CommonParseController;
import org.eclipse.qvt.declarative.editor.ui.imp.ICommonKeyword;
import org.eclipse.qvt.declarative.editor.ui.imp.ICommonParseController;

public class OCLParseController
extends CommonParseController {
    public static final String[] oclIteratorKeywords = new String[]{"iterate", "forAll", "exists", "isUnique", "any", "one", "collect", "select", "reject", "collectNested", "sortedBy", "closure"};
    public static final String[] oclIdentifierKeywords = new String[]{"attr", "oper", "allInstances", "oclIsKindOf", "oclIsTypeOf", "oclAsType", "oclIsNew", "oclIsUndefined", "oclIsInvalid", "oclIsInState", "body", "derive", "init", "Set", "Bag", "Sequence", "Collection", "OrderedSet", "String", "Integer", "UnlimitedNatural", "Real", "Boolean", "Tuple", "OclAny", "OclVoid", "Invalid", "OclMessage", "OclInvalid"};

    public static ICommonKeyword createOCLKeyword(String text) {
        String s;
        String[] stringArray = oclIteratorKeywords;
        int n = oclIteratorKeywords.length;
        int n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (s.equals(text)) {
                return new CommonKeyword.Identifier(text);
            }
            ++n2;
        }
        stringArray = oclIdentifierKeywords;
        n = oclIdentifierKeywords.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (s.equals(text)) {
                return new CommonKeyword.Identifier(text);
            }
            ++n2;
        }
        return null;
    }

    public OCLParseController() {
        super((ICreationFactory)OCLCreationFactory.INSTANCE);
        CSTPackage.eINSTANCE.getClass();
    }

    protected ICommonKeyword createKeyword(String text) {
        ICommonKeyword keyword = OCLParseController.createOCLKeyword(text);
        return keyword != null ? keyword : super.createKeyword(text);
    }

    public ICommonParseController.TokenKind getTokenKind(int kind) {
        switch (kind) {
            case 73: {
                return ICommonParseController.TokenKind.EOF;
            }
            case 6: {
                return ICommonParseController.TokenKind.IDENTIFIER;
            }
            case 28: {
                return ICommonParseController.TokenKind.INTEGER;
            }
            case 29: {
                return ICommonParseController.TokenKind.REAL;
            }
            case 25: {
                return ICommonParseController.TokenKind.STRING;
            }
            case 78: {
                return ICommonParseController.TokenKind.LINE_COMMENT;
            }
            case 79: {
                return ICommonParseController.TokenKind.PARAGRAPH_COMMENT;
            }
        }
        if (this.isKeyword(kind)) {
            return ICommonParseController.TokenKind.KEYWORD;
        }
        return ICommonParseController.TokenKind.OTHER;
    }
}

