/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor;

import org.eclipse.core.runtime.Assert;
import org.eclipse.imp.editor.internal.ImageDecoratorController;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.imp.services.DecorationDescriptor;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class SourceEntityImageDescriptor
extends CompositeImageDescriptor {
    private final ImageDecoratorController fController;
    private ImageDescriptor fBaseImage;
    private int fFlags;
    private Point fSize;

    public SourceEntityImageDescriptor(ImageDescriptor baseImage, int flags, Point size, ImageDecoratorController ctlr) {
        this.fController = ctlr;
        this.fBaseImage = baseImage;
        Assert.isNotNull((Object)this.fBaseImage);
        this.fFlags = flags;
        Assert.isTrue((this.fFlags >= 0 ? 1 : 0) != 0);
        this.fSize = size;
        Assert.isNotNull((Object)this.fSize);
    }

    public void setAdornments(int adornments) {
        Assert.isTrue((adornments >= 0 ? 1 : 0) != 0);
        this.fFlags = adornments;
    }

    public int getAdornments() {
        return this.fFlags;
    }

    public void setImageSize(Point size) {
        Assert.isNotNull((Object)size);
        Assert.isTrue((size.x >= 0 && size.y >= 0 ? 1 : 0) != 0);
        this.fSize = size;
    }

    public Point getImageSize() {
        return new Point(this.fSize.x, this.fSize.y);
    }

    protected Point getSize() {
        return this.fSize;
    }

    public boolean equals(Object object) {
        if (object == null || !SourceEntityImageDescriptor.class.equals(object.getClass())) {
            return false;
        }
        SourceEntityImageDescriptor other = (SourceEntityImageDescriptor)((Object)object);
        return this.fBaseImage.equals(other.fBaseImage) && this.fFlags == other.fFlags && this.fSize.equals((Object)other.fSize);
    }

    public int hashCode() {
        return this.fBaseImage.hashCode() | this.fFlags | this.fSize.hashCode();
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg = this.getImageData(this.fBaseImage);
        this.drawImage(bg, 0, 0);
        this.drawTopRight();
        this.drawBottomRight();
        this.drawBottomLeft();
    }

    private ImageData getImageData(ImageDescriptor descriptor) {
        ImageData data = descriptor.getImageData();
        if (data == null) {
            data = DEFAULT_IMAGE_DATA;
            RuntimePlugin.getInstance().writeErrorMsg("Image data not available: " + descriptor.toString());
        }
        return data;
    }

    private void addTopRightImage(ImageDescriptor desc, Point pos) {
        ImageData data = this.getImageData(desc);
        int x = pos.x - data.width;
        if (x >= 0) {
            this.drawImage(data, x, pos.y);
            pos.x = x;
        }
    }

    private void addBottomRightImage(ImageDescriptor desc, Point pos) {
        ImageData data = this.getImageData(desc);
        int x = pos.x - data.width;
        int y = pos.y - data.height;
        if (x >= 0 && y >= 0) {
            this.drawImage(data, x, y);
            pos.x = x;
        }
    }

    private void addBottomLeftImage(ImageDescriptor desc, Point pos) {
        ImageData data = this.getImageData(desc);
        int x = pos.x;
        int y = pos.y - data.height;
        if (x + data.width < this.getSize().x && y >= 0) {
            this.drawImage(data, x, y);
            pos.x = x + data.width;
        }
    }

    private void drawTopRight() {
        Point pos = new Point(this.getSize().x, 0);
        for (DecorationDescriptor d : this.fController.getTopRightDecorations()) {
            if ((this.fFlags & d.mask) == 0) continue;
            this.addTopRightImage(d.getImageDescriptor(), pos);
        }
    }

    private void drawBottomRight() {
        Point size = this.getSize();
        Point pos = new Point(size.x, size.y);
        for (DecorationDescriptor d : this.fController.getBottomRightDecorations()) {
            if ((this.fFlags & d.mask) == 0) continue;
            this.addBottomRightImage(d.getImageDescriptor(), pos);
        }
    }

    private void drawBottomLeft() {
        Point pos = new Point(0, this.getSize().y);
        for (DecorationDescriptor d : this.fController.getBottomLeftDecorations()) {
            if ((this.fFlags & d.mask) == 0) continue;
            this.addBottomLeftImage(d.getImageDescriptor(), pos);
        }
    }
}

