/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core.ls;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.ls.core.internal.IDelegateCommandHandler;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.lsp4mp.jdt.core.IMicroProfilePropertiesChangedListener;
import org.eclipse.lsp4mp.jdt.internal.core.MicroProfilePropertiesListenerManager;

public abstract class AbstractMicroProfileDelegateCommandHandler
implements IDelegateCommandHandler {
    private static final Logger LOGGER = Logger.getLogger(AbstractMicroProfileDelegateCommandHandler.class.getName());
    private static final String MICROPROFILE_PROPERTIES_CHANGED_COMMAND = "microprofile/propertiesChanged";
    private static final IMicroProfilePropertiesChangedListener LISTENER = event -> {
        try {
            JavaLanguageServerPlugin.getInstance().getClientConnection().executeClientCommand(Duration.of(5L, ChronoUnit.SECONDS), MICROPROFILE_PROPERTIES_CHANGED_COMMAND, new Object[]{event});
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while sending 'microprofile/propertiesChanged' event to the client", e);
        }
    };
    private static boolean initialized;

    public AbstractMicroProfileDelegateCommandHandler() {
        AbstractMicroProfileDelegateCommandHandler.initialize();
    }

    private static synchronized void initialize() {
        if (initialized) {
            return;
        }
        MicroProfilePropertiesListenerManager.getInstance().addMicroProfilePropertiesChangedListener(LISTENER);
        initialized = true;
    }
}

