/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.adapters;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.google.gson.stream.MalformedJsonException;
import java.io.EOFException;
import java.io.IOException;
import org.eclipse.lsp4j.WorkDoneProgressBegin;
import org.eclipse.lsp4j.WorkDoneProgressEnd;
import org.eclipse.lsp4j.WorkDoneProgressKind;
import org.eclipse.lsp4j.WorkDoneProgressNotification;
import org.eclipse.lsp4j.WorkDoneProgressReport;

public class WorkDoneProgressNotificationAdapter
extends TypeAdapter<WorkDoneProgressNotification> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WorkDoneProgressNotification read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        in.beginObject();
        String kind = null;
        String message = null;
        String title = null;
        Boolean cancellable = null;
        Integer percentage = null;
        try {
            block16: while (true) {
                String name;
                if (!in.hasNext()) {
                    in.endObject();
                    return this.createNotification(kind, message, title, cancellable, percentage);
                }
                switch (name = in.nextName()) {
                    case "kind": {
                        kind = in.nextString();
                        continue block16;
                    }
                    case "title": {
                        title = in.nextString();
                        continue block16;
                    }
                    case "message": {
                        message = in.nextString();
                        continue block16;
                    }
                    case "cancellable": {
                        cancellable = in.nextBoolean();
                        continue block16;
                    }
                    case "percentage": {
                        percentage = in.nextInt();
                        continue block16;
                    }
                }
                in.skipValue();
            }
        }
        catch (JsonSyntaxException | MalformedJsonException | EOFException exception) {
            if (kind != null) {
                throw new JsonParseException(exception);
            }
            throw exception;
        }
    }

    private WorkDoneProgressNotification createNotification(String kind, String message, String title, Boolean cancellable, Integer percentage) throws MalformedJsonException {
        if (kind == null) {
            throw new MalformedJsonException("Kind of progress notification is empty");
        }
        switch (kind) {
            case "begin": {
                WorkDoneProgressBegin begin = new WorkDoneProgressBegin();
                begin.setMessage(message);
                begin.setCancellable(cancellable);
                begin.setPercentage(percentage);
                begin.setTitle(title);
                return begin;
            }
            case "report": {
                WorkDoneProgressReport report = new WorkDoneProgressReport();
                report.setMessage(message);
                report.setCancellable(cancellable);
                report.setPercentage(percentage);
                return report;
            }
            case "end": {
                WorkDoneProgressEnd end = new WorkDoneProgressEnd();
                end.setMessage(message);
                return end;
            }
        }
        throw new MalformedJsonException("Kind of progress notification is unknown: " + kind);
    }

    public void write(JsonWriter out, WorkDoneProgressNotification notification) throws IOException {
        out.beginObject();
        out.name("kind");
        WorkDoneProgressKind kind = notification.getKind();
        out.value(kind.toString());
        switch (kind) {
            case begin: {
                WorkDoneProgressBegin begin = (WorkDoneProgressBegin)notification;
                out.name("title");
                out.value(begin.getTitle());
                out.name("cancellable");
                out.value(begin.getCancellable());
                out.name("message");
                out.value(begin.getMessage());
                out.name("percentage");
                out.value((Number)begin.getPercentage());
                break;
            }
            case report: {
                WorkDoneProgressReport report = (WorkDoneProgressReport)notification;
                out.name("cancellable");
                out.value(report.getCancellable());
                out.name("message");
                out.value(report.getMessage());
                out.name("percentage");
                out.value((Number)report.getPercentage());
                break;
            }
            case end: {
                WorkDoneProgressEnd end = (WorkDoneProgressEnd)notification;
                out.name("message");
                out.value(end.getMessage());
                break;
            }
            default: {
                throw new MalformedJsonException("Kind of progress notification is unknown: " + String.valueOf((Object)kind));
            }
        }
        out.endObject();
    }

    public static class Factory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            Class rawType = typeToken.getRawType();
            if (!WorkDoneProgressNotification.class.isAssignableFrom(rawType)) {
                return null;
            }
            return new WorkDoneProgressNotificationAdapter();
        }
    }
}

