/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.completion;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.operations.completion.LSCompletionProposal;
import org.eclipse.lsp4e.operations.completion.LSCompletionProposalComparator;
import org.eclipse.lsp4j.CompletionItem;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LSCompletionProposalComparatorTest {
    @Test
    public void testDocumentFilterLengthDoesNotOverrideSortText() {
        Document document = new Document("");
        CompletionItem item1 = new CompletionItem("p1");
        item1.setSortText("B");
        CompletionItem item2 = new CompletionItem("p2");
        item2.setSortText("A");
        StubProposal proposalWithLongFilter = new StubProposal((IDocument)document, item1, "longFilter");
        StubProposal proposalWithShortFilter = new StubProposal((IDocument)document, item2, "x");
        LSCompletionProposalComparator comparator = new LSCompletionProposalComparator();
        ArrayList<StubProposal> proposals = new ArrayList<StubProposal>();
        proposals.add(proposalWithLongFilter);
        proposals.add(proposalWithShortFilter);
        proposals.sort((Comparator<StubProposal>)comparator);
        Assertions.assertEquals((Object)"A", (Object)((LSCompletionProposal)proposals.get(0)).getSortText());
        Assertions.assertEquals((Object)"B", (Object)((LSCompletionProposal)proposals.get(1)).getSortText());
    }

    @Test
    public void testFilteredProposalsShouldBeResortedWhenFilterChanges() {
        Document document = new Document("");
        CompletionItem item1 = new CompletionItem("p1");
        CompletionItem item2 = new CompletionItem("p2");
        boolean initialOffset = true;
        int updatedOffset = 2;
        VarFilterProposal proposalA = new VarFilterProposal((IDocument)document, item1);
        VarFilterProposal proposalB = new VarFilterProposal((IDocument)document, item2);
        proposalA.setFilterForOffset(1, "xx");
        proposalB.setFilterForOffset(1, "x");
        proposalA.setFilterForOffset(2, "x");
        proposalB.setFilterForOffset(2, "xx");
        LSCompletionProposalComparator comparator = new LSCompletionProposalComparator();
        ArrayList<VarFilterProposal> initiallySorted = new ArrayList<VarFilterProposal>();
        initiallySorted.add(proposalA);
        initiallySorted.add(proposalB);
        proposalA.setOffsetForSorting(1);
        proposalB.setOffsetForSorting(1);
        initiallySorted.sort((Comparator<VarFilterProposal>)comparator);
        ArrayList filteredWithoutResort = new ArrayList(initiallySorted);
        ArrayList<VarFilterProposal> expectedResorted = new ArrayList<VarFilterProposal>();
        expectedResorted.add(proposalA);
        expectedResorted.add(proposalB);
        proposalA.setOffsetForSorting(2);
        proposalB.setOffsetForSorting(2);
        expectedResorted.sort((Comparator<VarFilterProposal>)comparator);
        Assertions.assertEquals(expectedResorted, filteredWithoutResort);
    }

    private static class StubProposal
    extends LSCompletionProposal {
        private final String filter;

        StubProposal(IDocument document, CompletionItem item, String filter) {
            super(document, 0, item, null, null, false);
            this.filter = filter;
        }

        public String getDocumentFilter() {
            return this.filter;
        }

        public String getDocumentFilter(int offset) {
            return this.filter;
        }

        public int getRankCategory() {
            return 5;
        }

        public int getRankScore() {
            return 0;
        }
    }

    private static class VarFilterProposal
    extends LSCompletionProposal {
        private final Map<Integer, String> filtersByOffset = new HashMap<Integer, String>();
        private int sortOffset;

        VarFilterProposal(IDocument document, CompletionItem item) {
            super(document, 0, item, null, null, false);
        }

        void setFilterForOffset(int offset, String filter) {
            this.filtersByOffset.put(offset, filter);
        }

        void setOffsetForSorting(int offset) {
            this.sortOffset = offset;
        }

        public String getDocumentFilter() {
            String filter = this.filtersByOffset.get(this.sortOffset);
            return filter != null ? filter : "";
        }

        public String getDocumentFilter(int offset) {
            String filter = this.filtersByOffset.get(offset);
            return filter != null ? filter : "";
        }

        public int getRankCategory() {
            return 5;
        }

        public int getRankScore() {
            return 0;
        }
    }
}

