/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.operations.rename;

import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.operations.rename.LSPDeleteParticipant;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4e.tests.mock.MockWorkspaceService;
import org.eclipse.lsp4j.FileDelete;
import org.eclipse.lsp4j.FileOperationOptions;
import org.eclipse.lsp4j.FileOperationsServerCapabilities;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.WorkspaceServerCapabilities;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteArguments;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class LSPDeleteParticipantTest
extends AbstractTestWithProject {
    LSPDeleteParticipantTest() {
    }

    @BeforeEach
    void setupCaps() {
        MockLanguageServer.reset(() -> {
            ServerCapabilities caps = MockLanguageServer.defaultServerCapabilities();
            WorkspaceServerCapabilities ws = new WorkspaceServerCapabilities();
            FileOperationsServerCapabilities fileOps = new FileOperationsServerCapabilities();
            fileOps.setWillDelete(new FileOperationOptions());
            ws.setFileOperations(fileOps);
            caps.setWorkspace(ws);
            return caps;
        });
    }

    @Test
    void fileDeleteSendsWillDelete() throws Exception {
        IFile file = TestUtils.createUniqueTestFile(this.project, "content");
        TestUtils.openTextViewer(file);
        Assertions.assertTrue((boolean)LanguageServers.forProject((IProject)this.project).anyMatching());
        URI uri = LSPEclipseUtils.toUri((IResource)file);
        Assertions.assertNotNull((Object)uri);
        TestableDeleteParticipant participant = new TestableDeleteParticipant();
        participant.setArgs(new DeleteArguments());
        Assertions.assertTrue((boolean)participant.initialize(file));
        participant.checkConditions((IProgressMonitor)new NullProgressMonitor(), new CheckConditionsContext());
        participant.createPreChange((IProgressMonitor)new NullProgressMonitor());
        MockWorkspaceService ws = MockLanguageServer.INSTANCE.getWorkspaceService();
        Assertions.assertNotNull((Object)ws.getLastWillDelete());
        Assertions.assertEquals((int)1, (int)ws.getLastWillDelete().getFiles().size());
        Assertions.assertEquals((Object)uri.toString(), (Object)((FileDelete)ws.getLastWillDelete().getFiles().get(0)).getUri());
    }

    @Test
    void folderDeleteSendsWillDelete() throws Exception {
        IFile starter = TestUtils.createUniqueTestFile(this.project, "content");
        TestUtils.openTextViewer(starter);
        Assertions.assertTrue((boolean)LanguageServers.forProject((IProject)this.project).anyMatching());
        IFolder folder = this.project.getFolder("toDeleteFolder");
        if (!folder.exists()) {
            folder.create(true, true, null);
        }
        URI uri = LSPEclipseUtils.toUri((IResource)folder);
        Assertions.assertNotNull((Object)uri);
        TestableDeleteParticipant participant = new TestableDeleteParticipant();
        participant.setArgs(new DeleteArguments());
        Assertions.assertTrue((boolean)participant.initialize(folder));
        participant.checkConditions((IProgressMonitor)new NullProgressMonitor(), new CheckConditionsContext());
        participant.createPreChange((IProgressMonitor)new NullProgressMonitor());
        MockWorkspaceService ws = MockLanguageServer.INSTANCE.getWorkspaceService();
        Assertions.assertNotNull((Object)ws.getLastWillDelete());
        Assertions.assertEquals((int)1, (int)ws.getLastWillDelete().getFiles().size());
        Assertions.assertEquals((Object)uri.toString(), (Object)((FileDelete)ws.getLastWillDelete().getFiles().get(0)).getUri());
    }

    static class TestableDeleteParticipant
    extends LSPDeleteParticipant {
        private DeleteArguments args;

        TestableDeleteParticipant() {
        }

        void setArgs(DeleteArguments args) {
            this.args = args;
        }

        public boolean initialize(Object element) {
            return super.initialize(element);
        }

        public DeleteArguments getArguments() {
            return this.args;
        }
    }
}

