/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.operations.inlayhint;

import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.inlayhint.InlayHintProvider;
import org.eclipse.lsp4e.operations.inlayhint.LSPLineContentCodeMining;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.InlayHint;
import org.eclipse.lsp4j.InlayHintLabelPart;
import org.eclipse.lsp4j.Position;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LSPLineContentCodeMiningTest
extends AbstractTestWithProject {
    private static final String MOCK_SERVER_ID = "org.eclipse.lsp4e.test.server";

    @Test
    public void singleLabelPartCommand() throws Exception {
        InlayHint inlay = LSPLineContentCodeMiningTest.createMultiLabelInlayHint(LSPLineContentCodeMiningTest.createInlayLabelPart("Label-Text", "mock.command"));
        Command command = ((InlayHintLabelPart)((List)inlay.getLabel().getRight()).get(0)).getCommand();
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("bar", (Number)42);
        command.setArguments(List.of(new JsonPrimitive("Foo"), jsonObject));
        IFile file = TestUtils.createUniqueTestFile(this.project, "lspt", "test content");
        ITextViewer textViewer = TestUtils.openTextViewer(file);
        IDocument document = textViewer.getDocument();
        MockLanguageServer languageServer = MockLanguageServer.INSTANCE;
        InlayHintProvider provider = new InlayHintProvider();
        LanguageServerWrapper wrapper = LanguageServiceAccessor.getLSWrapper((IProject)this.project, (LanguageServersRegistry.LanguageServerDefinition)LanguageServersRegistry.getInstance().getDefinition(MOCK_SERVER_ID));
        LSPLineContentCodeMining sut = new LSPLineContentCodeMining(inlay, document, wrapper, provider);
        MouseEvent mouseEvent = LSPLineContentCodeMiningTest.createMouseEvent();
        sut.getAction().accept(mouseEvent);
        ExecuteCommandParams executedCommand = (ExecuteCommandParams)languageServer.getWorkspaceService().getExecutedCommand().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)"mock.command", (Object)executedCommand.getCommand());
        Assertions.assertEquals((Object)command.getArguments(), (Object)executedCommand.getArguments());
    }

    private static InlayHintLabelPart createInlayLabelPart(String text, String commandID) {
        InlayHintLabelPart labelPart = new InlayHintLabelPart(text);
        Command command = new Command(text, commandID);
        labelPart.setCommand(command);
        return labelPart;
    }

    private static InlayHint createMultiLabelInlayHint(InlayHintLabelPart ... parts) {
        InlayHint inlay = new InlayHint();
        inlay.setLabel(List.of(parts));
        inlay.setPosition(new Position(0, 0));
        return inlay;
    }

    private static MouseEvent createMouseEvent() {
        Event event = new Event();
        event.button = 524288;
        Display display = Display.getCurrent();
        event.widget = display.getSystemTray();
        return new MouseEvent(event);
    }
}

