/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.jdt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.hover.JavadocHover;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.operations.completion.LSCompletionProposal;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

class LSJavaProposal
extends LSCompletionProposal
implements IJavaCompletionProposal {
    private static final int LS_DEFAULT_RELEVANCE = 18;
    private static final int MAX_BASE_RELEVANCE = 816;
    private static final int DEFAULT_RELEVANCE = 768;
    private static final int RANGE_WITHIN_CATEGORY = Math.round(12.0f);
    private static @Nullable String fgCSSStyles = null;
    private boolean relevanceComputed = false;
    private int relevance = -1;
    private @Nullable IInformationControlCreator infoControlCreator = null;

    public LSJavaProposal(LSCompletionProposal lsProposal) {
        super(lsProposal);
    }

    public int getRelevance() {
        if (!this.relevanceComputed) {
            this.relevance = this.computeBaseRelevance();
            switch (this.getItem().getKind()) {
                case Class: {
                    this.relevance += 3;
                    break;
                }
                case Field: 
                case Property: {
                    this.relevance += 5;
                    break;
                }
                case Method: {
                    this.relevance += 4;
                    break;
                }
                case Variable: 
                case Value: {
                    this.relevance += 6;
                }
            }
            this.relevanceComputed = true;
        }
        return this.relevance;
    }

    private int computeBaseRelevance() {
        int base = 816 - (this.getRankCategory() - 1) * RANGE_WITHIN_CATEGORY;
        int rank = this.getRankScore();
        return base -= rank >= 0 && rank < RANGE_WITHIN_CATEGORY ? rank : RANGE_WITHIN_CATEGORY;
    }

    public @Nullable IInformationControlCreator getInformationControlCreator() {
        if (this.infoControlCreator == null) {
            IInformationControlCreator presenterControlCreator = super.getInformationControlCreator();
            this.infoControlCreator = new JavadocHover.HoverControlCreator(presenterControlCreator, true);
        }
        return this.infoControlCreator;
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        StringBuilder buffer = new StringBuilder((String)super.getAdditionalProposalInfo(monitor));
        ColorRegistry registry = JFaceResources.getColorRegistry();
        RGB fgRGB = registry.getRGB("org.eclipse.jdt.ui.Javadoc.foregroundColor");
        RGB bgRGB = registry.getRGB("org.eclipse.jdt.ui.Javadoc.backgroundColor");
        HTMLPrinter.insertPageProlog((StringBuilder)buffer, (int)0, (RGB)fgRGB, (RGB)bgRGB, (String)this.getCSSStyles());
        HTMLPrinter.addPageEpilog((StringBuilder)buffer);
        return buffer.toString();
    }

    public @NonNull String getInformationDisplayString() {
        return this.item.getLabel();
    }

    private @Nullable String getCSSStyles() {
        String css;
        block18: {
            if (fgCSSStyles == null) {
                URL url;
                Bundle bundle = FrameworkUtil.getBundle(AbstractJavaCompletionProposal.class);
                URL uRL = url = bundle == null ? null : bundle.getEntry("/JavadocHoverStyleSheet.css");
                if (url != null) {
                    BufferedReader reader = null;
                    try {
                        try {
                            url = FileLocator.toFileURL((URL)url);
                            reader = new BufferedReader(new InputStreamReader(url.openStream()));
                            StringBuilder buffer = new StringBuilder(200);
                            String line = reader.readLine();
                            while (line != null) {
                                buffer.append(line);
                                buffer.append('\n');
                                line = reader.readLine();
                            }
                            fgCSSStyles = buffer.toString();
                        }
                        catch (IOException ex) {
                            LanguageServerPlugin.logError((Throwable)ex);
                            try {
                                if (reader != null) {
                                    reader.close();
                                }
                                break block18;
                            }
                            catch (IOException iOException) {}
                            break block18;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        if ((css = fgCSSStyles) != null) {
            FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.jdt.ui.javadocfont")[0];
            css = HTMLPrinter.convertTopLevelFont((String)css, (FontData)fontData);
        }
        return css;
    }
}

