/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.files;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.eclipse.lsp4e.internal.files.FileSystemWatcherManager;
import org.eclipse.lsp4j.FileSystemWatcher;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class FileSystemWatcherManagerTest {
    private static final String DEFAULT_WATCHER_ID = "default";
    private final Path projectDir = Paths.get("current-project", new String[0]).toAbsolutePath();
    private final Path externalDir = Paths.get("external-project", new String[0]).toAbsolutePath();
    private final FileSystemWatcherManager manager = new FileSystemWatcherManager(this.projectDir);

    FileSystemWatcherManagerTest() {
    }

    @BeforeEach
    void setUp() {
        this.manager.clear();
    }

    @AfterEach
    void tearDown() {
        this.manager.clear();
    }

    @Test
    void sapCdsPatterns() {
        this.registerWatchers(DEFAULT_WATCHER_ID, List.of(new FileSystemWatcher(Either.forLeft((Object)"package.json"), Integer.valueOf(7)), new FileSystemWatcher(Either.forLeft((Object)"{.git,.cds}ignore"), Integer.valueOf(7)), new FileSystemWatcher(Either.forLeft((Object)".cdsrc.json"), Integer.valueOf(7)), new FileSystemWatcher(Either.forLeft((Object)"**/{_i18n,i18n}/i18n{*.properties,*.json,*.csv}"), Integer.valueOf(7))));
        this.assertMatchFile(this.projectDir.resolve("package.json").toUri(), 1);
        this.assertMatchFile(this.projectDir.resolve("package.json").toUri(), 2);
        this.assertMatchFile(this.projectDir.resolve("package.json").toUri(), 4);
        this.assertNoMatchFile(this.projectDir.resolve("package.jso").toUri(), 1);
        this.assertNoMatchFile(this.projectDir.resolve("foo").resolve("package.json").toUri(), 1);
        this.assertNoMatchFile(this.externalDir.resolve("package.json").toUri(), 1);
        this.assertMatchFile(this.projectDir.resolve(".gitignore").toUri(), 1);
        this.assertNoMatchFile(this.projectDir.resolve("gitignore").toUri(), 1);
        this.assertMatchFile(this.projectDir.resolve(".cdsrc.json").toUri(), 1);
        this.assertNoMatchFile(this.projectDir.resolve("cdsrc.json").toUri(), 1);
        this.assertMatchFile(this.projectDir.resolve("_i18n").resolve("i18n.properties").toUri(), 1);
        this.assertMatchFile(this.projectDir.resolve("i18n").resolve("i18n.json").toUri(), 1);
        this.assertNoMatchFile(this.projectDir.resolve("other").resolve("i18n.properties").toUri(), 1);
    }

    @Test
    void watcherKindFiltering() {
        this.registerWatchers("watcher-kind", List.of(new FileSystemWatcher(Either.forLeft((Object)"**/*.kind_null"), null), new FileSystemWatcher(Either.forLeft((Object)"**/*.kind_7"), Integer.valueOf(7)), new FileSystemWatcher(Either.forLeft((Object)"**/*.kind_Create"), Integer.valueOf(1)), new FileSystemWatcher(Either.forLeft((Object)"**/*.kind_Change"), Integer.valueOf(2)), new FileSystemWatcher(Either.forLeft((Object)"**/*.kind_Delete"), Integer.valueOf(4))));
        URI createUri = this.projectDir.resolve("foo.kind_Create").toUri();
        URI changeUri = this.projectDir.resolve("foo.kind_Change").toUri();
        URI deleteUri = this.projectDir.resolve("foo.kind_Delete").toUri();
        URI nullUri = this.projectDir.resolve("foo.kind_null").toUri();
        URI anyUri = this.projectDir.resolve("foo.kind_7").toUri();
        this.assertMatchFile(nullUri, 1);
        this.assertMatchFile(nullUri, 2);
        this.assertMatchFile(nullUri, 4);
        this.assertMatchFile(anyUri, 1);
        this.assertMatchFile(anyUri, 2);
        this.assertMatchFile(anyUri, 4);
        this.assertMatchFile(createUri, 1);
        this.assertNoMatchFile(createUri, 2);
        this.assertNoMatchFile(createUri, 4);
        this.assertNoMatchFile(changeUri, 1);
        this.assertMatchFile(changeUri, 2);
        this.assertNoMatchFile(changeUri, 4);
        this.assertNoMatchFile(deleteUri, 1);
        this.assertNoMatchFile(deleteUri, 2);
        this.assertMatchFile(deleteUri, 4);
    }

    @Test
    void globMatchingSimple() {
        this.registerGlobWatcher("node_modules");
        this.assertGlobMatch("node_modules");
        this.assertNoGlobMatch("node_module");
        this.assertNoGlobMatch("test/node_modules");
        this.registerGlobWatcher("test.txt");
        this.assertGlobMatch("test.txt");
        if (!FileSystemWatcherManagerTest.isWindows()) {
            this.assertNoGlobMatch("test?txt");
        }
        this.assertNoGlobMatch("/text.txt");
        this.assertNoGlobMatch("test/test.txt");
    }

    private void registerWatchers(String id, List<FileSystemWatcher> watchers) {
        this.manager.registerFileSystemWatchers(id, watchers);
    }

    private void assertMatchFile(URI uri, int kind) {
        boolean matched = this.manager.isMatchFilePattern(uri, kind);
        Assertions.assertTrue((boolean)matched, () -> String.valueOf(uri) + " should match for kind " + kind);
    }

    private void assertNoMatchFile(URI uri, int kind) {
        boolean matched = this.manager.isMatchFilePattern(uri, kind);
        Assertions.assertFalse((boolean)matched, () -> String.valueOf(uri) + " should not match for kind " + kind);
    }

    private void registerGlobWatcher(String pattern) {
        this.manager.clear();
        this.manager.registerFileSystemWatchers(DEFAULT_WATCHER_ID, List.of(new FileSystemWatcher(Either.forLeft((Object)pattern), Integer.valueOf(1))));
    }

    private void assertGlobMatch(String relativePath) {
        this.assertGlobMatch(relativePath, true);
    }

    private void assertNoGlobMatch(String relativePath) {
        this.assertGlobMatch(relativePath, false);
    }

    private void assertGlobMatch(String relativePath, boolean expected) {
        URI uri = relativePath.startsWith("/") ? this.projectDir.resolve(relativePath.substring(1)).toUri() : this.projectDir.resolve(relativePath).toUri();
        boolean matched = this.manager.isMatchFilePattern(uri, 1);
        if (expected) {
            Assertions.assertTrue((boolean)matched, () -> "Pattern should match " + String.valueOf(uri));
        } else {
            Assertions.assertFalse((boolean)matched, () -> "Pattern should not match " + String.valueOf(uri));
        }
    }

    private static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().contains("win");
    }
}

