/**
 */
package timing;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see timing.TimingFactory
 * @model kind="package"
 * @generated
 */
public interface TimingPackage extends EPackage
{
    /**
     * The package name.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    String eNAME = "timing";

    /**
     * The package namespace URI.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    String eNS_URI = "http://www.eclipse.org/lsat/timing";

    /**
     * The package namespace name.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    String eNS_PREFIX = "timing";

    /**
     * The singleton instance of the package.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    TimingPackage eINSTANCE = timing.impl.TimingPackageImpl.init();

    /**
     * The meta object id for the '{@link timing.Timing <em>Timing</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see timing.Timing
     * @see timing.impl.TimingPackageImpl#getTiming()
     * @generated
     */
    int TIMING = 0;

    /**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int TIMING__NAME = 0;

    /**
     * The number of structural features of the '<em>Timing</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int TIMING_FEATURE_COUNT = 1;

    /**
     * The number of operations of the '<em>Timing</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int TIMING_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link timing.impl.ScalarImpl <em>Scalar</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see timing.impl.ScalarImpl
     * @see timing.impl.TimingPackageImpl#getScalar()
     * @generated
     */
    int SCALAR = 1;

    /**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int SCALAR__NAME = TIMING__NAME;

    /**
     * The feature id for the '<em><b>Value</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int SCALAR__VALUE = TIMING_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Value Exp</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int SCALAR__VALUE_EXP = TIMING_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the '<em>Scalar</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int SCALAR_FEATURE_COUNT = TIMING_FEATURE_COUNT + 2;

    /**
     * The number of operations of the '<em>Scalar</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int SCALAR_OPERATION_COUNT = TIMING_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link timing.impl.ArrayImpl <em>Array</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see timing.impl.ArrayImpl
     * @see timing.impl.TimingPackageImpl#getArray()
     * @generated
     */
    int ARRAY = 2;

    /**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARRAY__NAME = TIMING__NAME;

    /**
     * The feature id for the '<em><b>Values</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARRAY__VALUES = TIMING_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Values Exp</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARRAY__VALUES_EXP = TIMING_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the '<em>Array</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARRAY_FEATURE_COUNT = TIMING_FEATURE_COUNT + 2;

    /**
     * The number of operations of the '<em>Array</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARRAY_OPERATION_COUNT = TIMING_OPERATION_COUNT + 0;


    /**
     * Returns the meta object for class '{@link timing.Timing <em>Timing</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Timing</em>'.
     * @see timing.Timing
     * @generated
     */
    EClass getTiming();

    /**
     * Returns the meta object for the attribute '{@link timing.Timing#getName <em>Name</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Name</em>'.
     * @see timing.Timing#getName()
     * @see #getTiming()
     * @generated
     */
    EAttribute getTiming_Name();

    /**
     * Returns the meta object for class '{@link timing.Scalar <em>Scalar</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Scalar</em>'.
     * @see timing.Scalar
     * @generated
     */
    EClass getScalar();

    /**
     * Returns the meta object for the attribute '{@link timing.Scalar#getValue <em>Value</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Value</em>'.
     * @see timing.Scalar#getValue()
     * @see #getScalar()
     * @generated
     */
    EAttribute getScalar_Value();

    /**
     * Returns the meta object for the containment reference '{@link timing.Scalar#getValueExp <em>Value Exp</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the containment reference '<em>Value Exp</em>'.
     * @see timing.Scalar#getValueExp()
     * @see #getScalar()
     * @generated
     */
    EReference getScalar_ValueExp();

    /**
     * Returns the meta object for class '{@link timing.Array <em>Array</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Array</em>'.
     * @see timing.Array
     * @generated
     */
    EClass getArray();

    /**
     * Returns the meta object for the attribute list '{@link timing.Array#getValues <em>Values</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute list '<em>Values</em>'.
     * @see timing.Array#getValues()
     * @see #getArray()
     * @generated
     */
    EAttribute getArray_Values();

    /**
     * Returns the meta object for the containment reference list '{@link timing.Array#getValuesExp <em>Values Exp</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Values Exp</em>'.
     * @see timing.Array#getValuesExp()
     * @see #getArray()
     * @generated
     */
    EReference getArray_ValuesExp();

    /**
     * Returns the factory that creates the instances of the model.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the factory that creates the instances of the model.
     * @generated
     */
    TimingFactory getTimingFactory();

    /**
     * <!-- begin-user-doc -->
     * Defines literals for the meta objects that represent
     * <ul>
     *   <li>each class,</li>
     *   <li>each feature of each class,</li>
     *   <li>each operation of each class,</li>
     *   <li>each enum,</li>
     *   <li>and each data type</li>
     * </ul>
     * <!-- end-user-doc -->
     * @generated
     */
    interface Literals
    {
        /**
         * The meta object literal for the '{@link timing.Timing <em>Timing</em>}' class.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @see timing.Timing
         * @see timing.impl.TimingPackageImpl#getTiming()
         * @generated
         */
        EClass TIMING = eINSTANCE.getTiming();

        /**
         * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EAttribute TIMING__NAME = eINSTANCE.getTiming_Name();

        /**
         * The meta object literal for the '{@link timing.impl.ScalarImpl <em>Scalar</em>}' class.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @see timing.impl.ScalarImpl
         * @see timing.impl.TimingPackageImpl#getScalar()
         * @generated
         */
        EClass SCALAR = eINSTANCE.getScalar();

        /**
         * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EAttribute SCALAR__VALUE = eINSTANCE.getScalar_Value();

        /**
         * The meta object literal for the '<em><b>Value Exp</b></em>' containment reference feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference SCALAR__VALUE_EXP = eINSTANCE.getScalar_ValueExp();

        /**
         * The meta object literal for the '{@link timing.impl.ArrayImpl <em>Array</em>}' class.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @see timing.impl.ArrayImpl
         * @see timing.impl.TimingPackageImpl#getArray()
         * @generated
         */
        EClass ARRAY = eINSTANCE.getArray();

        /**
         * The meta object literal for the '<em><b>Values</b></em>' attribute list feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EAttribute ARRAY__VALUES = eINSTANCE.getArray_Values();

        /**
         * The meta object literal for the '<em><b>Values Exp</b></em>' containment reference list feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference ARRAY__VALUES_EXP = eINSTANCE.getArray_ValuesExp();

    }

} //TimingPackage
