/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.graph.jgrapht.ratio;

import java.util.Collection;
import java.util.Set;
import org.eclipse.lsat.common.ludus.backend.datastructures.weights.DoubleWeightFunctionDouble;
import org.eclipse.lsat.common.ludus.backend.games.ratio.solvers.energy.RatioGameEnergy;
import org.eclipse.lsat.common.ludus.backend.games.ratio.solvers.policy.RatioGamePolicyIteration;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.JGraphTEdge;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.JGraphTGraph;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.JGraphTVertex;

public class RGDoubleImplJGraphT
implements RatioGamePolicyIteration<JGraphTVertex, JGraphTEdge, Double>,
RatioGameEnergy<JGraphTVertex, JGraphTEdge, Double> {
    private static final long serialVersionUID = 1L;
    private final JGraphTGraph graph;
    private final DoubleWeightFunctionDouble<JGraphTEdge> edgeWeights;

    public RGDoubleImplJGraphT(JGraphTGraph graph, DoubleWeightFunctionDouble<JGraphTEdge> edgeWeights) {
        this.graph = graph;
        this.edgeWeights = edgeWeights;
        if (edgeWeights.getMin1Value() < 0.0) {
            throw new IllegalStateException("Edge weights for nominator must be positive");
        }
        if (edgeWeights.getMin2Value() < 0.0) {
            throw new IllegalStateException("Edge weights for denominator must be positive");
        }
    }

    public JGraphTGraph getGraph() {
        return this.graph;
    }

    public DoubleWeightFunctionDouble getEdgeWeights() {
        return this.edgeWeights;
    }

    @Override
    public Integer getId(JGraphTVertex vertex) {
        return vertex.getId();
    }

    @Override
    public Set<JGraphTVertex> getV0() {
        return this.graph.getV0();
    }

    @Override
    public Set<JGraphTVertex> getV1() {
        return this.graph.getV1();
    }

    @Override
    public Set<JGraphTVertex> getVertices() {
        return this.graph.getVertices();
    }

    @Override
    public Set<JGraphTEdge> getEdges() {
        return this.graph.getEdges();
    }

    @Override
    public Collection<JGraphTEdge> incomingEdgesOf(JGraphTVertex v) {
        return this.graph.incomingEdgesOf(v);
    }

    @Override
    public Collection<JGraphTEdge> outgoingEdgesOf(JGraphTVertex v) {
        return this.graph.outgoingEdgesOf(v);
    }

    @Override
    public JGraphTVertex getEdgeSource(JGraphTEdge e) {
        return this.graph.getEdgeSource(e);
    }

    @Override
    public JGraphTVertex getEdgeTarget(JGraphTEdge e) {
        return this.graph.getEdgeTarget(e);
    }

    @Override
    public JGraphTEdge getEdge(JGraphTVertex source, JGraphTVertex target) {
        return this.graph.getEdge(source, target);
    }

    @Override
    public Double getWeight1(JGraphTEdge edge) {
        return this.edgeWeights.getWeight1((Object)edge);
    }

    @Override
    public Double getWeight2(JGraphTEdge edge) {
        return this.edgeWeights.getWeight2((Object)edge);
    }

    @Override
    public Double getMaxAbsValue() {
        return this.edgeWeights.getMaxAbsValue();
    }

    public RGDoubleImplJGraphT getSubGraph(Set<JGraphTVertex> vertexSubset) {
        JGraphTGraph subGraph = this.graph.getSubgraph(vertexSubset);
        return new RGDoubleImplJGraphT(subGraph, this.edgeWeights);
    }

    public RGDoubleImplJGraphT getSwappedSubGraph(Set<JGraphTVertex> vertexSubset) {
        JGraphTGraph subGraph = this.graph.getSwappedSubgraph(vertexSubset);
        return new RGDoubleImplJGraphT(subGraph, this.edgeWeights);
    }

    public RGDoubleImplJGraphT getSubGraphEdges(Set<JGraphTEdge> edgeSubset) {
        JGraphTGraph subGraph = this.graph.getSubgraphRestrictEdges(edgeSubset);
        return new RGDoubleImplJGraphT(subGraph, this.edgeWeights);
    }

    private RGDoubleImplJGraphT truncate(RGDoubleImplJGraphT game, Double epsilon) {
        DoubleWeightFunctionDouble<JGraphTEdge> w = new DoubleWeightFunctionDouble<JGraphTEdge>();
        for (JGraphTEdge e : game.getEdges()) {
            Double w1 = Math.floor(game.getWeight1(e) * (1.0 / epsilon)) / (1.0 / epsilon);
            Double w2 = Math.floor(game.getWeight2(e) * (1.0 / epsilon)) / (1.0 / epsilon);
            w.addWeight(e, w1, w2);
        }
        return new RGDoubleImplJGraphT(game.getGraph(), w);
    }
}

