/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.algorithms;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.lsat.common.ludus.api.MatrixDependencies;
import org.eclipse.lsat.common.ludus.backend.algebra.Matrix;
import org.eclipse.lsat.common.ludus.backend.algebra.Value;
import org.eclipse.lsat.common.ludus.backend.algorithms.SimpleCyclesResourceCheckException;
import org.eclipse.lsat.common.ludus.backend.algorithms.SimpleCyclesResourceCheckResult;
import org.eclipse.lsat.common.ludus.backend.datastructures.tuple.Tuple;
import org.eclipse.lsat.common.ludus.backend.fsm.FSM;
import org.eclipse.lsat.common.ludus.backend.fsm.impl.Edge;
import org.eclipse.lsat.common.ludus.backend.fsm.impl.Location;

public class SimpleCyclesResourceCheck {
    private FSM<Location, Edge> fsm;
    private Map<String, Matrix> matrices;
    private Set<Integer> usedResources = new HashSet<Integer>();
    private Set<Location> marked;
    private ArrayDeque<Location> markedStack;
    private ArrayDeque<Location> pointStack;
    private Map<Location, Integer> vToI;
    private Map<Location, Set<Location>> removed;

    /*
     * Unable to fully structure code
     */
    public SimpleCyclesResourceCheckResult check(FSM<Location, Edge> finiteStateMachine, Map<String, Matrix> matrixMap) {
        this.matrices = matrixMap;
        this.fsm = finiteStateMachine;
        for (Edge e : finiteStateMachine.getEdges()) {
            this.usedResources.addAll(MatrixDependencies.getUsedResources(this.matrices.get(e.getEvent())));
        }
        this.initState();
        for (Location start : this.fsm.getVertices()) {
            try {
                this.backtrack(start, start);
                if (true) ** GOTO lbl19
            }
            catch (SimpleCyclesResourceCheckException e) {
                this.clearState();
                return new SimpleCyclesResourceCheckResult(e.getSimpleCycle(), e.getMissingClaimPairs());
            }
            do {
                this.marked.remove(this.markedStack.pop());
lbl19:
                // 2 sources

            } while (!this.markedStack.isEmpty());
        }
        this.clearState();
        return new SimpleCyclesResourceCheckResult();
    }

    private boolean backtrack(Location start, Location vertex) throws SimpleCyclesResourceCheckException {
        boolean foundCycle = false;
        this.pointStack.push(vertex);
        this.marked.add(vertex);
        this.markedStack.push(vertex);
        for (Edge currentEdge : this.fsm.outgoingEdgesOf(vertex)) {
            Location currentVertex = (Location)this.fsm.getEdgeTarget(currentEdge);
            if (this.getRemoved(vertex).contains(currentVertex)) continue;
            int comparison = this.toI(currentVertex).compareTo(this.toI(start));
            if (comparison < 0) {
                this.getRemoved(vertex).add(currentVertex);
                continue;
            }
            if (comparison == 0) {
                foundCycle = true;
                ArrayList<Location> cycle = new ArrayList<Location>();
                Iterator<Location> it = this.pointStack.descendingIterator();
                while (it.hasNext()) {
                    Location v = it.next();
                    if (start.equals(v)) break;
                }
                cycle.add(start);
                while (it.hasNext()) {
                    cycle.add(it.next());
                }
                List<Tuple<Integer, Integer>> checkResult = this.checkSimpleCycle(cycle);
                if (checkResult.isEmpty()) continue;
                throw new SimpleCyclesResourceCheckException(cycle, checkResult);
            }
            if (this.marked.contains(currentVertex)) continue;
            boolean gotCycle = this.backtrack(start, currentVertex);
            boolean bl = foundCycle = foundCycle || gotCycle;
        }
        if (foundCycle) {
            while (!this.markedStack.peek().equals(vertex)) {
                this.marked.remove(this.markedStack.pop());
            }
            this.marked.remove(this.markedStack.pop());
        }
        this.pointStack.pop();
        return foundCycle;
    }

    private void initState() {
        this.marked = new HashSet<Location>();
        this.markedStack = new ArrayDeque();
        this.pointStack = new ArrayDeque();
        this.vToI = new HashMap<Location, Integer>();
        this.removed = new HashMap<Location, Set<Location>>();
        int index = 0;
        for (Location v : this.fsm.getVertices()) {
            this.vToI.put(v, index++);
        }
    }

    private void clearState() {
        this.marked = null;
        this.markedStack = null;
        this.pointStack = null;
        this.vToI = null;
    }

    private Integer toI(Location v) {
        return this.vToI.get(v);
    }

    private Set<Location> getRemoved(Location v) {
        return this.removed.computeIfAbsent(v, k -> new HashSet());
    }

    private List<Tuple<Integer, Integer>> checkSimpleCycle(List<Location> cycle) {
        int resCount = this.matrices.values().iterator().next().getRows();
        boolean[][] connections = new boolean[resCount][resCount];
        int i = 0;
        while (i < cycle.size()) {
            Edge edge = (Edge)this.fsm.getEdge(cycle.get(i), cycle.get((i + 1) % cycle.size()));
            Matrix matrix = this.matrices.get(this.fsm.getEvent(edge));
            int k = 0;
            while (k < resCount) {
                int l = 0;
                while (l < resCount) {
                    if (!connections[k][l] && !matrix.get(k, l).equals(Value.NEGATIVE_INFINITY)) {
                        connections[k][l] = true;
                    }
                    ++l;
                }
                ++k;
            }
            ++i;
        }
        int k = 0;
        while (k < resCount) {
            int i2 = 0;
            while (i2 < resCount) {
                int j = 0;
                while (j < resCount) {
                    connections[i2][j] = connections[i2][j] || connections[i2][k] && connections[k][j];
                    ++j;
                }
                ++i2;
            }
            ++k;
        }
        LinkedList<Tuple<Integer, Integer>> missing = new LinkedList<Tuple<Integer, Integer>>();
        int k2 = 0;
        while (k2 < resCount) {
            int l = 0;
            while (l < resCount) {
                if (this.usedResources.contains(k2) && this.usedResources.contains(l) && !connections[k2][l]) {
                    missing.add(Tuple.of(k2, l));
                }
                ++l;
            }
            ++k2;
        }
        return missing;
    }
}

