/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.scheduler;

import distributions.CalculationMode;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lsat_graph.Bounds;
import lsat_graph.StochasticAnnotation;
import lsat_graph.lsat_graphFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.lsat.common.scheduler.algorithm.BellmanFordScheduler;
import org.eclipse.lsat.common.scheduler.graph.Task;
import org.eclipse.lsat.common.scheduler.graph.TaskDependencyGraph;
import org.eclipse.lsat.common.scheduler.schedule.Schedule;
import org.eclipse.lsat.common.scheduler.schedule.ScheduledTask;
import org.eclipse.lsat.scheduler.AddExecutionTimes;
import org.eclipse.lsat.scheduler.CollectedScheduleData;
import org.eclipse.lsat.scheduler.CriticalPathAnalysis;
import org.eclipse.lsat.scheduler.RealDistributionLibrary;
import org.eclipse.lsat.scheduler.ScheduleStatistics;
import org.eclipse.lsat.timing.calculator.MotionCalculatorExtension;
import org.eclipse.lsat.timing.util.ITimingCalculator;
import org.eclipse.lsat.timing.util.TimingCalculator;
import org.eclipse.m2m.qvt.oml.util.Dictionary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import setting.Settings;

public class StochasticImpactAnalysis<T extends Task> {
    private static final int SCALE_CRITICALITY = 1;
    private static final Logger LOGGER = LoggerFactory.getLogger(StochasticImpactAnalysis.class);
    private final lsat_graphFactory graphFactory = lsat_graphFactory.eINSTANCE;
    private final TaskDependencyGraph<T> orgGraph;
    private final Settings settings;
    private final int sampleLength;

    public StochasticImpactAnalysis(TaskDependencyGraph<T> graph, Settings settings, int sampleLength) {
        this.orgGraph = graph;
        this.settings = settings;
        this.sampleLength = sampleLength;
    }

    public Schedule<T> transformModel(String name, HashMap<T, CollectedScheduleData> collectedData, IProgressMonitor monitor) throws Exception {
        LOGGER.debug("Starting stochastic analysis");
        MotionCalculatorExtension motionCalculator = MotionCalculatorExtension.getSelectedMotionCalculator();
        TimingCalculator timingCalculator = new TimingCalculator(this.settings, motionCalculator, CalculationMode.DISTRIBUTED);
        AddExecutionTimes addExecutionTimes = new AddExecutionTimes((ITimingCalculator)timingCalculator);
        BellmanFordScheduler scheduler = new BellmanFordScheduler();
        CriticalPathAnalysis criticalPathAnalysis = new CriticalPathAnalysis();
        EList scheduledTasks = this.orgGraph.allNodesInTopologicalOrder();
        collectedData.clear();
        collectedData.putAll(scheduledTasks.stream().collect(Collectors.toMap(t -> t, t -> new CollectedScheduleData(this.sampleLength), (a, b) -> a, LinkedHashMap::new)));
        int sample = 0;
        while (sample < this.sampleLength) {
            if (monitor.isCanceled()) {
                return null;
            }
            TaskDependencyGraph<T> graph = addExecutionTimes.transformModel(this.orgGraph);
            Schedule schedule = scheduler.createSchedule(graph);
            schedule.setName(name);
            Map<Task, ScheduledTask> nodeMap = schedule.getNodes().stream().collect(Collectors.toMap(ScheduledTask::getTask, st -> st));
            criticalPathAnalysis.transformModel(schedule, monitor);
            for (Map.Entry<T, CollectedScheduleData> entry : collectedData.entrySet()) {
                Task node = (Task)entry.getKey();
                CollectedScheduleData collect = entry.getValue();
                ScheduledTask scheduledTask = nodeMap.get(node);
                collect.critical[sample] = StochasticImpactAnalysis.isCritical(scheduledTask) ? 1 : 0;
                collect.startTime[sample] = scheduledTask.getStartTime().doubleValue();
                collect.duration[sample] = scheduledTask.getDuration().doubleValue();
            }
            ++sample;
        }
        Schedule<T> result = this.createFinalSchedule(name, this.orgGraph, collectedData);
        LOGGER.debug("Finished stochastic analysis");
        return result;
    }

    private static <T extends Task> boolean isCritical(ScheduledTask<T> scheduledTask) {
        return scheduledTask.getAspects().stream().anyMatch(a -> a.getName().equals("Critical"));
    }

    public Schedule<T> createFinalSchedule(String name, TaskDependencyGraph<T> graph, Map<T, CollectedScheduleData> collectedData) throws Exception {
        BellmanFordScheduler scheduler = new BellmanFordScheduler();
        Schedule schedule = scheduler.createSchedule(graph);
        schedule.setName(name);
        for (Map.Entry<T, CollectedScheduleData> entry : collectedData.entrySet()) {
            Task node = (Task)entry.getKey();
            CollectedScheduleData collect = entry.getValue();
            ScheduledTask scheduledTask = schedule.getNodes().stream().filter(st -> st.getTask() == node).findFirst().get();
            ScheduleStatistics stat = new ScheduleStatistics(collect);
            double startTimeMean = stat.startTime.getMean();
            scheduledTask.setStartTime(StochasticImpactAnalysis.bd(startTimeMean, scheduledTask.getStartTime().scale()));
            scheduledTask.setEndTime(StochasticImpactAnalysis.bd(startTimeMean + stat.duration.getMean(), scheduledTask.getEndTime().scale()));
            this.addStochasticAnnotation(scheduledTask, stat, scheduledTask.getStartTime().scale());
        }
        return schedule;
    }

    private void addStochasticAnnotation(ScheduledTask<T> at, ScheduleStatistics stat, int scale) {
        RealDistributionLibrary realDist = new RealDistributionLibrary();
        double criticalPathCounter = stat.critical.getSum();
        long sampleLength = stat.critical.getN();
        Dictionary<String, BigDecimal> bounds = realDist.betaDistributionInverseCumulativeProbability(BigDecimal.valueOf(criticalPathCounter + 0.5), BigDecimal.valueOf((double)sampleLength - criticalPathCounter + 0.5));
        Bounds confidenceInterval = this.graphFactory.createBounds();
        confidenceInterval.setLower((BigDecimal)bounds.get((Object)"lower"));
        confidenceInterval.setUpper((BigDecimal)bounds.get((Object)"upper"));
        StochasticAnnotation ann = this.graphFactory.createStochasticAnnotation();
        ann.setName("stochasticSensitivity");
        ann.setCriticality(StochasticImpactAnalysis.bd(criticalPathCounter / (double)sampleLength, 1));
        ann.setMean(StochasticImpactAnalysis.bd(stat.startTime.getMean(), scale));
        ann.setMin(StochasticImpactAnalysis.bd(stat.startTime.getMin(), scale));
        ann.setMax(StochasticImpactAnalysis.bd(stat.startTime.getMax(), scale));
        double skewness = stat.startTime.getSkewness();
        if (!Double.valueOf(skewness).equals(Double.NaN)) {
            ann.setSkewness(StochasticImpactAnalysis.bd(stat.startTime.getSkewness(), scale));
        }
        ann.setStandardDeviation(StochasticImpactAnalysis.bd(stat.startTime.getStandardDeviation(), scale));
        ann.setConfidenceInterval(confidenceInterval);
        ann.getNodes().add(at);
        ((Schedule)at.getGraph()).getAspects().add((Object)ann);
    }

    private static BigDecimal bd(double d, int scale) {
        return BigDecimal.valueOf(d).setScale(scale, RoundingMode.HALF_UP);
    }
}

