/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.external.api;

import activity.Action;
import activity.ActivitySet;
import activity.ResourceAction;
import activity.SimpleAction;
import activity.TracePoint;
import common.HasName;
import dispatching.ActivityDispatching;
import dispatching.Attribute;
import expressions.Declaration;
import expressions.Expression;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lsat_graph.ActionTask;
import lsat_graph.ClaimTask;
import lsat_graph.ClaimedByScheduledTask;
import lsat_graph.DispatchGraph;
import lsat_graph.PeripheralResource;
import lsat_graph.ReleaseTask;
import machine.BidirectionalPath;
import machine.Distance;
import machine.FullMeshPath;
import machine.IResource;
import machine.Machine;
import machine.PathTargetReference;
import machine.Position;
import machine.ResourceItem;
import machine.SymbolicPosition;
import machine.UnidirectionalPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.lsat.common.graph.directed.Aspect;
import org.eclipse.lsat.common.graph.directed.editable.Edge;
import org.eclipse.lsat.common.graph.directed.editable.Node;
import org.eclipse.lsat.common.scheduler.graph.TaskDependencyGraph;
import org.eclipse.lsat.common.scheduler.graph.util.ResampleTimeStepData;
import org.eclipse.lsat.common.scheduler.schedule.ScheduledDependency;
import org.eclipse.lsat.common.scheduler.schedule.ScheduledTask;
import org.eclipse.lsat.external.api.model.ActionBase;
import org.eclipse.lsat.external.api.model.ActionType;
import org.eclipse.lsat.external.api.model.Activity;
import org.eclipse.lsat.external.api.model.ActivityDependency;
import org.eclipse.lsat.external.api.model.ArrayValues;
import org.eclipse.lsat.external.api.model.Axis;
import org.eclipse.lsat.external.api.model.Bounds;
import org.eclipse.lsat.external.api.model.Claim;
import org.eclipse.lsat.external.api.model.Dependency;
import org.eclipse.lsat.external.api.model.Dispatch;
import org.eclipse.lsat.external.api.model.DispatchGroup;
import org.eclipse.lsat.external.api.model.Graph;
import org.eclipse.lsat.external.api.model.LsatData;
import org.eclipse.lsat.external.api.model.MotionSetting;
import org.eclipse.lsat.external.api.model.Move;
import org.eclipse.lsat.external.api.model.Path;
import org.eclipse.lsat.external.api.model.PathType;
import org.eclipse.lsat.external.api.model.Peripheral;
import org.eclipse.lsat.external.api.model.PeripheralAction;
import org.eclipse.lsat.external.api.model.PeripheralType;
import org.eclipse.lsat.external.api.model.PhysicalLocation;
import org.eclipse.lsat.external.api.model.Product;
import org.eclipse.lsat.external.api.model.ProductDefinition;
import org.eclipse.lsat.external.api.model.ProductLifeCycleEventBase;
import org.eclipse.lsat.external.api.model.ProductLifeCycleEventEntry;
import org.eclipse.lsat.external.api.model.ProductLifeCycleEventExit;
import org.eclipse.lsat.external.api.model.ProductLifeCycleEventTransfer;
import org.eclipse.lsat.external.api.model.ProductPropertyBase;
import org.eclipse.lsat.external.api.model.ProductPropertyBoolean;
import org.eclipse.lsat.external.api.model.ProductPropertyDefinition;
import org.eclipse.lsat.external.api.model.ProductPropertyInteger;
import org.eclipse.lsat.external.api.model.ProductPropertyString;
import org.eclipse.lsat.external.api.model.ProductType;
import org.eclipse.lsat.external.api.model.Profile;
import org.eclipse.lsat.external.api.model.RaiseEvent;
import org.eclipse.lsat.external.api.model.Release;
import org.eclipse.lsat.external.api.model.RequireEvent;
import org.eclipse.lsat.external.api.model.Resource;
import org.eclipse.lsat.external.api.model.ResourceType;
import org.eclipse.lsat.external.api.model.ScalarValue;
import org.eclipse.lsat.external.api.model.Schedule;
import org.eclipse.lsat.external.api.model.SchedulingType;
import org.eclipse.lsat.external.api.model.Sequence;
import org.eclipse.lsat.external.api.model.SetPoint;
import org.eclipse.lsat.external.api.model.StochasticAnnotation;
import org.eclipse.lsat.external.api.model.StochasticMeasurements;
import org.eclipse.lsat.external.api.model.StochasticProperties;
import org.eclipse.lsat.external.api.model.SyncBar;
import org.eclipse.lsat.external.api.model.Task;
import org.eclipse.lsat.external.api.model.TaskAnnotationBoolean;
import org.eclipse.lsat.external.api.model.TaskAnnotationString;
import org.eclipse.lsat.external.api.model.TaskAttributesValue;
import org.eclipse.lsat.external.api.model.TaskType;
import org.eclipse.lsat.product.productdata.EntryEvent;
import org.eclipse.lsat.product.productdata.ExitEvent;
import org.eclipse.lsat.product.productdata.LifeCycleEvent;
import org.eclipse.lsat.product.productdata.ProductInstance;
import org.eclipse.lsat.product.productdata.ProductProperty;
import org.eclipse.lsat.product.productdata.TransferEvent;
import org.eclipse.lsat.scheduler.CollectedScheduleData;
import product.PropertyDefinition;
import product.ValueType;
import setting.MotionProfileSettings;
import setting.MotionSettings;
import setting.PhysicalSettings;
import setting.Settings;
import timing.Array;
import timing.Scalar;
import timing.Timing;

public class ConvertToOpenApiSchemas {
    private Map<dispatching.Dispatch, String> dispatchToId;
    private Map<org.eclipse.lsat.common.scheduler.graph.Task, String> taskToId;
    private Map<ScheduledTask<org.eclipse.lsat.common.scheduler.graph.Task>, String> scheduledTaskToId;
    private int uniqueId = 0;
    private double executionDataSampleFrequency;

    public ConvertToOpenApiSchemas(double sampleFrequency) {
        this.executionDataSampleFrequency = sampleFrequency;
        this.dispatchToId = new HashMap<dispatching.Dispatch, String>();
        this.taskToId = new HashMap<org.eclipse.lsat.common.scheduler.graph.Task, String>();
        this.scheduledTaskToId = new HashMap<ScheduledTask<org.eclipse.lsat.common.scheduler.graph.Task>, String>();
    }

    public LsatData convert(Machine machine, Settings settings, ActivitySet activitySet, ActivityDispatching dispatching, TaskDependencyGraph<org.eclipse.lsat.common.scheduler.graph.Task> graph, org.eclipse.lsat.common.scheduler.schedule.Schedule<org.eclipse.lsat.common.scheduler.graph.Task> schedule, HashMap<org.eclipse.lsat.common.scheduler.graph.Task, CollectedScheduleData> collectedData, List<ProductInstance> productData) {
        Set<IResource> allResources = activitySet.getActivities().stream().flatMap(act -> act.getNodes().stream()).filter(node -> node instanceof ResourceAction).map(node -> ((ResourceAction)node).getResource()).filter(Objects::nonNull).collect(Collectors.toSet());
        LsatData exportLsatData = new LsatData();
        this.convertProductDefinitions((Collection<product.ProductDefinition>)machine.getProductDefinitions(), exportLsatData);
        this.convertPeripheralTypes((Collection<machine.PeripheralType>)machine.getPeripheralTypes(), exportLsatData);
        this.convertResources(allResources, settings, exportLsatData);
        this.convertSettings(settings, exportLsatData);
        this.convertActivitySet(activitySet, exportLsatData);
        this.convertDispatching(dispatching, exportLsatData);
        this.convertSchedule(schedule, collectedData, exportLsatData);
        this.convertGraph(graph, exportLsatData);
        if (productData != null) {
            this.convertProductData(productData, exportLsatData);
        }
        return exportLsatData;
    }

    private void convertProductDefinitions(Collection<product.ProductDefinition> productDefinitions, LsatData exportLsatData) {
        for (product.ProductDefinition productDefinition : productDefinitions) {
            ProductDefinition exportProductDefinition = new ProductDefinition();
            exportProductDefinition.setName(productDefinition.getName());
            for (PropertyDefinition productProperty : productDefinition.getPropertyDefinitions()) {
                ProductPropertyDefinition exportProductProperty = new ProductPropertyDefinition();
                exportProductProperty.setName(productProperty.getName());
                if (productProperty.getValueType() == ValueType.BOOLEAN) {
                    exportProductProperty.setType(ProductType.BOOLEAN);
                } else if (productProperty.getValueType() == ValueType.INTEGER) {
                    exportProductProperty.setType(ProductType.INTEGER);
                } else if (productProperty.getValueType() == ValueType.STRING) {
                    exportProductProperty.setType(ProductType.STRING);
                }
                exportProductDefinition.addPropertiesItem(exportProductProperty);
            }
            exportLsatData.putProductDefinitionsItem(productDefinition.getName(), exportProductDefinition);
        }
    }

    private void convertPeripheralTypes(Collection<machine.PeripheralType> peripheralTypes, LsatData exportLsatData) {
        List sortedPeripheralTypes = peripheralTypes.stream().sorted(Comparator.comparing(HasName::getName)).collect(Collectors.toList());
        for (machine.PeripheralType peripheralType : sortedPeripheralTypes) {
            PeripheralType exportPeripheralType = new PeripheralType();
            exportPeripheralType.setName(peripheralType.getName());
            for (machine.Axis axis : peripheralType.getAxes()) {
                Axis exportAxis = new Axis();
                exportAxis.setUnit(axis.getUnit());
                for (machine.SetPoint setpoint : axis.getSetPoints()) {
                    exportAxis.addSetPointItem(setpoint.getName());
                }
                exportPeripheralType.putAxesItem(axis.getName(), exportAxis);
            }
            for (machine.SetPoint setpoint : peripheralType.getSetPoints()) {
                SetPoint exportSetpoint = new SetPoint();
                exportSetpoint.setUnit(setpoint.getUnit());
                for (machine.Axis axis : setpoint.getAxes()) {
                    exportSetpoint.addAxesItem(axis.getName());
                }
                exportPeripheralType.putSetPointsItem(setpoint.getName(), exportSetpoint);
            }
            for (machine.ActionType action : peripheralType.getActions()) {
                ActionType exportAction = new ActionType();
                exportAction.setName(action.getName());
                exportPeripheralType.addActionsItem(exportAction);
            }
            exportLsatData.putPeripheralTypesItem(peripheralType.getName(), exportPeripheralType);
        }
    }

    private void convertResources(Collection<IResource> iresources, Settings settings, LsatData exportLsatData) {
        List sortedResources = iresources.stream().sorted(Comparator.comparing(ConvertToOpenApiSchemas::getResourceName)).collect(Collectors.toList());
        for (IResource iresource : sortedResources) {
            machine.Resource resource = null;
            if (iresource instanceof ResourceItem) {
                ResourceItem r = (ResourceItem)iresource;
                resource = r.getResource();
            } else if (iresource instanceof machine.Resource) {
                machine.Resource r;
                resource = r = (machine.Resource)iresource;
            }
            String name = ConvertToOpenApiSchemas.getResourceName(iresource);
            Resource exportResource = new Resource();
            exportResource.setName(name);
            for (machine.Peripheral peripheral : resource.getPeripherals()) {
                PhysicalSettings physicalSettings = settings.getPhysicalSettings(iresource, peripheral);
                this.convert(iresource, peripheral, physicalSettings, exportLsatData);
                exportResource.addPeripheralIdsItem(ConvertToOpenApiSchemas.getPeripheralFqn(iresource, peripheral));
            }
            switch (resource.getResourceType()) {
                case EVENT: {
                    exportResource.setResourceType(ResourceType.EVENT);
                    break;
                }
                case PASSIVE: {
                    exportResource.setResourceType(ResourceType.PASSIVE);
                    break;
                }
                case REGULAR: {
                    exportResource.setResourceType(ResourceType.REGULAR);
                }
            }
            exportLsatData.putResourcesItem(name, exportResource);
        }
    }

    private void convert(IResource iResource, machine.Peripheral peripheral, PhysicalSettings physicalSettings, LsatData exportLsatData) {
        FullMeshPath mPath;
        UnidirectionalPath uPath;
        Peripheral exportPeripheral = new Peripheral();
        exportPeripheral.setName(peripheral.getName());
        exportPeripheral.setResourceId(ConvertToOpenApiSchemas.getResourceName(iResource));
        exportPeripheral.setPeripheralTypeId(peripheral.getType().getName());
        for (machine.Profile profile : peripheral.getProfiles()) {
            exportPeripheral.addProfilesItem(profile.getName());
        }
        EList axes = peripheral.getType().getAxes();
        List sortedAxes = axes.stream().sorted(Comparator.comparing(HasName::getName)).collect(Collectors.toList());
        for (SymbolicPosition symbolicPos : peripheral.getPositions()) {
            LinkedHashMap<String, Double> positionPerAxis = new LinkedHashMap<String, Double>();
            for (machine.Axis axis : sortedAxes) {
                BigDecimal value = ((setting.PhysicalLocation)((MotionSettings)physicalSettings.getMotionSettings().get((Object)axis)).getLocationSettings().get((Object)symbolicPos.getPosition(axis))).getDefault();
                positionPerAxis.put(axis.getName(), value.doubleValue());
            }
            exportPeripheral.putPositionsItem(symbolicPos.getName(), positionPerAxis);
        }
        for (machine.Path path : peripheral.getPaths()) {
            Path exportPath = new Path();
            if (path instanceof UnidirectionalPath) {
                uPath = (UnidirectionalPath)path;
                exportPath.setPathType(PathType.UNI_DIRECTIONAL);
                exportPath.addPointsItem(uPath.getSource().getName());
                exportPath.addPointsItem(uPath.getTarget().getName());
            } else if (path instanceof BidirectionalPath) {
                BidirectionalPath bPath = (BidirectionalPath)path;
                exportPath.setPathType(PathType.BI_DIRECTIONAL);
                for (PathTargetReference point : bPath.getEndPoints()) {
                    exportPath.addPointsItem(point.getName());
                }
            } else if (path instanceof FullMeshPath) {
                mPath = (FullMeshPath)path;
                exportPath.setPathType(PathType.FULL_MESH);
                for (PathTargetReference point : mPath.getEndPoints()) {
                    exportPath.addPointsItem(point.getName());
                }
            }
            for (machine.Profile profile : path.getProfiles()) {
                exportPath.addProfilesItem(profile.getName());
            }
            exportPeripheral.addPathsItem(exportPath);
        }
        for (Map.Entry timingEntry : physicalSettings.getTimingSettings()) {
            uPath = (Timing)timingEntry.getValue();
            if (uPath instanceof Scalar) {
                Scalar scalar = (Scalar)uPath;
                ScalarValue exportValue = new ScalarValue();
                exportValue.setType("Scalar");
                exportValue.setValue(scalar.getValue().doubleValue());
                exportPeripheral.putTimingSettingsItem(((machine.ActionType)timingEntry.getKey()).getName(), exportValue);
                continue;
            }
            mPath = (Timing)timingEntry.getValue();
            if (!(mPath instanceof Array)) continue;
            Array array = (Array)mPath;
            ArrayValues exportValues = new ArrayValues();
            exportValues.setType("Array");
            for (BigDecimal value : array.getValues()) {
                exportValues.addValuesItem(value.doubleValue());
            }
            exportPeripheral.putTimingSettingsItem(((machine.ActionType)timingEntry.getKey()).getName(), exportValues);
        }
        for (Map.Entry settingEntry : physicalSettings.getMotionSettings()) {
            machine.Axis axis = (machine.Axis)settingEntry.getKey();
            MotionSettings motionSettings = (MotionSettings)settingEntry.getValue();
            MotionSetting exportMotionSettings = new MotionSetting();
            for (Map.Entry locationEntry : motionSettings.getLocationSettings()) {
                setting.PhysicalLocation physicalLocation = (setting.PhysicalLocation)locationEntry.getValue();
                PhysicalLocation exportPhysicalLocation = new PhysicalLocation();
                BigDecimal value = physicalLocation.getDefault();
                BigDecimal minValue = physicalLocation.getMin();
                BigDecimal maxValue = physicalLocation.getMax();
                exportPhysicalLocation.setValue(value.doubleValue());
                if (minValue != null) {
                    exportPhysicalLocation.setMin(minValue.doubleValue());
                }
                if (maxValue != null) {
                    exportPhysicalLocation.setMax(maxValue.doubleValue());
                }
                exportMotionSettings.putLocationsItem(((Position)locationEntry.getKey()).getName(), exportPhysicalLocation);
            }
            for (Map.Entry profileEntry : motionSettings.getProfileSettings()) {
                MotionProfileSettings profileSetting = (MotionProfileSettings)profileEntry.getValue();
                Profile exportProfile = new Profile();
                for (Map.Entry argEntry : profileSetting.getMotionArguments()) {
                    String argName = (String)argEntry.getKey();
                    double argValue = ((Expression)argEntry.getValue()).evaluate().doubleValue();
                    exportProfile.putMotionArgumentsItem(argName, argValue);
                }
                exportMotionSettings.putProfilesItem(((machine.Profile)profileEntry.getKey()).getName(), exportProfile);
            }
            for (Map.Entry distanceEntry : motionSettings.getDistanceSettings()) {
                double value = ((Expression)distanceEntry.getValue()).evaluate().doubleValue();
                exportMotionSettings.putDistancesItem(((Distance)distanceEntry.getKey()).getName(), value);
            }
            exportPeripheral.putMotionSettingsItem(axis.getName(), exportMotionSettings);
        }
        for (Distance distance : peripheral.getDistances()) {
            exportPeripheral.addDistancesItem(distance.getName());
        }
        exportLsatData.putPeripheralsItem(ConvertToOpenApiSchemas.getPeripheralFqn(iResource, peripheral), exportPeripheral);
    }

    private void convertSettings(Settings setting, LsatData exportLsatData) {
        List sortedDeclarations = setting.getDeclarations().stream().sorted(Comparator.comparing(Declaration::getName)).collect(Collectors.toList());
        for (Declaration decl : sortedDeclarations) {
            double value = decl.getExpression().evaluate().doubleValue();
            exportLsatData.putDeclarationsItem(decl.getName(), value);
        }
    }

    private void convertActivitySet(ActivitySet activitySet, LsatData exportLsatData) {
        for (activity.Activity activity : activitySet.getActivities()) {
            Activity exportActivity = new Activity();
            exportActivity.setName(activity.getName());
            ArrayList<Node> sortedActions = new ArrayList<Node>((Collection<Node>)activity.getNodes());
            sortedActions.sort(Comparator.comparing(n -> n instanceof activity.SyncBar).thenComparing(a -> a instanceof activity.SyncBar ? a.getName() : null, Comparator.nullsFirst(String::compareTo)));
            for (Node action : sortedActions) {
                if (action instanceof activity.Claim) {
                    activity.Claim claim = (activity.Claim)action;
                    Claim exportClaim = this.createExportAction(Claim.class, action);
                    exportClaim.setName(claim.getName());
                    exportClaim.setPassive(claim.isPassive());
                    exportClaim.setResourceId(ConvertToOpenApiSchemas.getResourceName(claim.getResource()));
                    exportActivity.putActionsItem(claim.getName(), exportClaim);
                    continue;
                }
                if (action instanceof activity.Release) {
                    activity.Release release = (activity.Release)action;
                    Release exportRelease = this.createExportAction(Release.class, action);
                    exportRelease.setName(release.getName());
                    exportRelease.setResourceId(ConvertToOpenApiSchemas.getResourceName(release.getResource()));
                    exportActivity.putActionsItem(release.getName(), exportRelease);
                    continue;
                }
                if (action instanceof activity.Move) {
                    Distance distance;
                    SymbolicPosition targetPosition;
                    activity.Move move = (activity.Move)action;
                    Move exportMove = this.createExportAction(Move.class, action);
                    exportMove.setName(move.getName());
                    if (move.getSchedulingType() == activity.SchedulingType.ASAP) {
                        exportMove.setSchedulingType(SchedulingType.ASAP);
                    }
                    if (move.getSchedulingType() == activity.SchedulingType.ALAP) {
                        exportMove.setSchedulingType(SchedulingType.ALAP);
                    }
                    exportMove.setProfile(move.getProfile().getName());
                    SymbolicPosition sourcePosition = move.getSourcePosition();
                    if (sourcePosition != null) {
                        for (Map.Entry positionEntry : sourcePosition.getAxisPosition()) {
                            exportMove.putSourcePositionItem(((machine.Axis)positionEntry.getKey()).getName(), ((Position)positionEntry.getValue()).getName());
                        }
                    }
                    if ((targetPosition = move.getTargetPosition()) != null) {
                        for (Map.Entry positionEntry : targetPosition.getAxisPosition()) {
                            exportMove.putTargetPositionItem(((machine.Axis)positionEntry.getKey()).getName(), ((Position)positionEntry.getValue()).getName());
                        }
                    }
                    if ((distance = move.getDistance()) != null) {
                        exportMove.setDistance(distance.getName());
                    }
                    exportMove.setStopAtTarget(move.isStopAtTarget());
                    exportMove.setPositionMove(move.isPositionMove());
                    exportMove.setResourceId(ConvertToOpenApiSchemas.getResourceName(move.getResource()));
                    exportMove.setPeripheralId(ConvertToOpenApiSchemas.getPeripheralFqn(move.getResource(), move.getPeripheral()));
                    exportActivity.putActionsItem(move.getName(), exportMove);
                    continue;
                }
                if (action instanceof SimpleAction) {
                    SimpleAction simpleAction = (SimpleAction)action;
                    PeripheralAction exportAction = this.createExportAction(PeripheralAction.class, action);
                    exportAction.setName(simpleAction.getName());
                    if (simpleAction.getSchedulingType() == activity.SchedulingType.ASAP) {
                        exportAction.setSchedulingType(SchedulingType.ASAP);
                    }
                    if (simpleAction.getSchedulingType() == activity.SchedulingType.ALAP) {
                        exportAction.setSchedulingType(SchedulingType.ALAP);
                    }
                    exportAction.setActionName(simpleAction.getType().getName());
                    exportAction.setResourceId(ConvertToOpenApiSchemas.getResourceName(simpleAction.getResource()));
                    exportAction.setPeripheralId(ConvertToOpenApiSchemas.getPeripheralFqn(simpleAction.getResource(), simpleAction.getPeripheral()));
                    exportActivity.putActionsItem(simpleAction.getName(), exportAction);
                    continue;
                }
                if (action instanceof activity.RaiseEvent) {
                    activity.RaiseEvent event = (activity.RaiseEvent)action;
                    RaiseEvent exportEvent = this.createExportAction(RaiseEvent.class, action);
                    exportEvent.setName(event.getName());
                    exportEvent.setResourceId(ConvertToOpenApiSchemas.getResourceName(event.getResource()));
                    exportActivity.putActionsItem(event.getName(), exportEvent);
                    continue;
                }
                if (action instanceof activity.RequireEvent) {
                    activity.RequireEvent event = (activity.RequireEvent)action;
                    RequireEvent exportEvent = this.createExportAction(RequireEvent.class, action);
                    exportEvent.setName(event.getName());
                    exportEvent.setResourceId(ConvertToOpenApiSchemas.getResourceName(event.getResource()));
                    exportActivity.putActionsItem(event.getName(), exportEvent);
                    continue;
                }
                if (!(action instanceof activity.SyncBar)) continue;
                activity.SyncBar bar = (activity.SyncBar)action;
                SyncBar exportSyncBar = this.createExportAction(SyncBar.class, action);
                exportSyncBar.setName(bar.getName());
                exportActivity.putActionsItem(bar.getName(), exportSyncBar);
            }
            for (Node action : sortedActions) {
                if (action instanceof activity.Move) {
                    activity.Move move = (activity.Move)action;
                    Move exportMove = (Move)exportActivity.getActions().get(move.getName());
                    if (move.getPredecessorMove() != null) {
                        exportMove.setPredecessorMoveId(move.getPredecessorMove().getName());
                    }
                    if (move.getSuccessorMove() != null) {
                        exportMove.setSuccessorMoveId(move.getSuccessorMove().getName());
                    }
                }
                for (Edge edge : action.getIncomingEdges()) {
                    ActivityDependency exportDependency = new ActivityDependency();
                    exportDependency.setSourceId(edge.getSourceNode().getName());
                    exportDependency.setTargetId(action.getName());
                    exportActivity.addDependenciesItem(exportDependency);
                }
            }
            exportLsatData.putActivitiesItem(activity.getName(), exportActivity);
        }
    }

    private void convertDispatching(ActivityDispatching dispatching, LsatData exportLsatData) {
        for (dispatching.DispatchGroup dispatchGroup : dispatching.getDispatchGroups()) {
            DispatchGroup exportDispatchGroup = new DispatchGroup();
            exportDispatchGroup.setName(dispatchGroup.getName());
            exportDispatchGroup.setOffset(dispatchGroup.getOffset().doubleValue());
            for (dispatching.Dispatch dispatch : dispatchGroup.getDispatches()) {
                String dispatchId = "D" + String.valueOf(this.uniqueId++);
                this.dispatchToId.put(dispatch, dispatchId);
                Dispatch exportDispatch = new Dispatch();
                exportDispatch.setDescription(dispatch.getDescription());
                exportDispatch.setActivityId(dispatch.getActivity().getName());
                for (Map.Entry attr : dispatch.getUserAttributes()) {
                    exportDispatch.putAttributesItem(((Attribute)attr.getKey()).getName(), (String)attr.getValue());
                }
                exportLsatData.putDispatchesItem(dispatchId, exportDispatch);
                exportDispatchGroup.addDispatchIdsItem(dispatchId);
            }
            exportLsatData.putDispatchGroupsItem(dispatchGroup.getName(), exportDispatchGroup);
        }
    }

    private void convertGraph(TaskDependencyGraph<org.eclipse.lsat.common.scheduler.graph.Task> graph, LsatData exportLsatData) {
        Graph exportGraph = new Graph();
        this.convert((Collection<org.eclipse.lsat.common.scheduler.graph.Dependency>)graph.getEdges(), exportGraph);
        exportLsatData.setGraph(exportGraph);
    }

    private void convertSchedule(org.eclipse.lsat.common.scheduler.schedule.Schedule<org.eclipse.lsat.common.scheduler.graph.Task> schedule, HashMap<org.eclipse.lsat.common.scheduler.graph.Task, CollectedScheduleData> collectedData, LsatData exportLsatData) {
        this.convert((Collection<org.eclipse.lsat.common.scheduler.schedule.Sequence<org.eclipse.lsat.common.scheduler.graph.Task>>)schedule.getSequences(), collectedData, exportLsatData);
        Schedule exportSchedule = new Schedule();
        exportSchedule.setName(schedule.getName());
        this.convertSequences((Collection<org.eclipse.lsat.common.scheduler.schedule.Sequence<org.eclipse.lsat.common.scheduler.graph.Task>>)schedule.getSequences(), exportSchedule);
        this.convert((Collection<ScheduledDependency>)schedule.getEdges(), exportSchedule);
        exportLsatData.setSchedule(exportSchedule);
    }

    private void convertProductData(List<ProductInstance> productData, LsatData exportLsatData) {
        for (ProductInstance product : productData) {
            String id = product.getProductID();
            Product exportProduct = new Product();
            for (ProductProperty prop : product.getProperties()) {
                ProductPropertyBase exportProductProperties;
                Object value = prop.getPropertyValue();
                if (value instanceof Boolean) {
                    Boolean boolValue = (Boolean)value;
                    ProductPropertyBoolean exportProductProperties2 = this.createExportProductProperties(ProductPropertyBoolean.class, prop);
                    exportProductProperties2.setValue(boolValue);
                    exportProduct.addPropertiesItem(exportProductProperties2);
                    continue;
                }
                if (value instanceof Integer) {
                    Integer integerValue = (Integer)value;
                    exportProductProperties = this.createExportProductProperties(ProductPropertyInteger.class, prop);
                    ((ProductPropertyInteger)exportProductProperties).setValue(integerValue);
                    exportProduct.addPropertiesItem(exportProductProperties);
                    continue;
                }
                exportProductProperties = this.createExportProductProperties(ProductPropertyString.class, prop);
                ((ProductPropertyString)exportProductProperties).setValue(value.toString());
                exportProduct.addPropertiesItem(exportProductProperties);
            }
            for (LifeCycleEvent lifeCycleEvent : product.getLifeCycle()) {
                if (lifeCycleEvent instanceof EntryEvent) {
                    EntryEvent entryEvent = (EntryEvent)lifeCycleEvent;
                    org.eclipse.lsat.product.productdata.Task entryTask = entryEvent.getEntry().getTask();
                    String entrySlot = entryEvent.getEntry().getSlot();
                    ProductLifeCycleEventEntry exportEvent = this.createExportProductLifeCycleEvent(ProductLifeCycleEventEntry.class);
                    exportEvent.setTaskId(this.scheduledTaskToId.get(entryTask.getScheduledTask()));
                    if (entrySlot != null && !entrySlot.isEmpty()) {
                        exportEvent.setSlot(entrySlot);
                    }
                    exportProduct.addLifeCycleItem(exportEvent);
                    continue;
                }
                if (lifeCycleEvent instanceof ExitEvent) {
                    ExitEvent exitEvent = (ExitEvent)lifeCycleEvent;
                    org.eclipse.lsat.product.productdata.Task exitTask = exitEvent.getExit().getTask();
                    String exitSlot = exitEvent.getExit().getSlot();
                    ProductLifeCycleEventExit exportEvent = this.createExportProductLifeCycleEvent(ProductLifeCycleEventExit.class);
                    exportEvent.setTaskId(this.scheduledTaskToId.get(exitTask.getScheduledTask()));
                    if (exitSlot != null && !exitSlot.isEmpty()) {
                        exportEvent.setSlot(exitSlot);
                    }
                    exportProduct.addLifeCycleItem(exportEvent);
                    continue;
                }
                if (!(lifeCycleEvent instanceof TransferEvent)) continue;
                TransferEvent transferEvent = (TransferEvent)lifeCycleEvent;
                org.eclipse.lsat.product.productdata.Task outTask = transferEvent.getTransfer().getOut().getTask();
                String outSlot = transferEvent.getTransfer().getOut().getSlot();
                org.eclipse.lsat.product.productdata.Task inTask = transferEvent.getTransfer().getIn().getTask();
                String inSlot = transferEvent.getTransfer().getIn().getSlot();
                ProductLifeCycleEventTransfer exportEvent = this.createExportProductLifeCycleEvent(ProductLifeCycleEventTransfer.class);
                exportEvent.setOutTaskId(this.scheduledTaskToId.get(outTask.getScheduledTask()));
                if (outSlot != null && !outSlot.isEmpty()) {
                    exportEvent.setOutSlot(outSlot);
                }
                exportEvent.setInTaskId(this.scheduledTaskToId.get(inTask.getScheduledTask()));
                if (inSlot != null && !inSlot.isEmpty()) {
                    exportEvent.setInSlot(inSlot);
                }
                exportProduct.addLifeCycleItem(exportEvent);
            }
            exportLsatData.putProductsItem(id, exportProduct);
        }
    }

    private void convert(Collection<org.eclipse.lsat.common.scheduler.schedule.Sequence<org.eclipse.lsat.common.scheduler.graph.Task>> sequences, HashMap<org.eclipse.lsat.common.scheduler.graph.Task, CollectedScheduleData> collectedData, LsatData exportLsatData) {
        for (org.eclipse.lsat.common.scheduler.schedule.Sequence<org.eclipse.lsat.common.scheduler.graph.Task> seq : sequences) {
            for (ScheduledTask task : seq.getScheduledTasks()) {
                EObject eObject;
                String id = "T" + String.valueOf(this.uniqueId++);
                this.scheduledTaskToId.put((ScheduledTask<org.eclipse.lsat.common.scheduler.graph.Task>)task, id);
                this.taskToId.put(task.getTask(), id);
                Task exportTask = new Task();
                exportTask.setName(task.getName());
                exportTask.setStartTime(task.getStartTime().doubleValue());
                exportTask.setDuration(task.getDuration().doubleValue());
                org.eclipse.lsat.common.scheduler.graph.Task task2 = task.getTask();
                if (task2 instanceof ActionTask) {
                    ActionTask paTask = (ActionTask)task2;
                    ResourceAction action = paTask.getAction();
                    activity.Activity activity = (activity.Activity)action.eContainer();
                    exportTask.setActionId(action.getName());
                    exportTask.setActivityId(activity.getName());
                }
                if ((eObject = task.getTask().eContainer()) instanceof DispatchGraph) {
                    DispatchGraph dg = (DispatchGraph)eObject;
                    exportTask.setDispatchId(this.dispatchToId.get(dg.getDispatch()));
                }
                exportTask.setType(this.getTaskType(task));
                EList executionDataParameters = task.getTask().getExecutionDataParameters();
                List axes = task.getTask().getExecutionData().keySet().stream().sorted().collect(Collectors.toList());
                Map resampledData = ResampleTimeStepData.resample((EMap)task.getTask().getExecutionData(), (double)this.executionDataSampleFrequency);
                int index = 0;
                while (index < executionDataParameters.size()) {
                    LinkedHashMap<String, List<Double>> exportExecutionData = new LinkedHashMap<String, List<Double>>();
                    for (String axis : axes) {
                        List<Double> values = ConvertToOpenApiSchemas.getValuesAtLastIndex(resampledData, axis, index);
                        if (values.size() <= 0) continue;
                        exportExecutionData.put(axis, values);
                    }
                    if (exportExecutionData.size() > 0) {
                        exportTask.putExecutionDataItem((String)executionDataParameters.get(index), exportExecutionData);
                    }
                    ++index;
                }
                for (Aspect aspect : task.getAspects()) {
                    TaskAttributesValue exportAnnotation;
                    if (aspect instanceof lsat_graph.StochasticAnnotation) {
                        lsat_graph.StochasticAnnotation stochasticAnnotation = (lsat_graph.StochasticAnnotation)aspect;
                        StochasticAnnotation exportStochastics = new StochasticAnnotation();
                        StochasticProperties exportStartTime = new StochasticProperties();
                        exportStartTime.setMean(stochasticAnnotation.getMean().doubleValue());
                        exportStartTime.setMin(stochasticAnnotation.getMin().doubleValue());
                        exportStartTime.setMax(stochasticAnnotation.getMax().doubleValue());
                        exportStartTime.setStandardDeviation(stochasticAnnotation.getStandardDeviation().doubleValue());
                        BigDecimal skewness = stochasticAnnotation.getSkewness();
                        if (skewness != null) {
                            exportStartTime.setSkewness(skewness.doubleValue());
                        }
                        exportStochastics.setStartTime(exportStartTime);
                        lsat_graph.Bounds confidenceInterval = stochasticAnnotation.getConfidenceInterval();
                        if (confidenceInterval != null) {
                            Bounds exportConfidenceInterval = new Bounds();
                            exportConfidenceInterval.setLower(confidenceInterval.getLower().doubleValue());
                            exportConfidenceInterval.setUpper(confidenceInterval.getUpper().doubleValue());
                            exportStochastics.setConfidenceInterval(exportConfidenceInterval);
                        }
                        exportStochastics.setCriticality(stochasticAnnotation.getCriticality().doubleValue());
                        CollectedScheduleData data = collectedData.get(task.getTask());
                        if (data != null) {
                            StochasticMeasurements exportMeasurements = new StochasticMeasurements();
                            exportMeasurements.setStartTime(Arrays.stream(data.getStartTime()).boxed().collect(Collectors.toList()));
                            exportMeasurements.setDuration(Arrays.stream(data.getDuration()).boxed().collect(Collectors.toList()));
                            exportMeasurements.setCritical(Arrays.stream(data.getCritical()).boxed().collect(Collectors.toList()));
                            exportStochastics.setMeasurements(exportMeasurements);
                        }
                        exportTask.putAttributesItem("stochastics", exportStochastics);
                        continue;
                    }
                    if (aspect.getName().equals("Critical")) {
                        exportAnnotation = new TaskAnnotationBoolean();
                        ((TaskAnnotationBoolean)exportAnnotation).setValue(true);
                        exportTask.putAttributesItem("critical", exportAnnotation);
                        continue;
                    }
                    exportAnnotation = new TaskAnnotationString();
                    ((TaskAnnotationString)exportAnnotation).setValue(aspect.toString());
                    exportTask.putAttributesItem(aspect.getName(), exportAnnotation);
                }
                exportLsatData.putTasksItem(id, exportTask);
            }
        }
    }

    private void convertSequences(Collection<org.eclipse.lsat.common.scheduler.schedule.Sequence<org.eclipse.lsat.common.scheduler.graph.Task>> sequences, Schedule exportSchedule) {
        for (org.eclipse.lsat.common.scheduler.schedule.Sequence<org.eclipse.lsat.common.scheduler.graph.Task> seq : sequences) {
            Sequence exportSequence = new Sequence();
            exportSequence.setName(seq.getName());
            String resourceName = seq.getResource().getContainer().getName();
            exportSequence.setResourceId(resourceName);
            org.eclipse.lsat.common.scheduler.resources.Resource resource = seq.getResource();
            if (resource instanceof PeripheralResource) {
                PeripheralResource peripheral = (PeripheralResource)resource;
                String peripheralName = resourceName + "." + peripheral.getPeripheral().getName();
                exportSequence.setPeripheralId(peripheralName);
            }
            for (ScheduledTask t : seq.getScheduledTasks()) {
                exportSequence.addTaskIdsItem(this.scheduledTaskToId.get(t));
            }
            exportSchedule.addSequencesItem(exportSequence);
        }
    }

    private void convert(Collection<org.eclipse.lsat.common.scheduler.graph.Dependency> dependencies, Graph exportGraph) {
        for (org.eclipse.lsat.common.scheduler.graph.Dependency dependency : dependencies) {
            org.eclipse.lsat.common.graph.directed.Node sourceNode = dependency.getSourceNode();
            org.eclipse.lsat.common.graph.directed.Node targetNode = dependency.getTargetNode();
            Dependency exportDependency = new Dependency();
            exportDependency.setSourceId(this.taskToId.get(sourceNode));
            exportDependency.setTargetId(this.taskToId.get(targetNode));
            exportGraph.addDependenciesItem(exportDependency);
        }
    }

    private void convert(Collection<ScheduledDependency> dependencies, Schedule exportSchedule) {
        ArrayList<Dependency> exportDependencies = new ArrayList<Dependency>(dependencies.size());
        for (ScheduledDependency scheduledDependency : dependencies) {
            org.eclipse.lsat.common.graph.directed.Node sourceNode = scheduledDependency.getSourceNode();
            org.eclipse.lsat.common.graph.directed.Node targetNode = scheduledDependency.getTargetNode();
            Dependency exportDependency = new Dependency();
            exportDependency.setSourceId(this.scheduledTaskToId.get(sourceNode));
            exportDependency.setTargetId(this.scheduledTaskToId.get(targetNode));
            exportDependencies.add(exportDependency);
        }
        exportDependencies.sort(Comparator.comparing(Dependency::getSourceId).thenComparing(Dependency::getTargetId));
        for (Dependency dependency : exportDependencies) {
            exportSchedule.addDependenciesItem(dependency);
        }
    }

    private <T extends ActionBase> T createExportAction(Class<T> exportActionType, Node node) {
        try {
            ActionBase exportAction = (ActionBase)exportActionType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            exportAction.setActionType(exportActionType.getSimpleName());
            if (node instanceof Action) {
                TracePoint exit;
                Action action = (Action)node;
                TracePoint entry = action.getEntry();
                if (entry != null) {
                    exportAction.setTracePointStart(entry.getValue());
                }
                if ((exit = action.getExit()) != null) {
                    exportAction.setTracePointEnd(exit.getValue());
                }
            }
            return (T)exportAction;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create exportAction", e);
        }
    }

    private <T extends ProductPropertyBase> T createExportProductProperties(Class<T> exportActionType, ProductProperty prop) {
        try {
            ProductPropertyBase exportProductProperties = (ProductPropertyBase)exportActionType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            exportProductProperties.setPropertyType(ConvertToOpenApiSchemas.getLastWord(exportActionType.getSimpleName()));
            exportProductProperties.setName(prop.getPropertyName());
            exportProductProperties.setTaskId(this.scheduledTaskToId.get(prop.getAction().getScheduledTask()));
            exportProductProperties.setAt(prop.getAt().toString());
            return (T)exportProductProperties;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create exportProductProperties", e);
        }
    }

    private <T extends ProductLifeCycleEventBase> T createExportProductLifeCycleEvent(Class<T> exportEventType) {
        try {
            ProductLifeCycleEventBase exportProductLifeCycleEvent = (ProductLifeCycleEventBase)exportEventType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            exportProductLifeCycleEvent.setEventType(ConvertToOpenApiSchemas.getLastWord(exportEventType.getSimpleName()));
            return (T)exportProductLifeCycleEvent;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create exportProductLifeCycleEvent", e);
        }
    }

    private TaskType getTaskType(ScheduledTask<?> task) {
        if (ConvertToOpenApiSchemas.isEvent(task)) {
            return TaskType.EVENT;
        }
        if (ConvertToOpenApiSchemas.isClaimOrRelease(task)) {
            return TaskType.CLAIM_OR_RELEASE;
        }
        return TaskType.PERIPHERAL_TASK;
    }

    private static String getPeripheralFqn(IResource iresource, machine.Peripheral peripheral) {
        Object fqn = peripheral.getName();
        if (iresource instanceof ResourceItem) {
            ResourceItem r = (ResourceItem)iresource;
            fqn = r.getResource().getName() + "." + r.getName() + "." + (String)fqn;
        } else if (iresource instanceof machine.Resource) {
            machine.Resource r = (machine.Resource)iresource;
            fqn = r.getName() + "." + (String)fqn;
        }
        return fqn;
    }

    private static String getResourceName(IResource iresource) {
        Object name = iresource.getName();
        if (iresource instanceof ResourceItem) {
            ResourceItem r = (ResourceItem)iresource;
            machine.Resource resource = r.getResource();
            if (resource != null) {
                name = resource.getName() + "." + (String)name;
            }
        } else if (iresource instanceof machine.Resource) {
            machine.Resource r = (machine.Resource)iresource;
            name = r.getName();
        }
        return name;
    }

    private static List<Double> getValuesAtLastIndex(Map<String, List<List<BigDecimal>>> data, String key, int lastIndex) {
        return Optional.ofNullable(data.get(key)).stream().flatMap(Collection::stream).filter(innerList -> innerList.size() > lastIndex).map(innerList -> ((BigDecimal)innerList.get(lastIndex)).doubleValue()).collect(Collectors.toList());
    }

    private static boolean isEvent(ScheduledTask<?> task) {
        return !task.getTask().getAspects().stream().toList().isEmpty();
    }

    private static boolean isClaimOrRelease(ScheduledTask<?> task) {
        return task instanceof ClaimedByScheduledTask || task.getTask() instanceof ClaimTask || task.getTask() instanceof ReleaseTask;
    }

    private static String getLastWord(String input) {
        if (input == null || input.isEmpty()) {
            return "";
        }
        String regex = "[A-Z][a-z0-9]*$";
        return input.replaceAll(".*(" + regex + ")", "$1");
    }
}

