/**
 */
package org.eclipse.lsat.common.scheduler.graph.impl;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.lsat.common.graph.directed.impl.NodeImpl;
import org.eclipse.lsat.common.scheduler.graph.GraphPackage;
import org.eclipse.lsat.common.scheduler.graph.Task;
import org.eclipse.lsat.common.scheduler.graph.TimeStepData;
import org.eclipse.lsat.common.scheduler.resources.Resource;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Task</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.lsat.common.scheduler.graph.impl.TaskImpl#getExecutionTime <em>Execution Time</em>}</li>
 *   <li>{@link org.eclipse.lsat.common.scheduler.graph.impl.TaskImpl#getExecutionData <em>Execution Data</em>}</li>
 *   <li>{@link org.eclipse.lsat.common.scheduler.graph.impl.TaskImpl#getExecutionDataParameters <em>Execution Data Parameters</em>}</li>
 *   <li>{@link org.eclipse.lsat.common.scheduler.graph.impl.TaskImpl#getResources <em>Resources</em>}</li>
 * </ul>
 *
 * @generated
 */
public class TaskImpl extends NodeImpl implements Task {
	/**
     * The default value of the '{@link #getExecutionTime() <em>Execution Time</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getExecutionTime()
     * @generated
     * @ordered
     */
	protected static final BigDecimal EXECUTION_TIME_EDEFAULT = null;

	/**
     * The cached value of the '{@link #getExecutionTime() <em>Execution Time</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getExecutionTime()
     * @generated
     * @ordered
     */
	protected BigDecimal executionTime = EXECUTION_TIME_EDEFAULT;

	/**
     * The cached value of the '{@link #getExecutionData() <em>Execution Data</em>}' map.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getExecutionData()
     * @generated
     * @ordered
     */
    protected EMap<String, EList<TimeStepData>> executionData;

    /**
     * The cached value of the '{@link #getExecutionDataParameters() <em>Execution Data Parameters</em>}' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getExecutionDataParameters()
     * @generated
     * @ordered
     */
    protected EList<String> executionDataParameters;

    /**
     * The cached value of the '{@link #getResources() <em>Resources</em>}' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getResources()
     * @generated
     * @ordered
     */
	protected EList<Resource> resources;

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected TaskImpl() {
        super();
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	protected EClass eStaticClass() {
        return GraphPackage.Literals.TASK;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public BigDecimal getExecutionTime() {
        return executionTime;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public void setExecutionTime(BigDecimal newExecutionTime) {
        BigDecimal oldExecutionTime = executionTime;
        executionTime = newExecutionTime;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, GraphPackage.TASK__EXECUTION_TIME, oldExecutionTime, executionTime));
    }

	/**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public EMap<String, EList<TimeStepData>> getExecutionData()
    {
        if (executionData == null)
        {
            executionData = new EcoreEMap<String,EList<TimeStepData>>(GraphPackage.Literals.EXECUTION_DATA_ENTRY, ExecutionDataEntryImpl.class, this, GraphPackage.TASK__EXECUTION_DATA);
        }
        return executionData;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public EList<String> getExecutionDataParameters()
    {
        if (executionDataParameters == null)
        {
            executionDataParameters = new EDataTypeUniqueEList<String>(String.class, this, GraphPackage.TASK__EXECUTION_DATA_PARAMETERS);
        }
        return executionDataParameters;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public EList<Resource> getResources() {
        if (resources == null)
        {
            resources = new EObjectResolvingEList<Resource>(Resource.class, this, GraphPackage.TASK__RESOURCES);
        }
        return resources;
    }

	/**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void addExecutionData(final String setpoint, final EList<BigDecimal> values)
    {
        getExecutionData(); // make sure executionData is initialized
        if (executionData.get(setpoint) == null) {
            executionData.put(setpoint, new BasicEList<TimeStepData>());
        }
        var tsData = executionData.get(setpoint);
        
        var timeStepData = new TimeStepDataImpl();
        timeStepData.getValues().addAll(values);
        tsData.add(timeStepData);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs)
    {
        switch (featureID)
        {
            case GraphPackage.TASK__EXECUTION_DATA:
                return ((InternalEList<?>)getExecutionData()).basicRemove(otherEnd, msgs);
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID)
        {
            case GraphPackage.TASK__EXECUTION_TIME:
                return getExecutionTime();
            case GraphPackage.TASK__EXECUTION_DATA:
                if (coreType) return getExecutionData();
                else return getExecutionData().map();
            case GraphPackage.TASK__EXECUTION_DATA_PARAMETERS:
                return getExecutionDataParameters();
            case GraphPackage.TASK__RESOURCES:
                return getResources();
        }
        return super.eGet(featureID, resolve, coreType);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
        switch (featureID)
        {
            case GraphPackage.TASK__EXECUTION_TIME:
                setExecutionTime((BigDecimal)newValue);
                return;
            case GraphPackage.TASK__EXECUTION_DATA:
                ((EStructuralFeature.Setting)getExecutionData()).set(newValue);
                return;
            case GraphPackage.TASK__EXECUTION_DATA_PARAMETERS:
                getExecutionDataParameters().clear();
                getExecutionDataParameters().addAll((Collection<? extends String>)newValue);
                return;
            case GraphPackage.TASK__RESOURCES:
                getResources().clear();
                getResources().addAll((Collection<? extends Resource>)newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public void eUnset(int featureID) {
        switch (featureID)
        {
            case GraphPackage.TASK__EXECUTION_TIME:
                setExecutionTime(EXECUTION_TIME_EDEFAULT);
                return;
            case GraphPackage.TASK__EXECUTION_DATA:
                getExecutionData().clear();
                return;
            case GraphPackage.TASK__EXECUTION_DATA_PARAMETERS:
                getExecutionDataParameters().clear();
                return;
            case GraphPackage.TASK__RESOURCES:
                getResources().clear();
                return;
        }
        super.eUnset(featureID);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public boolean eIsSet(int featureID) {
        switch (featureID)
        {
            case GraphPackage.TASK__EXECUTION_TIME:
                return EXECUTION_TIME_EDEFAULT == null ? executionTime != null : !EXECUTION_TIME_EDEFAULT.equals(executionTime);
            case GraphPackage.TASK__EXECUTION_DATA:
                return executionData != null && !executionData.isEmpty();
            case GraphPackage.TASK__EXECUTION_DATA_PARAMETERS:
                return executionDataParameters != null && !executionDataParameters.isEmpty();
            case GraphPackage.TASK__RESOURCES:
                return resources != null && !resources.isEmpty();
        }
        return super.eIsSet(featureID);
    }

	/**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    @SuppressWarnings("unchecked")
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException
    {
        switch (operationID)
        {
            case GraphPackage.TASK___ADD_EXECUTION_DATA__STRING_ELIST:
                addExecutionData((String)arguments.get(0), (EList<BigDecimal>)arguments.get(1));
                return null;
        }
        return super.eInvoke(operationID, arguments);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public String toString() {
        if (eIsProxy()) return super.toString();

        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (executionTime: ");
        result.append(executionTime);
        result.append(", executionDataParameters: ");
        result.append(executionDataParameters);
        result.append(')');
        return result.toString();
    }

} //TaskImpl
