/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.por;

import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.lsat.common.ludus.backend.fsm.impl.Edge;
import org.eclipse.lsat.common.ludus.backend.fsm.impl.FSMImpl;
import org.eclipse.lsat.common.ludus.backend.fsm.impl.Location;

public class PrePostProcessor {
    public static final String BOTTOM = "_dump";
    public static final String OMEGA = "_omega";

    private PrePostProcessor() {
    }

    public static FSMImpl addOmegaLoops(FSMImpl fsm) {
        FSMImpl newFSM = FSMImpl.clone(fsm);
        for (Location m : newFSM.getMarkedVertices()) {
            newFSM.addEdge(m, m, OMEGA);
            newFSM.addControllable(OMEGA);
        }
        return newFSM;
    }

    public static FSMImpl removeOmegaLoops(FSMImpl fsm) {
        FSMImpl newFSM = FSMImpl.clone(fsm);
        for (Location m : newFSM.getMarkedVertices()) {
            newFSM.removeEdge(m, m, OMEGA);
        }
        newFSM.removeControllable(OMEGA);
        return newFSM;
    }

    public static FSMImpl plantify(FSMImpl fsm) {
        FSMImpl newFSM = FSMImpl.clone(fsm);
        Set<String> uEvents = newFSM.getUncontrollable();
        Location dump = new Location(BOTTOM);
        newFSM.addLocation(dump);
        for (String event : newFSM.getAlphabet()) {
            newFSM.addEdge(dump, dump, event);
        }
        for (Location l : newFSM.getVertices()) {
            for (String uEvent : uEvents) {
                Set outgoingEvents = newFSM.outgoingEdgesOf(l).stream().map(Edge::getEvent).collect(Collectors.toSet());
                if (outgoingEvents.contains(uEvent)) continue;
                newFSM.addEdge(l, dump, uEvent);
            }
        }
        return newFSM;
    }
}

