/*
 * Decompiled with CFR 0.152.
 */
package expressions;

import distributions.Distribution;
import expressions.DeclarationRef;
import expressions.Expression;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public class ExpressionsUtil {
    private ExpressionsUtil() {
    }

    public static Collection<Distribution> getDistributions(Expression expression) {
        return ExpressionsUtil.getExpressionsOfType(expression, Distribution.class);
    }

    public static <T extends Expression> Collection<T> getExpressionsOfType(Expression expression, Class<T> type) {
        LinkedHashSet result = new LinkedHashSet();
        LinkedHashSet<Expression> visited = new LinkedHashSet<Expression>();
        ExpressionsUtil.getExpressionsOfType(expression, visited, result, type);
        return result;
    }

    private static <T extends Expression> void getExpressionsOfType(Expression expression, Set<Expression> visited, Set<T> result, Class<T> type) {
        if (expression instanceof DeclarationRef) {
            DeclarationRef dr = (DeclarationRef)expression;
            ExpressionsUtil.getExpressionsOfType(dr.getDeclaration().getExpression(), visited, result, type);
        } else if (visited.add(expression)) {
            if (type.isInstance(expression)) {
                result.add((Expression)type.cast(expression));
            }
            expression.eContents().stream().filter(Expression.class::isInstance).map(Expression.class::cast).forEach(exp -> ExpressionsUtil.getExpressionsOfType(exp, visited, result, type));
        }
    }
}

