/**
 */
package common.util;

import common.*;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see common.CommonPackage
 * @generated
 */
public class CommonAdapterFactory extends AdapterFactoryImpl
{
    /**
     * The cached model package.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected static CommonPackage modelPackage;

    /**
     * Creates an instance of the adapter factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public CommonAdapterFactory()
    {
        if (modelPackage == null)
        {
            modelPackage = CommonPackage.eINSTANCE;
        }
    }

    /**
     * Returns whether this factory is applicable for the type of the object.
     * <!-- begin-user-doc -->
     * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
     * <!-- end-user-doc -->
     * @return whether this factory is applicable for the type of the object.
     * @generated
     */
    @Override
    public boolean isFactoryForType(Object object)
    {
        if (object == modelPackage)
        {
            return true;
        }
        if (object instanceof EObject)
        {
            return ((EObject)object).eClass().getEPackage() == modelPackage;
        }
        return false;
    }

    /**
     * The switch that delegates to the <code>createXXX</code> methods.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected CommonSwitch<Adapter> modelSwitch =
        new CommonSwitch<Adapter>()
        {
            @Override
            public Adapter caseImportContainer(ImportContainer object)
            {
                return createImportContainerAdapter();
            }
            @Override
            public Adapter caseImport(Import object)
            {
                return createImportAdapter();
            }
            @Override
            public Adapter caseHasParameters(HasParameters object)
            {
                return createHasParametersAdapter();
            }
            @Override
            public Adapter caseHasParameterDeclarations(HasParameterDeclarations object)
            {
                return createHasParameterDeclarationsAdapter();
            }
            @Override
            public Adapter caseParameterDeclaration(ParameterDeclaration object)
            {
                return createParameterDeclarationAdapter();
            }
            @Override
            public Adapter caseTypeDefinition(TypeDefinition object)
            {
                return createTypeDefinitionAdapter();
            }
            @Override
            public Adapter caseParameter(Parameter object)
            {
                return createParameterAdapter();
            }
            @Override
            public Adapter caseHasName(HasName object)
            {
                return createHasNameAdapter();
            }
            @Override
            public Adapter caseParameterReference(ParameterReference object)
            {
                return createParameterReferenceAdapter();
            }
            @Override
            public Adapter defaultCase(EObject object)
            {
                return createEObjectAdapter();
            }
        };

    /**
     * Creates an adapter for the <code>target</code>.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param target the object to adapt.
     * @return the adapter for the <code>target</code>.
     * @generated
     */
    @Override
    public Adapter createAdapter(Notifier target)
    {
        return modelSwitch.doSwitch((EObject)target);
    }


    /**
     * Creates a new adapter for an object of class '{@link common.ImportContainer <em>Import Container</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see common.ImportContainer
     * @generated
     */
    public Adapter createImportContainerAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link common.Import <em>Import</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see common.Import
     * @generated
     */
    public Adapter createImportAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link common.HasParameters <em>Has Parameters</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see common.HasParameters
     * @generated
     */
    public Adapter createHasParametersAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link common.HasParameterDeclarations <em>Has Parameter Declarations</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see common.HasParameterDeclarations
     * @generated
     */
    public Adapter createHasParameterDeclarationsAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link common.ParameterDeclaration <em>Parameter Declaration</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see common.ParameterDeclaration
     * @generated
     */
    public Adapter createParameterDeclarationAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link common.TypeDefinition <em>Type Definition</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see common.TypeDefinition
     * @generated
     */
    public Adapter createTypeDefinitionAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link common.Parameter <em>Parameter</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see common.Parameter
     * @generated
     */
    public Adapter createParameterAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link common.HasName <em>Has Name</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see common.HasName
     * @generated
     */
    public Adapter createHasNameAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link common.ParameterReference <em>Parameter Reference</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see common.ParameterReference
     * @generated
     */
    public Adapter createParameterReferenceAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for the default case.
     * <!-- begin-user-doc -->
     * This default implementation returns null.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @generated
     */
    public Adapter createEObjectAdapter()
    {
        return null;
    }

} //CommonAdapterFactory
