/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.launcher;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.launcher.Messages;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.launcher.SystemTapRegexGenerator;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.launcher.SystemTapScriptLaunchConfigurationTab;
import org.eclipse.linuxtools.systemtap.graphing.core.datasets.IDataSet;
import org.eclipse.linuxtools.systemtap.graphing.core.datasets.IDataSetParser;
import org.eclipse.linuxtools.systemtap.graphing.core.datasets.IFilteredDataSet;
import org.eclipse.linuxtools.systemtap.graphing.core.datasets.row.LineParser;
import org.eclipse.linuxtools.systemtap.graphing.core.structures.GraphData;
import org.eclipse.linuxtools.systemtap.graphing.ui.widgets.ExceptionErrorDialog;
import org.eclipse.linuxtools.systemtap.graphing.ui.wizards.dataset.DataSetFactory;
import org.eclipse.linuxtools.systemtap.graphing.ui.wizards.graph.GraphFactory;
import org.eclipse.linuxtools.systemtap.graphing.ui.wizards.graph.SelectGraphAndSeriesWizard;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class SystemTapScriptGraphOptionsTab
extends AbstractLaunchConfigurationTab {
    static final int MAX_NUMBER_OF_REGEXS = 20;
    static final int MAX_REGEX_LENGTH = 200;
    static final String RUN_WITH_CHART = "runWithChart";
    static final String NUMBER_OF_REGEXS = "numberOfRegexs";
    static final String NUMBER_OF_COLUMNS = "numberOfColumns_";
    static final String REGEX_BOX = "regexBox_";
    static final String NUMBER_OF_EXTRAS = "numberOfExtras_";
    static final String EXTRA_BOX = "extraBox_";
    static final String REGULAR_EXPRESSION = "regularExpression_";
    static final String SAMPLE_OUTPUT = "sampleOutput_";
    private static final String NUMBER_OF_GRAPHS = "numberOfGraphs";
    private static final String GRAPH_TITLE = "graphTitle";
    private static final String GRAPH_KEY = "graphKey";
    private static final String GRAPH_X_SERIES = "graphXSeries";
    private static final String GRAPH_ID = "graphID";
    private static final String GRAPH_Y_SERIES_LENGTH = "graphYSeriesLength";
    private static final String GRAPH_Y_SERIES = "graphYSeries";
    protected Pattern pattern;
    protected Matcher matcher;
    private Combo regularExpressionCombo;
    private Button removeRegexButton;
    private Text sampleOutputText;
    private Composite textFieldsComposite;
    private boolean textListenersEnabled = true;
    private Group outputParsingGroup;
    private Button runWithChartCheckButton;
    private Table graphsTable;
    private Button addGraphButton;
    private Button duplicateGraphButton;
    private Button editGraphButton;
    private Button removeGraphButton;
    private TableItem selectedTableItem;
    private Group graphsGroup;
    private int numberOfVisibleColumns = 0;
    private boolean graphingEnabled = true;
    private List<String> regexErrorMessages = new ArrayList<String>();
    private int selectedRegex = -1;
    private List<String> outputList = new ArrayList<String>();
    private Stack<String> cachedNames = new Stack();
    private List<Stack<String>> cachedNamesList = new ArrayList<Stack<String>>();
    private List<List<String>> columnNamesList = new ArrayList<List<String>>();
    private List<GraphData> graphsData = new LinkedList<GraphData>();
    private List<LinkedList<GraphData>> graphsDataList = new ArrayList<LinkedList<GraphData>>();
    private List<GraphData> badGraphs = new LinkedList<GraphData>();
    private ModifyListener regexListener = event -> {
        if (!this.textListenersEnabled || this.regularExpressionCombo.getSelectionIndex() != -1) {
            return;
        }
        this.regularExpressionCombo.setItem(this.selectedRegex, this.regularExpressionCombo.getText());
        this.regularExpressionCombo.select(this.selectedRegex);
        this.refreshRegexRows();
        this.updateLaunchConfigurationDialog();
    };
    private ModifyListener sampleOutputListener = event -> {
        if (!this.textListenersEnabled) {
            return;
        }
        this.outputList.set(this.selectedRegex, this.sampleOutputText.getText());
        this.refreshRegexRows();
        this.updateLaunchConfigurationDialog();
    };
    private ModifyListener columnNameListener = event -> {
        if (!this.textListenersEnabled) {
            return;
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        Control[] children = this.textFieldsComposite.getChildren();
        for (int i = 0; i < this.numberOfVisibleColumns; ++i) {
            columnNames.add(((Text)children[i * 4 + 2]).getText());
        }
        this.columnNamesList.set(this.selectedRegex, columnNames);
        this.updateLaunchConfigurationDialog();
    };
    private SelectionListener regexGenerator = SelectionListener.widgetSelectedAdapter(e -> {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IPath scriptPath = null;
        for (ILaunchConfigurationTab tab : this.getLaunchConfigurationDialog().getTabs()) {
            if (!(tab instanceof SystemTapScriptLaunchConfigurationTab)) continue;
            scriptPath = ((SystemTapScriptLaunchConfigurationTab)tab).getScriptPath();
            break;
        }
        if (scriptPath == null) {
            MessageDialog dialog = new MessageDialog(workbench.getActiveWorkbenchWindow().getShell(), Messages.SystemTapScriptGraphOptionsTab_generateFromPrintsErrorTitle, null, Messages.SystemTapScriptGraphOptionsTab_generateFromPrintsError, 1, new String[]{"OK"}, 0);
            dialog.open();
            return;
        }
        MessageDialog dialog = new MessageDialog(workbench.getActiveWorkbenchWindow().getShell(), Messages.SystemTapScriptGraphOptionsTab_generateFromPrintsTitle, null, Messages.SystemTapScriptGraphOptionsTab_generateFromPrintsMessage, 3, new String[]{"Yes", "Cancel"}, 0);
        int result = dialog.open();
        if (result != 0) {
            return;
        }
        List<Map.Entry<String, Integer>> regexs = SystemTapRegexGenerator.generateFromPrintf(scriptPath, 20);
        if (regexs.size() == 0) {
            dialog = new MessageDialog(workbench.getActiveWorkbenchWindow().getShell(), Messages.SystemTapScriptGraphOptionsTab_generateFromPrintsErrorTitle, null, Messages.SystemTapScriptGraphOptionsTab_generateFromPrintsEmpty, 1, new String[]{"OK"}, 0);
            dialog.open();
        } else {
            this.textListenersEnabled = false;
            this.regularExpressionCombo.removeAll();
            this.outputList.clear();
            this.regexErrorMessages.clear();
            this.columnNamesList.clear();
            this.cachedNamesList.clear();
            this.graphsTable.removeAll();
            this.graphsDataList.clear();
            this.badGraphs.clear();
            int n = regexs.size();
            for (int i = 0; i < n; ++i) {
                ArrayList<String> columnNames = new ArrayList<String>();
                int numColumns = regexs.get(i).getValue();
                for (int c = 0; c < numColumns; ++c) {
                    columnNames.add(MessageFormat.format(Messages.SystemTapScriptGraphOptionsTab_defaultColumnTitleBase, c + 1));
                }
                this.regularExpressionCombo.add(regexs.get(i).getKey());
                this.outputList.add("");
                this.regexErrorMessages.add(null);
                this.columnNamesList.add(columnNames);
                this.cachedNamesList.add(new Stack());
                this.graphsDataList.add(new LinkedList());
            }
            if (this.getNumberOfRegexs() < 20) {
                this.regularExpressionCombo.add(Messages.SystemTapScriptGraphOptionsTab_regexAddNew);
            }
            this.textListenersEnabled = true;
            this.removeRegexButton.setEnabled(this.getNumberOfRegexs() > 1);
            this.regularExpressionCombo.select(0);
            this.updateRegexSelection(0, true);
            this.checkAllOtherErrors();
            this.updateLaunchConfigurationDialog();
        }
    });

    public static List<String> createDatasetNames(ILaunchConfiguration configuration) {
        try {
            int numberOfRegexs = configuration.getAttribute(NUMBER_OF_REGEXS, 0);
            ArrayList<String> names = new ArrayList<String>(numberOfRegexs);
            for (int r = 0; r < numberOfRegexs; ++r) {
                names.add(MessageFormat.format(Messages.SystemTapScriptGraphOptionsTab_graphSetTitleBase, r + 1));
            }
            return names;
        }
        catch (CoreException e) {
            ExceptionErrorDialog.openError((String)Messages.SystemTapScriptGraphOptionsTab_cantInitializeTab, (Exception)((Object)e));
            return null;
        }
    }

    public static List<IDataSetParser> createDatasetParsers(ILaunchConfiguration configuration) {
        try {
            int numberOfRegexs = configuration.getAttribute(NUMBER_OF_REGEXS, 0);
            ArrayList<IDataSetParser> parsers = new ArrayList<IDataSetParser>(numberOfRegexs);
            for (int r = 0; r < numberOfRegexs; ++r) {
                parsers.add((IDataSetParser)new LineParser("^" + configuration.getAttribute(REGULAR_EXPRESSION + r, "") + "$"));
            }
            return parsers;
        }
        catch (CoreException e) {
            ExceptionErrorDialog.openError((String)Messages.SystemTapScriptGraphOptionsTab_cantInitializeTab, (Exception)((Object)e));
            return null;
        }
    }

    public static List<IFilteredDataSet> createDataset(ILaunchConfiguration configuration) {
        try {
            int numberOfRegexs = configuration.getAttribute(NUMBER_OF_REGEXS, 0);
            ArrayList<IFilteredDataSet> datasets = new ArrayList<IFilteredDataSet>(numberOfRegexs);
            for (int r = 0; r < numberOfRegexs; ++r) {
                int numberOfColumns = configuration.getAttribute(NUMBER_OF_COLUMNS + r, 0);
                ArrayList<String> labels = new ArrayList<String>(numberOfColumns);
                for (int c = 0; c < numberOfColumns; ++c) {
                    labels.add(configuration.getAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(REGEX_BOX, r, c), ""));
                }
                datasets.add(DataSetFactory.createFilteredDataSet((String)"org.eclipse.linuxtools.systemtap.graphing.core.datasets.rowdataset", (String[])labels.toArray(new String[0])));
            }
            return datasets;
        }
        catch (CoreException e) {
            ExceptionErrorDialog.openError((String)Messages.SystemTapScriptGraphOptionsTab_cantInitializeTab, (Exception)((Object)e));
            return null;
        }
    }

    public static List<LinkedList<GraphData>> createGraphsFromConfiguration(ILaunchConfiguration configuration) throws CoreException {
        int numberOfRegexs = Math.max(configuration.getAttribute(NUMBER_OF_REGEXS, 1), 1);
        ArrayList<LinkedList<GraphData>> graphsList = new ArrayList<LinkedList<GraphData>>(numberOfRegexs);
        for (int r = 0; r < numberOfRegexs; ++r) {
            int numberOfGraphs = configuration.getAttribute(NUMBER_OF_GRAPHS + r, 0);
            LinkedList<GraphData> graphs = new LinkedList<GraphData>();
            for (int i = 0; i < numberOfGraphs; ++i) {
                GraphData graphData = new GraphData();
                graphData.title = configuration.getAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_TITLE, r, i), (String)null);
                graphData.key = configuration.getAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_KEY, r, i), (String)null);
                graphData.xSeries = configuration.getAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_X_SERIES, r, i), 0);
                graphData.graphID = configuration.getAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_ID, r, i), (String)null);
                int ySeriesLength = configuration.getAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_Y_SERIES_LENGTH, r, i), 0);
                if (ySeriesLength == 0) {
                    graphData.ySeries = null;
                } else {
                    int[] ySeries = new int[ySeriesLength];
                    for (int j = 0; j < ySeriesLength; ++j) {
                        ySeries[j] = configuration.getAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_Y_SERIES, r, i + "_" + j), 0);
                    }
                    graphData.ySeries = ySeries;
                }
                graphs.add(graphData);
            }
            graphsList.add(graphs);
        }
        return graphsList;
    }

    private static String get2DConfigData(String configDataName, int r, int i) {
        return configDataName + r + "_" + i;
    }

    private static String get2DConfigData(String configDataName, int r, String s) {
        return configDataName + r + "_" + s;
    }

    private int getNumberOfRegexs() {
        return this.outputList.size();
    }

    public void createControl(Composite parent) {
        GridLayout layout = new GridLayout();
        Composite top = new Composite(parent, 0);
        this.setControl((Control)top);
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)new GridData(4, 4, true, true));
        this.runWithChartCheckButton = new Button(top, 32);
        this.runWithChartCheckButton.setText(Messages.SystemTapScriptGraphOptionsTab_graphOutputRun);
        this.runWithChartCheckButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SystemTapScriptGraphOptionsTab.this.setGraphingEnabled(SystemTapScriptGraphOptionsTab.this.runWithChartCheckButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                SystemTapScriptGraphOptionsTab.this.setGraphingEnabled(SystemTapScriptGraphOptionsTab.this.runWithChartCheckButton.getSelection());
            }
        });
        this.runWithChartCheckButton.setToolTipText(Messages.SystemTapScriptGraphOptionsTab_graphOutput);
        this.outputParsingGroup = new Group(top, 16);
        this.outputParsingGroup.setText(Messages.SystemTapScriptGraphOptionsTab_outputLabel);
        this.outputParsingGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createColumnSelector((Composite)this.outputParsingGroup);
        this.graphsGroup = new Group(top, 16);
        this.graphsGroup.setText(MessageFormat.format(Messages.SystemTapScriptGraphOptionsTab_graphSetTitleBase, 1));
        this.graphsGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createGraphCreateArea((Composite)this.graphsGroup);
        this.setGraphingEnabled(false);
        this.runWithChartCheckButton.setSelection(false);
    }

    private void createColumnSelector(Composite parent) {
        GridLayout layout = new GridLayout();
        parent.setLayout((Layout)layout);
        Composite topLayout = new Composite(parent, 0);
        topLayout.setLayout((Layout)new GridLayout(1, false));
        topLayout.setLayoutData((Object)new GridData(4, 4, false, false));
        Button generateExpsButton = new Button(topLayout, 8);
        generateExpsButton.setLayoutData((Object)new GridData(768));
        generateExpsButton.setText(Messages.SystemTapScriptGraphOptionsTab_generateFromPrintsButton);
        generateExpsButton.setToolTipText(Messages.SystemTapScriptGraphOptionsTab_generateFromPrintsTooltip);
        generateExpsButton.addSelectionListener(this.regexGenerator);
        Composite regexButtonLayout = new Composite(parent, 0);
        regexButtonLayout.setLayout((Layout)new GridLayout(3, false));
        regexButtonLayout.setLayoutData((Object)new GridData(4, 4, true, false));
        Label selectedRegexLabel = new Label(regexButtonLayout, 0);
        selectedRegexLabel.setText(Messages.SystemTapScriptGraphOptionsTab_regexLabel);
        selectedRegexLabel.setToolTipText(Messages.SystemTapScriptGraphOptionsTab_regexTooltip);
        this.regularExpressionCombo = new Combo(regexButtonLayout, 4);
        this.regularExpressionCombo.setTextLimit(200);
        this.regularExpressionCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.regularExpressionCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            int selected = this.regularExpressionCombo.getSelectionIndex();
            if (selected == this.selectedRegex) {
                return;
            }
            if (this.regularExpressionCombo.getItem(this.selectedRegex).isEmpty() && this.graphsDataList.get(this.selectedRegex).size() == 0 && this.outputList.get(this.selectedRegex).isEmpty()) {
                if (selected == this.regularExpressionCombo.getItemCount() - 1) {
                    this.regularExpressionCombo.select(this.selectedRegex);
                    return;
                }
                this.removeRegex(false);
                if (selected > this.selectedRegex) {
                    --selected;
                }
            }
            if (selected == this.regularExpressionCombo.getItemCount() - 1 && this.getNumberOfRegexs() < 20) {
                this.outputList.add("");
                this.regexErrorMessages.add(null);
                this.columnNamesList.add(new ArrayList());
                this.cachedNamesList.add(new Stack());
                this.graphsDataList.add(new LinkedList());
                this.regularExpressionCombo.setItem(selected, "");
                this.regularExpressionCombo.select(selected);
                this.updateRegexSelection(selected, false);
                this.updateLaunchConfigurationDialog();
                if (this.getNumberOfRegexs() == 2) {
                    this.removeRegexButton.setEnabled(true);
                }
                if (this.getNumberOfRegexs() < 20) {
                    this.regularExpressionCombo.add(Messages.SystemTapScriptGraphOptionsTab_regexAddNew);
                }
            } else {
                this.updateRegexSelection(selected, false);
            }
        }));
        this.regularExpressionCombo.addModifyListener(this.regexListener);
        this.removeRegexButton = new Button(regexButtonLayout, 8);
        this.removeRegexButton.setLayoutData((Object)new GridData(1, 1, false, false));
        this.removeRegexButton.setText(Messages.SystemTapScriptGraphOptionsTab_regexRemove);
        this.removeRegexButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            IWorkbench workbench = PlatformUI.getWorkbench();
            MessageDialog dialog = new MessageDialog(workbench.getActiveWorkbenchWindow().getShell(), Messages.SystemTapScriptGraphOptionsTab_removeRegexTitle, null, MessageFormat.format(Messages.SystemTapScriptGraphOptionsTab_removeRegexAsk, this.regularExpressionCombo.getItem(this.selectedRegex)), 3, new String[]{"Yes", "No"}, 0);
            int result = dialog.open();
            if (result == 0) {
                this.removeRegex(true);
            }
        }));
        GridLayout twoColumns = new GridLayout(2, false);
        Composite regexSummaryComposite = new Composite(parent, 0);
        regexSummaryComposite.setLayout((Layout)twoColumns);
        regexSummaryComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label sampleOutputLabel = new Label(regexSummaryComposite, 0);
        sampleOutputLabel.setText(Messages.SystemTapScriptGraphOptionsTab_sampleOutputLabel);
        sampleOutputLabel.setToolTipText(Messages.SystemTapScriptGraphOptionsTab_sampleOutputTooltip);
        this.sampleOutputText = new Text(regexSummaryComposite, 2048);
        this.sampleOutputText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.sampleOutputText.addModifyListener(this.sampleOutputListener);
        this.sampleOutputText.setToolTipText(Messages.SystemTapScriptGraphOptionsTab_sampleOutputTooltip);
        Composite expressionTableLabels = new Composite(parent, 0);
        expressionTableLabels.setLayoutData((Object)new GridData(4, 4, false, false));
        expressionTableLabels.setLayout((Layout)twoColumns);
        Label label = new Label(expressionTableLabels, 0);
        label.setText(Messages.SystemTapScriptGraphOptionsTab_columnTitle);
        label.setAlignment(16384);
        Label label2 = new Label(expressionTableLabels, 0);
        label2.setAlignment(16384);
        label2.setText(Messages.SystemTapScriptGraphOptionsTab_extractedValueLabel);
        ScrolledComposite regexTextScrolledComposite = new ScrolledComposite(parent, 2560);
        GridData data = new GridData(4, 4, true, false);
        data.heightHint = 200;
        regexTextScrolledComposite.setLayoutData((Object)data);
        this.textFieldsComposite = new Composite((Composite)regexTextScrolledComposite, 0);
        this.textFieldsComposite.setLayout((Layout)new GridLayout(4, false));
        regexTextScrolledComposite.setContent((Control)this.textFieldsComposite);
        regexTextScrolledComposite.setExpandHorizontal(true);
        this.textListenersEnabled = false;
        this.addColumn(null);
        data = new GridData(4, 4, false, false);
        data.horizontalIndent = this.textFieldsComposite.getChildren()[2].getLocation().x;
        data.widthHint = this.textFieldsComposite.getChildren()[2].getSize().x;
        label.setLayoutData((Object)data);
        label2.setLayoutData((Object)new GridData(4, 4, false, false));
        this.removeColumn(false);
        this.textListenersEnabled = true;
    }

    private IDataSet getCurrentDataset() {
        return DataSetFactory.createDataSet((String)"org.eclipse.linuxtools.systemtap.graphing.core.datasets.rowdataset", (String[])this.columnNamesList.get(this.selectedRegex).toArray(new String[0]));
    }

    private void createGraphCreateArea(Composite comp) {
        comp.setLayout((Layout)new GridLayout(2, false));
        this.graphsTable = new Table(comp, 2052);
        GridData layoutData = new GridData(4, 4, true, true);
        this.graphsTable.setLayoutData((Object)layoutData);
        Composite buttonComposite = new Composite(comp, 0);
        buttonComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        buttonComposite.setLayout((Layout)gridLayout);
        this.addGraphButton = new Button(buttonComposite, 8);
        this.addGraphButton.setText(Messages.SystemTapScriptGraphOptionsTab_AddGraphButton);
        this.addGraphButton.setToolTipText(Messages.SystemTapScriptGraphOptionsTab_AddGraphButtonToolTip);
        this.addGraphButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.duplicateGraphButton = new Button(buttonComposite, 8);
        this.duplicateGraphButton.setText(Messages.SystemTapScriptGraphOptionsTab_DuplicateGraphButton);
        this.duplicateGraphButton.setToolTipText(Messages.SystemTapScriptGraphOptionsTab_DuplicateGraphButtonToolTip);
        this.duplicateGraphButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.editGraphButton = new Button(buttonComposite, 8);
        this.editGraphButton.setText(Messages.SystemTapScriptGraphOptionsTab_EditGraphButton);
        this.editGraphButton.setToolTipText(Messages.SystemTapScriptGraphOptionsTab_EditGraphButtonToolTip);
        this.editGraphButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.removeGraphButton = new Button(buttonComposite, 8);
        this.removeGraphButton.setText(Messages.SystemTapScriptGraphOptionsTab_RemoveGraphButton);
        this.removeGraphButton.setToolTipText(Messages.SystemTapScriptGraphOptionsTab_RemoveGraphButtonToolTip);
        this.removeGraphButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.graphsTable.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.selectedTableItem = (TableItem)e.item;
            this.setSelectionControlsEnabled(true);
        }));
        this.addGraphButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            SelectGraphAndSeriesWizard wizard = new SelectGraphAndSeriesWizard(this.getCurrentDataset(), null);
            IWorkbench workbench = PlatformUI.getWorkbench();
            wizard.init(workbench, null);
            WizardDialog dialog = new WizardDialog(workbench.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
            dialog.create();
            dialog.open();
            GraphData gd = wizard.getGraphData();
            if (gd != null) {
                TableItem item = new TableItem(this.graphsTable, 0);
                this.graphsData.add(gd);
                this.setUpGraphTableItem(item, gd, false);
                this.updateLaunchConfigurationDialog();
            }
        }));
        this.duplicateGraphButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            GraphData gd = ((GraphData)this.selectedTableItem.getData()).getCopy();
            TableItem item = new TableItem(this.graphsTable, 0);
            this.graphsData.add(gd);
            if (this.badGraphs.contains(this.selectedTableItem.getData())) {
                this.badGraphs.add(gd);
                this.setUpGraphTableItem(item, gd, true);
            } else {
                this.setUpGraphTableItem(item, gd, false);
            }
            this.updateLaunchConfigurationDialog();
        }));
        this.editGraphButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            SelectGraphAndSeriesWizard wizard = new SelectGraphAndSeriesWizard(this.getCurrentDataset(), (GraphData)this.selectedTableItem.getData());
            IWorkbench workbench = PlatformUI.getWorkbench();
            wizard.init(workbench, null);
            WizardDialog dialog = new WizardDialog(workbench.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
            dialog.create();
            dialog.open();
            GraphData gd = wizard.getGraphData();
            if (gd == null) {
                return;
            }
            GraphData old_gd = (GraphData)this.selectedTableItem.getData();
            if (!gd.isCopyOf(old_gd)) {
                this.badGraphs.remove(old_gd);
                this.setUpGraphTableItem(this.selectedTableItem, gd, false);
                this.graphsData.set(this.graphsTable.indexOf(this.selectedTableItem), gd);
                this.checkErrors(this.selectedRegex);
                this.updateLaunchConfigurationDialog();
            }
        }));
        this.removeGraphButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            GraphData gd = (GraphData)this.selectedTableItem.getData();
            this.graphsData.remove(gd);
            this.badGraphs.remove(gd);
            this.selectedTableItem.dispose();
            this.setSelectionControlsEnabled(false);
            this.checkErrors(this.selectedRegex);
            this.updateLaunchConfigurationDialog();
        }));
    }

    private void removeRegex(boolean autoSelect) {
        int removedRegex = this.selectedRegex;
        if (autoSelect) {
            this.regularExpressionCombo.select(this.selectedRegex != 0 ? this.selectedRegex - 1 : 1);
            this.updateRegexSelection(this.regularExpressionCombo.getSelectionIndex(), false);
        }
        this.regularExpressionCombo.remove(removedRegex);
        this.outputList.remove(removedRegex);
        this.regexErrorMessages.remove(removedRegex);
        this.columnNamesList.remove(removedRegex);
        this.cachedNamesList.remove(removedRegex);
        this.graphsDataList.remove(removedRegex);
        if (autoSelect) {
            this.selectedRegex = this.regularExpressionCombo.getSelectionIndex();
        }
        if (this.getNumberOfRegexs() == 19) {
            this.regularExpressionCombo.add(Messages.SystemTapScriptGraphOptionsTab_regexAddNew);
        }
        if (this.getNumberOfRegexs() == 1) {
            this.removeRegexButton.setEnabled(false);
        }
        this.updateLaunchConfigurationDialog();
    }

    private void updateRegexSelection(int newSelection, boolean force) {
        boolean textListenersDisabled;
        if (newSelection == -1 || !force && this.selectedRegex == newSelection) {
            return;
        }
        this.selectedRegex = newSelection;
        boolean bl = textListenersDisabled = !this.textListenersEnabled;
        if (!textListenersDisabled) {
            this.textListenersEnabled = false;
        }
        this.sampleOutputText.setText(this.outputList.get(this.selectedRegex));
        this.cachedNames = this.cachedNamesList.get(this.selectedRegex);
        List<String> columnNames = this.columnNamesList.get(this.selectedRegex);
        int desiredNumberOfColumns = columnNames.size();
        while (this.numberOfVisibleColumns > 0) {
            this.removeColumn(false);
        }
        while (this.numberOfVisibleColumns < desiredNumberOfColumns) {
            this.addColumn(columnNames.get(this.numberOfVisibleColumns));
        }
        this.refreshRegexRows();
        this.graphsData = this.graphsDataList.get(this.selectedRegex);
        this.graphsTable.removeAll();
        this.selectedTableItem = null;
        this.setSelectionControlsEnabled(false);
        for (GraphData gd : this.graphsData) {
            TableItem item = new TableItem(this.graphsTable, 0);
            this.setUpGraphTableItem(item, gd, this.badGraphs.contains(gd));
        }
        this.graphsGroup.setText(MessageFormat.format(Messages.SystemTapScriptGraphOptionsTab_graphSetTitleBase, this.selectedRegex + 1));
        if (!textListenersDisabled) {
            this.textListenersEnabled = true;
        }
    }

    private void refreshRegexRows() {
        try {
            this.pattern = Pattern.compile(this.regularExpressionCombo.getText());
            this.matcher = this.pattern.matcher(this.sampleOutputText.getText());
            this.regexErrorMessages.set(this.selectedRegex, null);
        }
        catch (PatternSyntaxException e) {
            this.regexErrorMessages.set(this.selectedRegex, e.getMessage());
            return;
        }
        this.regexErrorMessages.set(this.selectedRegex, SystemTapScriptGraphOptionsTab.checkRegex(this.regularExpressionCombo.getText()));
        if (this.regexErrorMessages.get(this.selectedRegex) != null) {
            return;
        }
        int desiredNumberOfColumns = this.matcher.groupCount();
        while (this.numberOfVisibleColumns < desiredNumberOfColumns) {
            this.addColumn(null);
        }
        while (this.numberOfVisibleColumns > desiredNumberOfColumns) {
            this.removeColumn(true);
        }
        Control[] children = this.textFieldsComposite.getChildren();
        for (int i = 0; i < this.numberOfVisibleColumns; ++i) {
            String sampleOutputResults = this.matcher.matches() ? this.matcher.group(i + 1) : (this.sampleOutputText.getText().length() == 0 ? Messages.SystemTapScriptGraphOptionsTab_sampleOutputIsEmpty : Messages.SystemTapScriptGraphOptionsTab_sampleOutputNoMatch);
            ((Label)children[i * 4 + 3]).setText(" " + sampleOutputResults);
        }
        this.addGraphButton.setEnabled(this.numberOfVisibleColumns > 0);
        if (this.selectedTableItem != null) {
            this.editGraphButton.setEnabled(this.numberOfVisibleColumns > 0);
        }
        this.regexErrorMessages.set(this.selectedRegex, this.findBadGraphs(this.selectedRegex));
    }

    private static String checkRegex(String regex) {
        if (regex.contains("()")) {
            return Messages.SystemTapScriptGraphOptionsTab_emptyGroup;
        }
        return null;
    }

    private void addColumn(String nameToAdd) {
        if (this.numberOfVisibleColumns > 0) {
            this.textFieldsComposite.getChildren()[(this.numberOfVisibleColumns - 1) * 4].setVisible(true);
            this.textFieldsComposite.getChildren()[(this.numberOfVisibleColumns - 1) * 4 + 1].setVisible(true);
        }
        Button buttonUp = new Button(this.textFieldsComposite, 8);
        buttonUp.setText(Messages.SystemTapScriptGraphOptionsTab_columnShiftUp);
        buttonUp.setVisible(false);
        Button buttonDown = new Button(this.textFieldsComposite, 8);
        buttonDown.setText(Messages.SystemTapScriptGraphOptionsTab_columnShiftDown);
        buttonDown.setVisible(false);
        Text text = new Text(this.textFieldsComposite, 2048);
        GridData data = new GridData(4, 4, false, false);
        data.minimumWidth = 200;
        data.widthHint = 200;
        text.setLayoutData((Object)data);
        ++this.numberOfVisibleColumns;
        text.addModifyListener(this.columnNameListener);
        if (nameToAdd == null) {
            if (this.cachedNames.size() > 0) {
                text.setText(this.cachedNames.pop());
            } else {
                text.setText(MessageFormat.format(Messages.SystemTapScriptGraphOptionsTab_defaultColumnTitleBase, this.numberOfVisibleColumns));
            }
        } else {
            text.setText(nameToAdd);
        }
        Label label = new Label(this.textFieldsComposite, 2048);
        label.setLayoutData((Object)new GridData(4, 4, true, false));
        this.textFieldsComposite.layout();
        this.textFieldsComposite.pack();
        buttonUp.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            int currentColumn;
            Control clickedButton = (Control)e.widget;
            Control[] children = this.textFieldsComposite.getChildren();
            for (currentColumn = 0; currentColumn < this.numberOfVisibleColumns - 1 && !children[currentColumn * 4].equals(clickedButton); ++currentColumn) {
            }
            String edgeName = ((Text)children[currentColumn * 4 + 2]).getText();
            for (int i = currentColumn; i < this.numberOfVisibleColumns - 1; ++i) {
                ((Text)children[i * 4 + 2]).setText(((Text)children[(i + 1) * 4 + 2]).getText());
            }
            ((Text)children[(this.numberOfVisibleColumns - 1) * 4 + 2]).setText(edgeName);
        }));
        buttonDown.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            int currentColumn;
            Control clickedButton = (Control)e.widget;
            Control[] children = this.textFieldsComposite.getChildren();
            for (currentColumn = 0; currentColumn < this.numberOfVisibleColumns - 1 && !children[currentColumn * 4 + 1].equals(clickedButton); ++currentColumn) {
            }
            String edgeName = ((Text)children[(this.numberOfVisibleColumns - 1) * 4 + 2]).getText();
            for (int i = this.numberOfVisibleColumns - 1; i > currentColumn; --i) {
                ((Text)children[i * 4 + 2]).setText(((Text)children[(i - 1) * 4 + 2]).getText());
            }
            ((Text)children[currentColumn * 4 + 2]).setText(edgeName);
        }));
    }

    private void removeColumn(boolean saveNames) {
        Control[] children = this.textFieldsComposite.getChildren();
        int i = this.numberOfVisibleColumns * 4 - 1;
        if (saveNames) {
            String name = ((Text)children[i - 1]).getText();
            if (name != null && name != "") {
                this.cachedNames.push(name);
            }
            this.columnNamesList.get(this.selectedRegex).remove(this.numberOfVisibleColumns - 1);
        }
        children[i].dispose();
        children[i - 1].dispose();
        children[i - 2].dispose();
        children[i - 3].dispose();
        if (this.numberOfVisibleColumns > 2) {
            children[i - 6].setVisible(false);
            children[i - 7].setVisible(false);
        }
        --this.numberOfVisibleColumns;
        this.textFieldsComposite.layout();
        this.textFieldsComposite.pack();
    }

    private String findBadGraphs(int regex) {
        boolean foundBadID = false;
        boolean foundRemoved = false;
        int numberOfColumns = this.columnNamesList.get(regex).size();
        for (GraphData gd : this.graphsDataList.get(regex)) {
            boolean singleBadID = false;
            boolean singleRemoved = false;
            if (GraphFactory.getGraphName((String)gd.graphID) == null) {
                singleBadID = true;
            } else {
                if (gd.xSeries >= numberOfColumns) {
                    singleRemoved = true;
                }
                for (int s = 0; s < gd.ySeries.length && !singleRemoved; ++s) {
                    if (gd.ySeries[s] < numberOfColumns) continue;
                    singleRemoved = true;
                }
            }
            if (singleRemoved || singleBadID) {
                if (!this.badGraphs.contains(gd)) {
                    this.badGraphs.add(gd);
                    this.setUpGraphTableItem(this.findGraphTableItem(gd), null, true);
                }
            } else if (this.badGraphs.contains(gd)) {
                this.badGraphs.remove(gd);
                this.setUpGraphTableItem(this.findGraphTableItem(gd), null, false);
            }
            foundBadID |= singleBadID;
            foundRemoved |= singleRemoved;
        }
        if (numberOfColumns == 0) {
            return Messages.SystemTapScriptGraphOptionsTab_noGroups;
        }
        if (foundBadID) {
            return Messages.SystemTapScriptGraphOptionsTab_badGraphID;
        }
        if (foundRemoved) {
            return Messages.SystemTapScriptGraphOptionsTab_deletedGraphData;
        }
        return null;
    }

    private TableItem findGraphTableItem(GraphData gd) {
        for (TableItem item : this.graphsTable.getItems()) {
            if (!item.getData().equals(gd)) continue;
            return item;
        }
        return null;
    }

    private void setUpGraphTableItem(TableItem item, GraphData gd, boolean bad) {
        if (item == null) {
            return;
        }
        if (gd != null) {
            item.setData((Object)gd);
        } else {
            gd = (GraphData)item.getData();
        }
        item.setForeground(item.getDisplay().getSystemColor(bad ? 3 : 2));
        String graphName = GraphFactory.getGraphName((String)gd.graphID);
        if (graphName == null) {
            graphName = Messages.SystemTapScriptGraphOptionsTab_invalidGraphID;
        }
        item.setText(graphName + ":" + gd.title + (String)(bad ? " " + Messages.SystemTapScriptGraphOptionsTab_invalidGraph : ""));
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(RUN_WITH_CHART, false);
        configuration.setAttribute(NUMBER_OF_REGEXS, 1);
        configuration.setAttribute("numberOfColumns_0", 0);
        configuration.setAttribute("numberOfExtras_0", 0);
        configuration.setAttribute("regularExpression_0", "");
        configuration.setAttribute("sampleOutput_0", "");
        configuration.setAttribute("numberOfGraphs0", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.textListenersEnabled = false;
            this.regularExpressionCombo.removeAll();
            this.outputList.clear();
            this.regexErrorMessages.clear();
            this.columnNamesList.clear();
            this.cachedNamesList.clear();
            this.graphsTable.removeAll();
            this.badGraphs.clear();
            int numberOfRegexs = Math.max(configuration.getAttribute(NUMBER_OF_REGEXS, 1), 1);
            this.removeRegexButton.setEnabled(numberOfRegexs > 1);
            for (int r = 0; r < numberOfRegexs; ++r) {
                this.regularExpressionCombo.add(configuration.getAttribute(REGULAR_EXPRESSION + r, ""));
                this.outputList.add(configuration.getAttribute(SAMPLE_OUTPUT + r, ""));
                int numberOfColumns = configuration.getAttribute(NUMBER_OF_COLUMNS + r, 0);
                ArrayList<String> namelist = new ArrayList<String>(numberOfColumns);
                for (int i = 0; i < numberOfColumns; ++i) {
                    namelist.add(configuration.getAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(REGEX_BOX, r, i), (String)null));
                }
                this.columnNamesList.add(namelist);
                int numberOfExtras = configuration.getAttribute(NUMBER_OF_EXTRAS + r, 0);
                Stack<String> oldnames = new Stack<String>();
                for (int i = 0; i < numberOfExtras; ++i) {
                    oldnames.push(configuration.getAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(EXTRA_BOX, r, i), (String)null));
                }
                this.cachedNamesList.add(oldnames);
                this.regexErrorMessages.add(null);
            }
            if (this.getNumberOfRegexs() < 20) {
                this.regularExpressionCombo.add(Messages.SystemTapScriptGraphOptionsTab_regexAddNew);
            }
            int defaultSelectedRegex = 0 <= this.selectedRegex && this.selectedRegex < numberOfRegexs ? this.selectedRegex : 0;
            this.regularExpressionCombo.select(defaultSelectedRegex);
            this.graphsDataList = SystemTapScriptGraphOptionsTab.createGraphsFromConfiguration(configuration);
            this.graphsData = this.graphsDataList.get(defaultSelectedRegex);
            for (GraphData graphData : this.graphsData) {
                TableItem item = new TableItem(this.graphsTable, 0);
                this.setUpGraphTableItem(item, graphData, true);
            }
            this.updateRegexSelection(defaultSelectedRegex, true);
            this.checkAllOtherErrors();
            boolean chart = configuration.getAttribute(RUN_WITH_CHART, false);
            this.setGraphingEnabled(chart);
            this.runWithChartCheckButton.setSelection(chart);
        }
        catch (CoreException e) {
            ExceptionErrorDialog.openError((String)Messages.SystemTapScriptGraphOptionsTab_cantInitializeTab, (Exception)((Object)e));
        }
        finally {
            this.textListenersEnabled = true;
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(RUN_WITH_CHART, this.runWithChartCheckButton.getSelection());
        int numberOfRegexs = this.getNumberOfRegexs();
        for (int r = 0; r < numberOfRegexs; ++r) {
            configuration.setAttribute(REGULAR_EXPRESSION + r, this.regularExpressionCombo.getItem(r));
            configuration.setAttribute(SAMPLE_OUTPUT + r, this.outputList.get(r));
            List<String> columnNames = this.columnNamesList.get(r);
            int numberOfColumns = columnNames.size();
            for (int i = 0; i < numberOfColumns; ++i) {
                configuration.setAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(REGEX_BOX, r, i), columnNames.get(i));
            }
            this.cleanUpConfigurationItem(configuration, NUMBER_OF_COLUMNS, REGEX_BOX, r, numberOfColumns);
            configuration.setAttribute(NUMBER_OF_COLUMNS + r, numberOfColumns);
            Stack<String> extranames = this.cachedNamesList.get(r);
            int numberOfExtras = this.findBadGraphs(r) == null ? 0 : extranames.size();
            for (int i = 0; i < numberOfExtras; ++i) {
                configuration.setAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(EXTRA_BOX, r, i), (String)extranames.get(i));
            }
            this.cleanUpConfigurationItem(configuration, NUMBER_OF_EXTRAS, EXTRA_BOX, r, numberOfExtras);
            configuration.setAttribute(NUMBER_OF_EXTRAS + r, numberOfExtras);
            LinkedList<GraphData> list = this.graphsDataList.get(r);
            int numberOfGraphs = list.size();
            for (int i = 0; i < numberOfGraphs; ++i) {
                GraphData graphData = list.get(i);
                configuration.setAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_TITLE, r, i), graphData.title);
                configuration.setAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_KEY, r, i), graphData.key);
                configuration.setAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_X_SERIES, r, i), graphData.xSeries);
                configuration.setAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_ID, r, i), graphData.graphID);
                int ySeriesLength = graphData.ySeries.length;
                for (int j = 0; j < ySeriesLength; ++j) {
                    configuration.setAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_Y_SERIES, r, i + "_" + j), graphData.ySeries[j]);
                }
                this.cleanUpConfigurationGraphYSeries(configuration, r, i, ySeriesLength);
                configuration.setAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_Y_SERIES_LENGTH, r, i), ySeriesLength);
            }
            this.cleanUpConfigurationGraphs(configuration, r, numberOfGraphs);
            configuration.setAttribute(NUMBER_OF_GRAPHS + r, numberOfGraphs);
        }
        this.cleanUpConfiguration(configuration, numberOfRegexs);
        configuration.setAttribute(NUMBER_OF_REGEXS, numberOfRegexs);
    }

    private void cleanUpConfiguration(ILaunchConfigurationWorkingCopy configuration, int numberOfRegexs) {
        int oldNumberOfRegexs = 0;
        try {
            oldNumberOfRegexs = configuration.getAttribute(NUMBER_OF_REGEXS, 0);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        for (int r = numberOfRegexs; r < oldNumberOfRegexs; ++r) {
            configuration.removeAttribute(REGULAR_EXPRESSION + r);
            configuration.removeAttribute(SAMPLE_OUTPUT + r);
            this.cleanUpConfigurationItem(configuration, NUMBER_OF_COLUMNS, REGEX_BOX, r, 0);
            configuration.removeAttribute(NUMBER_OF_COLUMNS + r);
            this.cleanUpConfigurationItem(configuration, NUMBER_OF_COLUMNS, EXTRA_BOX, r, 0);
            configuration.removeAttribute(NUMBER_OF_EXTRAS + r);
            this.cleanUpConfigurationGraphs(configuration, r, 0);
            configuration.removeAttribute(NUMBER_OF_GRAPHS + r);
        }
    }

    private void cleanUpConfigurationGraphs(ILaunchConfigurationWorkingCopy configuration, int regex, int newNumberOfGraphs) {
        int oldNumberOfGraphs = 0;
        try {
            oldNumberOfGraphs = configuration.getAttribute(NUMBER_OF_GRAPHS + regex, 0);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        for (int i = newNumberOfGraphs; i < oldNumberOfGraphs; ++i) {
            configuration.removeAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_TITLE, regex, i));
            configuration.removeAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_KEY, regex, i));
            configuration.removeAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_X_SERIES, regex, i));
            configuration.removeAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_ID, regex, i));
            this.cleanUpConfigurationGraphYSeries(configuration, regex, i, 0);
            configuration.removeAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_Y_SERIES_LENGTH, regex, i));
        }
    }

    private void cleanUpConfigurationItem(ILaunchConfigurationWorkingCopy configuration, String counter, String property, int regex, int newNumberOfItems) {
        int oldNumberOfItems = 0;
        try {
            oldNumberOfItems = configuration.getAttribute(counter + regex, 0);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        for (int i = newNumberOfItems; i < oldNumberOfItems; ++i) {
            configuration.removeAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(property, regex, i));
        }
    }

    private void cleanUpConfigurationGraphYSeries(ILaunchConfigurationWorkingCopy configuration, int regex, int graph, int newLength) {
        int oldYSeriesLength = 0;
        try {
            oldYSeriesLength = configuration.getAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_Y_SERIES_LENGTH, regex, graph), 0);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        for (int i = newLength; i < oldYSeriesLength; ++i) {
            configuration.removeAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_Y_SERIES, regex, graph + "_" + i));
        }
    }

    private void checkAllOtherErrors() {
        int n = this.getNumberOfRegexs();
        for (int i = 0; i < n; ++i) {
            if (i == this.selectedRegex) continue;
            this.checkErrors(i);
        }
    }

    private void checkErrors(int i) {
        String regex = this.regularExpressionCombo.getItem(i);
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            this.regexErrorMessages.set(i, e.getMessage());
            return;
        }
        String error = this.findBadGraphs(i);
        if (error == null) {
            error = SystemTapScriptGraphOptionsTab.checkRegex(regex);
        }
        this.regexErrorMessages.set(i, error);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        if (!this.graphingEnabled) {
            return true;
        }
        int n = this.getNumberOfRegexs();
        for (int r = 0; r < n; ++r) {
            String regexErrorMessage = this.regexErrorMessages.get(r);
            if (regexErrorMessage == null) continue;
            this.setErrorMessage(MessageFormat.format(Messages.SystemTapScriptGraphOptionsTab_regexErrorMsgFormat, this.regularExpressionCombo.getItems()[r], regexErrorMessage));
            return false;
        }
        return true;
    }

    public static boolean isValidLaunch(ILaunchConfiguration launchConfig) throws CoreException {
        if (!launchConfig.getAttribute(RUN_WITH_CHART, false)) {
            return true;
        }
        int n = launchConfig.getAttribute(NUMBER_OF_REGEXS, 1);
        for (int r = 0; r < n; ++r) {
            String regex = launchConfig.getAttribute(REGULAR_EXPRESSION + r, (String)null);
            if (regex == null || SystemTapScriptGraphOptionsTab.checkRegex(regex) != null) {
                return false;
            }
            try {
                Pattern.compile(regex);
            }
            catch (PatternSyntaxException e) {
                return false;
            }
            int numberOfColumns = launchConfig.getAttribute(NUMBER_OF_COLUMNS + r, 0);
            if (numberOfColumns == 0) {
                return false;
            }
            int g = launchConfig.getAttribute(NUMBER_OF_GRAPHS + r, 0);
            for (int i = 0; i < g; ++i) {
                if (GraphFactory.getGraphName((String)launchConfig.getAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_ID, r, i), (String)null)) == null) {
                    return false;
                }
                if (launchConfig.getAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_X_SERIES, r, i), 0) >= numberOfColumns) {
                    return false;
                }
                int y = launchConfig.getAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_Y_SERIES_LENGTH, r, i), 0);
                for (int j = 0; j < y; ++j) {
                    if (launchConfig.getAttribute(SystemTapScriptGraphOptionsTab.get2DConfigData(GRAPH_Y_SERIES, r, i + "_" + j), 0) < numberOfColumns) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public String getName() {
        return Messages.SystemTapScriptGraphOptionsTab_graphingTitle;
    }

    public Image getImage() {
        return ((ImageDescriptor)ResourceLocator.imageDescriptorFromBundle((String)"org.eclipse.linuxtools.systemtap.ui.ide", (String)"icons/graphing_tab.gif").get()).createImage();
    }

    private void setGraphingEnabled(boolean enabled) {
        this.graphingEnabled = enabled;
        this.setControlEnabled((Composite)this.outputParsingGroup, enabled);
        this.setControlEnabled((Composite)this.graphsGroup, enabled);
        this.setSelectionControlsEnabled(this.selectedTableItem != null);
        this.addGraphButton.setEnabled(enabled && this.numberOfVisibleColumns > 0);
        this.removeRegexButton.setEnabled(enabled && this.getNumberOfRegexs() > 1);
        this.updateLaunchConfigurationDialog();
    }

    private void setControlEnabled(Composite composite, boolean enabled) {
        composite.setEnabled(enabled);
        for (Control child : composite.getChildren()) {
            child.setEnabled(enabled);
            if (!(child instanceof Composite)) continue;
            this.setControlEnabled((Composite)child, enabled);
        }
    }

    private void setSelectionControlsEnabled(boolean enabled) {
        this.duplicateGraphButton.setEnabled(enabled);
        this.editGraphButton.setEnabled(enabled && this.numberOfVisibleColumns > 0);
        this.removeGraphButton.setEnabled(enabled);
    }
}

